/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.shadow.io.xol.enklume;

import com.sinthoras.visualprospecting.shadow.io.xol.enklume.MinecraftChunk;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class MinecraftRegion {
    int[] locations = new int[1024];
    int[] sizes = new int[1024];
    RandomAccessFile is;
    private final MinecraftChunk[][] chunks = new MinecraftChunk[32][32];

    public MinecraftRegion(File regionFile) throws IOException, DataFormatException {
        this.is = new RandomAccessFile(regionFile, "r");
        int i = 0;
        while (i < 1024) {
            int n = i;
            this.locations[n] = this.locations[n] + (this.is.read() << 16);
            int n2 = i;
            this.locations[n2] = this.locations[n2] + (this.is.read() << 8);
            int n3 = i;
            this.locations[n3] = this.locations[n3] + this.is.read();
            int n4 = i++;
            this.sizes[n4] = this.sizes[n4] + this.is.read();
        }
        byte[] osef = new byte[4];
        for (int i2 = 0; i2 < 1024; ++i2) {
            this.is.read(osef);
        }
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                this.chunks[x][z] = this.getChunkInternal(x, z);
            }
        }
    }

    int offset(int x, int z) {
        return (x & 0x1F) + (z & 0x1F) * 32;
    }

    public MinecraftChunk getChunk(int x, int z) {
        return this.chunks[x][z];
    }

    private MinecraftChunk getChunkInternal(int x, int z) throws DataFormatException, IOException {
        int l = this.offset(x, z);
        if (this.sizes[l] > 0) {
            this.is.seek((long)this.locations[l] * 4096L);
            int compressedLength = 0;
            compressedLength += this.is.read() << 24;
            compressedLength += this.is.read() << 16;
            compressedLength += this.is.read() << 8;
            compressedLength += this.is.read();
            int compression = this.is.read();
            if (compression != 2) {
                throw new DataFormatException("\"Fatal error : compression scheme not Zlib. (\" + compression + \") at \" + is.getFilePointer() + \" l = \" + l + \" s= \" + sizes[l]");
            }
            byte[] compressedData = new byte[compressedLength];
            this.is.read(compressedData);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Inflater inflater = new Inflater();
            inflater.setInput(compressedData);
            byte[] buffer = new byte[4096];
            while (!inflater.finished()) {
                int c = inflater.inflate(buffer);
                baos.write(buffer, 0, c);
            }
            baos.close();
            return new MinecraftChunk(x, z, baos.toByteArray());
        }
        return new MinecraftChunk(x, z);
    }

    public void close() throws IOException {
        this.is.close();
    }
}

