/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.integration.DrawUtils;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import com.sinthoras.visualprospecting.integration.model.locations.OreVeinLocation;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps.InteractableRenderStep;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class OreVeinRenderStep
implements InteractableRenderStep {
    private final OreVeinLocation oreVeinLocation;
    private final ResourceLocation depletedTextureLocation = new ResourceLocation("visualprospecting", "textures/depleted.png");
    private final IIcon blockStoneIcon = Blocks.field_150348_b.func_149691_a(0, 0);
    private final double iconSize = 32.0;
    private double iconX;
    private double iconY;

    public OreVeinRenderStep(OreVeinLocation veinPosition) {
        this.oreVeinLocation = veinPosition;
    }

    @Override
    public void draw(GuiScreen gui, double cameraX, double cameraZ, double scale) {
        double iconSizeHalf = 16.0;
        double scaleForGui = Math.max(1.0, scale);
        this.iconX = (this.oreVeinLocation.getBlockX() - 0.5 - cameraX) * scaleForGui - 16.0;
        this.iconY = (this.oreVeinLocation.getBlockZ() - 0.5 - cameraZ) * scaleForGui - 16.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.oreVeinLocation.getBlockX() - 0.5 - cameraX), (double)(this.oreVeinLocation.getBlockZ() - 0.5 - cameraZ), (double)0.0);
        GL11.glScaled((double)(1.0 / scaleForGui), (double)(1.0 / scaleForGui), (double)1.0);
        DrawUtils.drawQuad(this.blockStoneIcon, -16.0, -16.0, 32.0, 32.0, 0xFFFFFF, 255.0f);
        DrawUtils.drawQuad(this.oreVeinLocation.getIconFromPrimaryOre(), -16.0, -16.0, 32.0, 32.0, this.oreVeinLocation.getColor(), 255.0f);
        if (!this.oreVeinLocation.drawSearchHighlight() || this.oreVeinLocation.isDepleted()) {
            DrawUtils.drawGradientRect(-16.0, -16.0, 16.0, 16.0, 0.0, -1778384896, -1778384896);
            if (this.oreVeinLocation.isDepleted()) {
                DrawUtils.drawQuad(this.depletedTextureLocation, -16.0, -16.0, 32.0, 32.0, 0xFFFFFF, 255.0f);
            }
        }
        if (scale >= Utils.journeyMapScaleToLinear(Config.minZoomLevelForOreLabel) && !this.oreVeinLocation.isDepleted()) {
            int fontColor = this.oreVeinLocation.drawSearchHighlight() ? -1 : -8421505;
            String text = I18n.func_135052_a((String)this.oreVeinLocation.getName(), (Object[])new Object[0]);
            DrawUtils.drawSimpleLabel(gui, text, 0.0, -16.0 - (double)gui.field_146297_k.field_71466_p.field_78288_b - 5.0, fontColor, -1275068416, true);
        }
        if (this.oreVeinLocation.isActiveAsWaypoint()) {
            double thickness = 4.0;
            int color = -10496;
            DrawUtils.drawGradientRect(-20.0, -20.0, 16.0, -16.0, 0.0, -10496, -10496);
            DrawUtils.drawGradientRect(16.0, -20.0, 20.0, 16.0, 0.0, -10496, -10496);
            DrawUtils.drawGradientRect(-16.0, 16.0, 20.0, 20.0, 0.0, -10496, -10496);
            DrawUtils.drawGradientRect(-20.0, -16.0, -16.0, 20.0, 0.0, -10496, -10496);
        }
        GL11.glPopMatrix();
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY, double scale) {
        double scaleForGui = Math.max(1.0, scale);
        return (mouseX *= scaleForGui) >= this.iconX && (mouseY *= scaleForGui) >= this.iconY && mouseX <= this.iconX + 32.0 && mouseY <= this.iconY + 32.0;
    }

    @Override
    public void drawTooltip(GuiScreen gui, double mouseX, double mouseY, double scale, int scaleAdj) {
        mouseX = mouseX * scale + (double)(gui.field_146297_k.field_71443_c >> 1);
        mouseY = mouseY * scale + (double)(gui.field_146297_k.field_71440_d >> 1);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (this.oreVeinLocation.isDepleted()) {
            tooltip.add(this.oreVeinLocation.getDepletedHint());
        }
        if (this.oreVeinLocation.isActiveAsWaypoint()) {
            tooltip.add(this.oreVeinLocation.getActiveWaypointHint());
        }
        tooltip.add(this.oreVeinLocation.getName());
        if (!this.oreVeinLocation.isDepleted()) {
            tooltip.addAll(this.oreVeinLocation.getMaterialNames());
        }
        tooltip.add(this.oreVeinLocation.getToggleDepletedHint());
        GL11.glPushMatrix();
        DrawUtils.drawSimpleTooltip(gui, tooltip, mouseX / (double)scaleAdj + 6.0, mouseY / (double)scaleAdj - 12.0, -1, -2046820352);
        GL11.glPopMatrix();
    }

    @Override
    public void onActionButton() {
        this.oreVeinLocation.toggleOreVein();
    }

    @Override
    public IWaypointAndLocationProvider getLocationProvider() {
        return this.oreVeinLocation;
    }
}

