/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;

public class DrawUtils {
    public static void drawGradientRect(double minPixelX, double minPixelY, double maxPixelX, double maxPixelY, double z, int colorA, int colorB) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        float alpha = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float red = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float green = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colorA & 0xFF) / 255.0f;
        tessellator.func_78369_a(red, green, blue, alpha);
        tessellator.func_78377_a(maxPixelX, minPixelY, z);
        tessellator.func_78377_a(minPixelX, minPixelY, z);
        alpha = (float)(colorB >> 24 & 0xFF) / 255.0f;
        red = (float)(colorB >> 16 & 0xFF) / 255.0f;
        green = (float)(colorB >> 8 & 0xFF) / 255.0f;
        blue = (float)(colorB & 0xFF) / 255.0f;
        tessellator.func_78369_a(red, green, blue, alpha);
        tessellator.func_78377_a(minPixelX, maxPixelY, z);
        tessellator.func_78377_a(maxPixelX, maxPixelY, z);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawGradientRect(double minPixelX, double minPixelY, double maxPixelX, double maxPixelY, int colorA, int colorB) {
        DrawUtils.drawGradientRect(minPixelX, minPixelY, maxPixelX, maxPixelY, 300.0, colorA, colorB);
    }

    public static void drawQuad(ResourceLocation texture, double x, double y, double width, double height, int color, float alpha) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        float[] c = DrawUtils.floats(color);
        GL11.glColor4f((float)c[0], (float)c[1], (float)c[2], (float)alpha);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawQuad(IIcon icon, double x, double y, double width, double height, int color, float alpha) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        float[] c = DrawUtils.floats(color);
        GL11.glColor4f((float)c[0], (float)c[1], (float)c[2], (float)alpha);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y + height, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a(x + width, y + height, 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a(x + width, y, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a(x, y, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    public static void drawAspect(double centerPixelX, double centerPixelY, double pixelSize, Aspect aspect, int amount) {
        int textureSize = 16;
        GL11.glPushMatrix();
        double scale = pixelSize / 16.0;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        UtilsFX.drawTag((double)((centerPixelX - pixelSize / 2.0) / scale), (double)((centerPixelY - pixelSize / 2.0) / scale), (Aspect)aspect, (float)amount, (int)0, (double)0.0, (int)771, (float)1.0f, (boolean)false);
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    public static void drawSimpleLabel(GuiScreen gui, String text, double textX, double textY, int fontColor, int bgColor, boolean centered) {
        GL11.glPushMatrix();
        double dTextX = textX - (double)((int)textX);
        double dTextY = textY - (double)((int)textY);
        double textWidth = gui.field_146297_k.field_71466_p.func_78256_a(text);
        double xOffsetL = centered ? -textWidth / 2.0 - 2.0 : -2.0;
        double xOffsetR = centered ? textWidth / 2.0 + 2.0 : textWidth + 2.0;
        GL11.glTranslated((double)dTextX, (double)dTextY, (double)0.0);
        DrawUtils.drawGradientRect((double)((int)textX) + xOffsetL, (int)textY - 2, (double)((int)textX) + xOffsetR, (int)textY + gui.field_146297_k.field_71466_p.field_78288_b + 2, 0.0, bgColor, bgColor);
        if (centered) {
            gui.func_73732_a(gui.field_146297_k.field_71466_p, text, (int)textX, (int)textY, fontColor);
        } else {
            gui.func_73731_b(gui.field_146297_k.field_71466_p, text, (int)textX, (int)textY, fontColor);
        }
        GL11.glPopMatrix();
    }

    public static void drawSimpleTooltip(GuiScreen gui, List<String> text, double x, double y, int fontColor, int bgColor) {
        if (text.isEmpty()) {
            return;
        }
        int maxTextWidth = 0;
        for (String str : text) {
            int strWidth = gui.field_146297_k.field_71466_p.func_78256_a(str);
            if (strWidth <= maxTextWidth) continue;
            maxTextWidth = strWidth;
        }
        int boxWidth = maxTextWidth + 6;
        int boxHeight = text.size() * (gui.field_146297_k.field_71466_p.field_78288_b + 2) + 6;
        double dx = x - (double)((int)x);
        double dy = y - (double)((int)y);
        GL11.glPushMatrix();
        DrawUtils.drawGradientRect(x, y, x + (double)boxWidth, y + (double)boxHeight, bgColor, bgColor);
        GL11.glTranslated((double)dx, (double)dy, (double)301.0);
        for (int i = 0; i < text.size(); ++i) {
            gui.func_73731_b(gui.field_146297_k.field_71466_p, text.get(i), (int)x + 3, (int)y + 3 + i * (gui.field_146297_k.field_71466_p.field_78288_b + 2), fontColor);
        }
        GL11.glPopMatrix();
    }

    public static float[] floats(int rgb) {
        return new float[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
    }
}

