/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class DimensionCache {
    private final Map<Long, OreVeinPosition> oreChunks = new HashMap<Long, OreVeinPosition>();
    private final Map<Long, UndergroundFluidPosition> undergroundFluids = new HashMap<Long, UndergroundFluidPosition>();
    private final Set<Long> changedOrNewOreChunks = new HashSet<Long>();
    private final Set<Long> changedOrNewUndergroundFluids = new HashSet<Long>();
    private boolean oreChunksNeedsSaving = false;
    private boolean undergroundFluidsNeedsSaving = false;
    public final int dimensionId;

    public DimensionCache(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public ByteBuffer saveOreChunks() {
        if (this.oreChunksNeedsSaving) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.changedOrNewOreChunks.size() * 10);
            for (long key : this.changedOrNewOreChunks) {
                byteBuffer.putLong(key);
                OreVeinPosition oreVeinPosition = this.oreChunks.get(key);
                short veinTypeId = VeinTypeCaching.getVeinTypeId(oreVeinPosition.veinType);
                if (oreVeinPosition.isDepleted()) {
                    veinTypeId = (short)(veinTypeId | 0x8000);
                }
                byteBuffer.putShort(veinTypeId);
            }
            this.oreChunksNeedsSaving = false;
            this.changedOrNewOreChunks.clear();
            byteBuffer.flip();
            return byteBuffer;
        }
        return null;
    }

    public ByteBuffer saveUndergroundFluids() {
        if (this.undergroundFluidsNeedsSaving) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.changedOrNewUndergroundFluids.size() * 268);
            for (long key : this.changedOrNewUndergroundFluids) {
                byteBuffer.putLong(key);
                UndergroundFluidPosition undergroundFluid = this.undergroundFluids.get(key);
                byteBuffer.putInt(undergroundFluid.fluid.getID());
                for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                    for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                        byteBuffer.putInt(undergroundFluid.chunks[offsetChunkX][offsetChunkZ]);
                    }
                }
            }
            this.undergroundFluidsNeedsSaving = false;
            this.changedOrNewUndergroundFluids.clear();
            byteBuffer.flip();
            return byteBuffer;
        }
        return null;
    }

    public void loadCache(ByteBuffer oreChunksBuffer, ByteBuffer undergroundFluidsBuffer) {
        int chunkZ;
        int chunkX;
        long key;
        if (oreChunksBuffer != null) {
            while (oreChunksBuffer.remaining() >= 10) {
                key = oreChunksBuffer.getLong();
                chunkX = (int)(key >> 32);
                chunkZ = (int)key;
                short veinTypeId = oreChunksBuffer.getShort();
                boolean depleted = (veinTypeId & 0x8000) > 0;
                VeinType veinType = VeinTypeCaching.getVeinType((short)(veinTypeId & Short.MAX_VALUE));
                this.oreChunks.put(key, new OreVeinPosition(this.dimensionId, chunkX, chunkZ, veinType, depleted));
            }
        }
        if (undergroundFluidsBuffer != null) {
            while (undergroundFluidsBuffer.remaining() >= 268) {
                key = undergroundFluidsBuffer.getLong();
                chunkX = (int)(key >> 32);
                chunkZ = (int)key;
                Fluid fluid = FluidRegistry.getFluid((int)undergroundFluidsBuffer.getInt());
                int[][] chunks = new int[8][8];
                for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                    for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                        chunks[offsetChunkX][offsetChunkZ] = undergroundFluidsBuffer.getInt();
                    }
                }
                this.undergroundFluids.put(key, new UndergroundFluidPosition(this.dimensionId, chunkX, chunkZ, fluid, chunks));
            }
        }
    }

    private long getOreVeinKey(int chunkX, int chunkZ) {
        return Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(chunkX), Utils.mapToCenterOreChunkCoord(chunkZ));
    }

    public UpdateResult putOreVein(OreVeinPosition oreVeinPosition) {
        long key = this.getOreVeinKey(oreVeinPosition.chunkX, oreVeinPosition.chunkZ);
        if (!this.oreChunks.containsKey(key)) {
            this.oreChunks.put(key, oreVeinPosition);
            this.changedOrNewOreChunks.add(key);
            this.oreChunksNeedsSaving = true;
            return UpdateResult.New;
        }
        OreVeinPosition storedOreVeinPosition = this.oreChunks.get(key);
        if (storedOreVeinPosition.veinType != oreVeinPosition.veinType) {
            this.oreChunks.put(key, oreVeinPosition.joinDepletedState(storedOreVeinPosition));
            this.changedOrNewOreChunks.add(key);
            this.oreChunksNeedsSaving = true;
            return UpdateResult.New;
        }
        return UpdateResult.AlreadyKnown;
    }

    public void toggleOreVein(int chunkX, int chunkZ) {
        long key = this.getOreVeinKey(chunkX, chunkZ);
        if (this.oreChunks.containsKey(key)) {
            this.oreChunks.get(key).toggleDepleted();
        }
        this.changedOrNewOreChunks.add(key);
        this.oreChunksNeedsSaving = true;
    }

    public OreVeinPosition getOreVein(int chunkX, int chunkZ) {
        long key = this.getOreVeinKey(chunkX, chunkZ);
        return this.oreChunks.getOrDefault(key, new OreVeinPosition(this.dimensionId, chunkX, chunkZ, VeinType.NO_VEIN, true));
    }

    private long getUndergroundFluidKey(int chunkX, int chunkZ) {
        return Utils.chunkCoordsToKey(Utils.mapToCornerUndergroundFluidChunkCoord(chunkX), Utils.mapToCornerUndergroundFluidChunkCoord(chunkZ));
    }

    public UpdateResult putUndergroundFluid(UndergroundFluidPosition undergroundFluid) {
        long key = this.getUndergroundFluidKey(undergroundFluid.chunkX, undergroundFluid.chunkZ);
        if (!this.undergroundFluids.containsKey(key)) {
            this.changedOrNewUndergroundFluids.add(key);
            this.undergroundFluids.put(key, undergroundFluid);
            this.undergroundFluidsNeedsSaving = true;
            return UpdateResult.New;
        }
        if (!this.undergroundFluids.get(key).equals(undergroundFluid)) {
            this.changedOrNewUndergroundFluids.add(key);
            this.undergroundFluids.put(key, undergroundFluid);
            this.undergroundFluidsNeedsSaving = true;
            return UpdateResult.Updated;
        }
        return UpdateResult.AlreadyKnown;
    }

    public UndergroundFluidPosition getUndergroundFluid(int chunkX, int chunkZ) {
        long key = this.getUndergroundFluidKey(chunkX, chunkZ);
        return this.undergroundFluids.getOrDefault(key, UndergroundFluidPosition.getNotProspected(this.dimensionId, chunkX, chunkZ));
    }

    public Collection<OreVeinPosition> getAllOreVeins() {
        return this.oreChunks.values();
    }

    public Collection<UndergroundFluidPosition> getAllUndergroundFluids() {
        return this.undergroundFluids.values();
    }

    public static enum UpdateResult {
        AlreadyKnown,
        Updated,
        New;

    }
}

