/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.DimensionCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.database.WorldCache;
import com.sinthoras.visualprospecting.network.ProspectingRequest;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ClientCache
extends WorldCache {
    public static final ClientCache instance = new ClientCache();

    @Override
    protected File getStorageDirectory() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        return new File(Utils.getSubDirectory("visualprospecting/client/"), player.getDisplayName() + "_" + player.getPersistentID().toString());
    }

    private void notifyNewOreVein(OreVeinPosition oreVeinPosition) {
        String location = "(" + (oreVeinPosition.getBlockX() + 8) + "," + (oreVeinPosition.getBlockZ() + 8) + ")";
        ChatComponentTranslation veinNotification = new ChatComponentTranslation("visualprospecting.vein.prospected", new Object[]{I18n.func_135052_a((String)oreVeinPosition.veinType.name, (Object[])new Object[0]), location});
        veinNotification.func_150256_b().func_150217_b(Boolean.valueOf(true));
        veinNotification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)veinNotification);
        String oreNames = String.join((CharSequence)", ", oreVeinPosition.veinType.getOreMaterialNames());
        ChatComponentTranslation oresNotification = new ChatComponentTranslation("visualprospecting.vein.contents", new Object[]{oreNames});
        oresNotification.func_150256_b().func_150217_b(Boolean.valueOf(true));
        oresNotification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)oresNotification);
    }

    public void putOreVeins(List<OreVeinPosition> oreVeinPositions) {
        if (oreVeinPositions.size() == 1) {
            OreVeinPosition oreVeinPosition = oreVeinPositions.get(0);
            if (this.putOreVein(oreVeinPosition) != DimensionCache.UpdateResult.AlreadyKnown) {
                this.notifyNewOreVein(oreVeinPosition);
            }
        } else if (oreVeinPositions.size() > 1) {
            int newOreVeins = 0;
            for (OreVeinPosition oreVeinPosition : oreVeinPositions) {
                if (this.putOreVein(oreVeinPosition) == DimensionCache.UpdateResult.AlreadyKnown) continue;
                ++newOreVeins;
            }
            if (newOreVeins > 0) {
                ChatComponentTranslation oreVeinNotification = new ChatComponentTranslation("visualprospecting.veins.prospected", new Object[]{newOreVeins});
                oreVeinNotification.func_150256_b().func_150217_b(Boolean.valueOf(true));
                oreVeinNotification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)oreVeinNotification);
            }
        }
    }

    @Override
    public void toggleOreVein(int dimensionId, int chunkX, int chunkZ) {
        super.toggleOreVein(dimensionId, chunkX, chunkZ);
    }

    public void putUndergroundFluids(List<UndergroundFluidPosition> undergroundFluids) {
        ChatComponentTranslation undergroundFluidsNotification;
        int newUndergroundFluids = 0;
        int updatedUndergroundFluids = 0;
        for (UndergroundFluidPosition undergroundFluidPosition : undergroundFluids) {
            DimensionCache.UpdateResult updateResult = this.putUndergroundFluids(undergroundFluidPosition);
            if (updateResult == DimensionCache.UpdateResult.New) {
                ++newUndergroundFluids;
            }
            if (updateResult != DimensionCache.UpdateResult.Updated) continue;
            ++updatedUndergroundFluids;
        }
        if (newUndergroundFluids > 0 && updatedUndergroundFluids > 0) {
            undergroundFluidsNotification = new ChatComponentTranslation("visualprospecting.undergroundfluid.prospected.newandupdated", new Object[]{newUndergroundFluids, updatedUndergroundFluids});
            undergroundFluidsNotification.func_150256_b().func_150217_b(Boolean.valueOf(true));
            undergroundFluidsNotification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)undergroundFluidsNotification);
        } else {
            if (newUndergroundFluids > 0) {
                undergroundFluidsNotification = new ChatComponentTranslation("visualprospecting.undergroundfluid.prospected.onlynew", new Object[]{newUndergroundFluids});
                undergroundFluidsNotification.func_150256_b().func_150217_b(Boolean.valueOf(true));
                undergroundFluidsNotification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)undergroundFluidsNotification);
            }
            if (updatedUndergroundFluids > 0) {
                undergroundFluidsNotification = new ChatComponentTranslation("visualprospecting.undergroundfluid.prospected.onlyupdated", new Object[]{updatedUndergroundFluids});
                undergroundFluidsNotification.func_150256_b().func_150217_b(Boolean.valueOf(true));
                undergroundFluidsNotification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)undergroundFluidsNotification);
            }
        }
    }

    public void onOreInteracted(World world, int blockX, int blockY, int blockZ, EntityPlayer entityPlayer) {
        short oreMetaData;
        TileEntity tTileEntity;
        if (world.field_72995_K && Config.enableProspecting && Minecraft.func_71410_x().field_71439_g == entityPlayer && (tTileEntity = world.func_147438_o(blockX, blockY, blockZ)) instanceof GT_TileEntity_Ores && !Utils.isSmallOreId(oreMetaData = ((GT_TileEntity_Ores)tTileEntity).mMetaData) && oreMetaData != 0) {
            int chunkX = Utils.coordBlockToChunk(blockX);
            int chunkZ = Utils.coordBlockToChunk(blockZ);
            OreVeinPosition oreVeinPosition = this.getOreVein(entityPlayer.field_71093_bK, chunkX, chunkZ);
            short materialId = Utils.oreIdToMaterialId(oreMetaData);
            if (!oreVeinPosition.veinType.containsOre(materialId) && ProspectingRequest.canSendRequest()) {
                VP.network.sendToServer((IMessage)new ProspectingRequest(entityPlayer.field_71093_bK, blockX, blockY, blockZ, materialId));
            }
        }
    }

    public void resetPlayerProgression() {
        Utils.deleteDirectoryRecursively(this.oreVeinCacheDirectory);
        Utils.deleteDirectoryRecursively(this.undergroundFluidCacheDirectory);
        this.oreVeinCacheDirectory.mkdirs();
        this.undergroundFluidCacheDirectory.mkdirs();
        this.reset();
    }

    public List<OreVeinPosition> getAllOreVeins() {
        ArrayList<OreVeinPosition> allOreVeins = new ArrayList<OreVeinPosition>();
        for (DimensionCache dimension : this.dimensions.values()) {
            allOreVeins.addAll(dimension.getAllOreVeins());
        }
        return allOreVeins;
    }

    public List<UndergroundFluidPosition> getAllUndergroundFluids() {
        ArrayList<UndergroundFluidPosition> allUndergroundFluids = new ArrayList<UndergroundFluidPosition>();
        for (DimensionCache dimension : this.dimensions.values()) {
            allUndergroundFluids.addAll(dimension.getAllUndergroundFluids());
        }
        return allUndergroundFluids;
    }
}

