/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.veintypes;

import com.google.common.collect.ImmutableList;
import com.sinthoras.visualprospecting.database.veintypes.IOreMaterialProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.util.ArrayList;

public class GregTechOreMaterialProvider
implements IOreMaterialProvider {
    private final Materials material;
    private final int primaryOreColor;
    private IIconContainer oreIconContainer;
    private final String primaryOreName;
    private ImmutableList<String> containedOres;

    public GregTechOreMaterialProvider(Materials material) {
        this.material = material;
        this.primaryOreColor = material.mRGBa[0] << 16 | material.mRGBa[1] << 8 | material.mRGBa[2];
        this.primaryOreName = material.mLocalizedName;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconContainer getIconContainer() {
        if (this.oreIconContainer == null) {
            this.oreIconContainer = this.material.mIconSet.mTextures[OrePrefixes.ore.mTextureIndex];
        }
        return this.oreIconContainer;
    }

    @Override
    public int getColor() {
        return this.primaryOreColor;
    }

    @Override
    public String getLocalizedName() {
        return this.primaryOreName;
    }

    @Override
    public ImmutableList<String> getContainedOres(ShortCollection ores) {
        if (this.containedOres == null) {
            short meta;
            ArrayList<String> temp = new ArrayList<String>();
            ShortIterator shortIterator = ores.iterator();
            while (shortIterator.hasNext() && (meta = ((Short)shortIterator.next()).shortValue()) >= 0) {
                Materials material = GregTechAPI.sGeneratedMaterials[meta];
                if (material == null) continue;
                temp.add(material.mLocalizedName);
            }
            this.containedOres = ImmutableList.copyOf(temp);
        }
        return this.containedOres;
    }
}

