/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.DataFormatException;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RegionReader
implements AutoCloseable {
    private final RandomAccessFile is;

    public RegionReader(File regionFile) throws IOException, DataFormatException {
        this.is = new RandomAccessFile(regionFile, "r");
    }

    private int offset(int x, int z) {
        return (x & 0x1F) + (z & 0x1F) * 32;
    }

    @Nullable
    public NBTTagCompound getChunk(int x, int z) throws DataFormatException, IOException {
        return this.getChunkInternal(x, z);
    }

    @Nullable
    public NBTTagList getChunkTiles(int x, int z) {
        try {
            NBTTagCompound chunk = this.getChunkInternal(x, z);
            if (chunk == null) {
                return null;
            }
            NBTTagCompound level = chunk.func_74775_l("Level");
            if (level.func_74764_b("TileEntities")) {
                return level.func_150295_c("TileEntities", 10);
            }
            return null;
        }
        catch (IOException | DataFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    private NBTTagCompound getChunkInternal(int x, int z) throws DataFormatException, IOException {
        int l = this.offset(x, z);
        this.is.seek((long)l * 4L);
        int location = (this.is.read() << 16) + (this.is.read() << 8) + this.is.read();
        int size = this.is.read();
        if (size > 0) {
            this.is.seek((long)location * 4096L);
            int compressedLength = this.is.read() << 24 | this.is.read() << 16 | this.is.read() << 8 | this.is.read();
            int compression = this.is.read();
            if (compression != 2) {
                return null;
            }
            byte[] compressedDataBuffer = new byte[compressedLength];
            this.is.readFully(compressedDataBuffer, 0, compressedLength);
            try (DataInputStream chunkData = new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compressedDataBuffer, 0, compressedLength))));){
                NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74794_a((DataInputStream)chunkData);
                return nBTTagCompound;
            }
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

