/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.Short2IntArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2IntMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ChunkAnalysis {
    private final ObjectSet<VeinType> matchedVeins = new ObjectOpenHashSet();
    private final Short2IntMap oreCounts = new Short2IntArrayMap();
    private int minVeinBlockY = 256;
    private short primaryMeta;
    private final String dimName;

    public ChunkAnalysis(String dimName) {
        this.dimName = dimName;
    }

    public void processMinecraftChunk(NBTTagList tileEntities) {
        if (tileEntities == null || tileEntities.func_74745_c() == 0) {
            return;
        }
        for (int i = 0; i < tileEntities.func_74745_c(); ++i) {
            short meta;
            String id;
            NBTTagCompound tile = tileEntities.func_150305_b(i);
            if (tile == null || !tile.func_74764_b("m") || !"GT_TileEntity_Ores".equals(id = tile.func_74779_i("id")) && !"bw.blockoresTE".equals(id) || Utils.isSmallOreId(meta = tile.func_74765_d("m")) || meta == 0) continue;
            meta = Utils.oreIdToMaterialId(meta);
            int blockY = tile.func_74762_e("y");
            this.oreCounts.put(meta, this.oreCounts.get(meta) + 1);
            if (this.minVeinBlockY <= blockY) continue;
            this.minVeinBlockY = blockY;
        }
        if (this.oreCounts.size() == 1) {
            this.primaryMeta = this.oreCounts.keySet().iterator().nextShort();
        } else if (this.oreCounts.size() > 1) {
            ShortArrayList metaCounts = new ShortArrayList((ShortCollection)this.oreCounts.keySet());
            metaCounts.sort((a, b) -> Integer.compare(this.oreCounts.get(b), this.oreCounts.get(a)));
            this.primaryMeta = metaCounts.getShort(0);
        }
    }

    public boolean matchesSingleVein() {
        if (this.oreCounts.isEmpty()) {
            return true;
        }
        if (this.oreCounts.size() > 4) {
            return false;
        }
        VeinTypeCaching.veinTypes.stream().filter(vein -> vein.containsAllFoundOres((ShortCollection)this.oreCounts.keySet(), this.dimName, this.primaryMeta, this.minVeinBlockY)).forEach(arg_0 -> this.matchedVeins.add(arg_0));
        return this.matchedVeins.size() <= 1;
    }

    public VeinType getMatchedVein() {
        if (this.matchedVeins.isEmpty()) {
            return VeinType.NO_VEIN;
        }
        return (VeinType)this.matchedVeins.iterator().next();
    }

    public int getVeinBlockY() {
        return this.minVeinBlockY;
    }
}

