/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.journeymap.drawsteps;

import com.sinthoras.visualprospecting.integration.model.locations.UndergroundFluidLocation;
import java.awt.geom.Point2D;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import net.minecraft.client.resources.I18n;

public class UndergroundFluidDrawStep
implements DrawStep {
    private final UndergroundFluidLocation undergroundFluidLocation;

    public UndergroundFluidDrawStep(UndergroundFluidLocation undergroundFluidLocation) {
        this.undergroundFluidLocation = undergroundFluidLocation;
    }

    public void draw(double draggedPixelX, double draggedPixelY, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
        int maxAmountInField = this.undergroundFluidLocation.getMaxProduction();
        double blockSize = Math.pow(2.0, gridRenderer.getZoom());
        Point2D.Double blockAsPixel = gridRenderer.getBlockPixelInGrid(this.undergroundFluidLocation.getBlockX(), this.undergroundFluidLocation.getBlockZ());
        Point2D.Double pixel = new Point2D.Double(blockAsPixel.getX() + draggedPixelX, blockAsPixel.getY() + draggedPixelY);
        int borderColor = this.undergroundFluidLocation.getFluid().getColor();
        int borderAlpha = 204;
        DrawUtil.drawRectangle((double)pixel.getX(), (double)pixel.getY(), (double)(128.0 * blockSize), (double)(2.0 * blockSize), (int)borderColor, (int)204);
        DrawUtil.drawRectangle((double)(pixel.getX() + 128.0 * blockSize), (double)pixel.getY(), (double)(2.0 * blockSize), (double)(128.0 * blockSize), (int)borderColor, (int)204);
        DrawUtil.drawRectangle((double)(pixel.getX() + 2.0 * blockSize), (double)(pixel.getY() + 128.0 * blockSize), (double)(128.0 * blockSize), (double)(2.0 * blockSize), (int)borderColor, (int)204);
        DrawUtil.drawRectangle((double)pixel.getX(), (double)(pixel.getY() + 2.0 * blockSize), (double)(2.0 * blockSize), (double)(128.0 * blockSize), (int)borderColor, (int)204);
        String label = I18n.func_135052_a((String)"visualprospecting.empty", (Object[])new Object[0]);
        if (maxAmountInField > 0) {
            label = this.undergroundFluidLocation.getMinProduction() + "L - " + maxAmountInField + "L  " + this.undergroundFluidLocation.getFluid().getLocalizedName();
        }
        DrawUtil.drawLabel((String)label, (double)(pixel.getX() + 16.0 * (blockSize * 4.0)), (double)pixel.getY(), (DrawUtil.HAlign)DrawUtil.HAlign.Center, (DrawUtil.VAlign)DrawUtil.VAlign.Below, (Integer)0, (int)180, (Integer)0xFFFFFF, (int)255, (double)fontScale, (boolean)false, (double)rotation);
    }
}

