/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.locations;

import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import com.sinthoras.visualprospecting.integration.model.waypoints.Waypoint;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import org.lwjgl.input.Keyboard;

public class OreVeinLocation
implements IWaypointAndLocationProvider {
    private static final String depletedHint = EnumChatFormatting.RED + I18n.func_135052_a((String)"visualprospecting.depleted", (Object[])new Object[0]);
    private static final String activeWaypointHint = EnumChatFormatting.GOLD + I18n.func_135052_a((String)"visualprospecting.iswaypoint", (Object[])new Object[0]);
    private static final String toggleDepletedHint = EnumChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"visualprospecting.node.deletehint", (Object[])new Object[]{Keyboard.getKeyName((int)VP.keyAction.func_151463_i())});
    private final OreVeinPosition oreVeinPosition;
    private final String name;
    private final List<String> materialNames;
    private boolean isActiveAsWaypoint;

    public OreVeinLocation(OreVeinPosition oreVeinPosition) {
        this.oreVeinPosition = oreVeinPosition;
        this.name = EnumChatFormatting.WHITE + I18n.func_135052_a((String)oreVeinPosition.veinType.name, (Object[])new Object[0]);
        this.materialNames = oreVeinPosition.veinType.getOreMaterialNames().stream().map(materialName -> EnumChatFormatting.GRAY + materialName).collect(Collectors.toList());
    }

    @Override
    public Waypoint toWaypoint() {
        return new Waypoint(this.oreVeinPosition.getBlockX(), 65, this.oreVeinPosition.getBlockZ(), this.oreVeinPosition.dimensionId, I18n.func_135052_a((String)"visualprospecting.tracked", (Object[])new Object[]{I18n.func_135052_a((String)this.oreVeinPosition.veinType.name, (Object[])new Object[0])}), this.getColor());
    }

    @Override
    public boolean isActiveAsWaypoint() {
        return this.isActiveAsWaypoint;
    }

    @Override
    public void onWaypointCleared() {
        this.isActiveAsWaypoint = false;
    }

    @Override
    public void onWaypointUpdated(Waypoint waypoint) {
        this.isActiveAsWaypoint = waypoint.dimensionId == this.oreVeinPosition.dimensionId && waypoint.blockX == this.oreVeinPosition.getBlockX() && waypoint.blockZ == this.oreVeinPosition.getBlockZ();
    }

    public void toggleOreVein() {
        ClientCache.instance.toggleOreVein(this.oreVeinPosition.dimensionId, this.oreVeinPosition.chunkX, this.oreVeinPosition.chunkZ);
    }

    @Override
    public int getDimensionId() {
        return this.oreVeinPosition.dimensionId;
    }

    @Override
    public double getBlockX() {
        return (double)this.oreVeinPosition.getBlockX() + 0.5;
    }

    @Override
    public double getBlockZ() {
        return (double)this.oreVeinPosition.getBlockZ() + 0.5;
    }

    public boolean isDepleted() {
        return this.oreVeinPosition.isDepleted();
    }

    public String getDepletedHint() {
        return depletedHint;
    }

    public String getActiveWaypointHint() {
        return activeWaypointHint;
    }

    public String getName() {
        return this.name;
    }

    public String getToggleDepletedHint() {
        return toggleDepletedHint;
    }

    public List<String> getMaterialNames() {
        return this.materialNames;
    }

    public boolean drawSearchHighlight() {
        return this.oreVeinPosition.veinType.isHighlighted();
    }

    public int getColor() {
        return this.oreVeinPosition.veinType.oreMaterialProvider.getColor();
    }

    public IIcon getIconFromPrimaryOre() {
        return this.oreVeinPosition.veinType.oreMaterialProvider.getIcon();
    }
}

