/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.layers;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.integration.model.buttons.UndergroundFluidButtonManager;
import com.sinthoras.visualprospecting.integration.model.layers.LayerManager;
import com.sinthoras.visualprospecting.integration.model.locations.ILocationProvider;
import com.sinthoras.visualprospecting.integration.model.locations.UndergroundFluidChunkLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class UndergroundFluidChunkLayerManager
extends LayerManager {
    public static final UndergroundFluidChunkLayerManager instance = new UndergroundFluidChunkLayerManager();
    private int oldMinUndergroundFluidX = 0;
    private int oldMaxUndergroundFluidX = 0;
    private int oldMinUndergroundFluidZ = 0;
    private int oldMaxUndergroundFluidZ = 0;

    public UndergroundFluidChunkLayerManager() {
        super(UndergroundFluidButtonManager.instance);
    }

    @Override
    protected boolean needsRegenerateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        int minUndergroundFluidX = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(minBlockX));
        int minUndergroundFluidZ = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(minBlockZ));
        int maxUndergroundFluidX = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(maxBlockX));
        int maxUndergroundFluidZ = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(maxBlockZ));
        if (minUndergroundFluidX != this.oldMinUndergroundFluidX || maxUndergroundFluidX != this.oldMaxUndergroundFluidX || minUndergroundFluidZ != this.oldMinUndergroundFluidZ || maxUndergroundFluidZ != this.oldMaxUndergroundFluidZ) {
            this.oldMinUndergroundFluidX = minUndergroundFluidX;
            this.oldMaxUndergroundFluidX = maxUndergroundFluidX;
            this.oldMinUndergroundFluidZ = minUndergroundFluidZ;
            this.oldMaxUndergroundFluidZ = maxUndergroundFluidZ;
            return true;
        }
        return false;
    }

    @Override
    protected List<? extends ILocationProvider> generateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        int minUndergroundFluidX = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(minBlockX));
        int minUndergroundFluidZ = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(minBlockZ));
        int maxUndergroundFluidX = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(maxBlockX));
        int maxUndergroundFluidZ = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(maxBlockZ));
        int playerDimensionId = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        ArrayList<UndergroundFluidChunkLocation> undergroundFluidPositions = new ArrayList<UndergroundFluidChunkLocation>();
        for (int chunkX = minUndergroundFluidX; chunkX <= maxUndergroundFluidX; chunkX += 8) {
            for (int chunkZ = minUndergroundFluidZ; chunkZ <= maxUndergroundFluidZ; chunkZ += 8) {
                UndergroundFluidPosition undergroundFluid = ClientCache.instance.getUndergroundFluid(playerDimensionId, chunkX, chunkZ);
                if (!undergroundFluid.isProspected()) continue;
                int minAmountInField = undergroundFluid.getMinProduction();
                int maxAmountInField = undergroundFluid.getMaxProduction();
                for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                    for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                        undergroundFluidPositions.add(new UndergroundFluidChunkLocation(chunkX + offsetChunkX, chunkZ + offsetChunkZ, playerDimensionId, undergroundFluid.fluid, undergroundFluid.chunks[offsetChunkX][offsetChunkZ], minAmountInField, maxAmountInField));
                    }
                }
            }
        }
        return undergroundFluidPositions;
    }
}

