/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.cachebuilder.AnalysisProgressTracker;
import com.sinthoras.visualprospecting.database.cachebuilder.DimensionAnalysis;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.MinecraftWorld;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.zip.DataFormatException;
import net.minecraft.util.ChunkCoordinates;

public class WorldAnalysis {
    private final MinecraftWorld world;

    public WorldAnalysis(File worldDirectory) throws IOException {
        this.world = new MinecraftWorld(worldDirectory);
    }

    public void cacheOverworldSpawnVeins(ChunkCoordinates spawn) throws IOException, DataFormatException {
        VP.info("Starting to parse world save to cache GT vein locations near spawn. This might take some time...");
        ServerCache.instance.resetSpawnChunks(spawn, 0);
        this.cacheVeins(Collections.singletonList(0));
    }

    public void cacheVeins() throws IOException, DataFormatException {
        VP.info("Starting to parse world save to cache GT vein locations. This might take some time...");
        ServerCache.instance.reset();
        this.cacheVeins(this.world.getDimensionIds());
    }

    private void cacheVeins(List<Integer> dimensionIds) throws IOException, DataFormatException {
        AnalysisProgressTracker.setNumberOfDimensions(dimensionIds.size());
        for (int dimensionId : dimensionIds) {
            DimensionAnalysis dimension = new DimensionAnalysis(dimensionId);
            dimension.processMinecraftWorld(this.world);
            AnalysisProgressTracker.dimensionProcessed();
        }
        AnalysisProgressTracker.processingFinished();
        VP.info("Saving ore vein cache...");
        ServerCache.instance.saveVeinCache();
    }
}

