/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.layers;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import com.sinthoras.visualprospecting.integration.model.buttons.OreVeinButtonManager;
import com.sinthoras.visualprospecting.integration.model.layers.WaypointProviderManager;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import com.sinthoras.visualprospecting.integration.model.locations.OreVeinLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class OreVeinLayerManager
extends WaypointProviderManager {
    public static final OreVeinLayerManager instance = new OreVeinLayerManager();
    private int oldMinOreChunkX = 0;
    private int oldMaxOreChunkX = 0;
    private int oldMinOreChunkZ = 0;
    private int oldMaxOreChunkZ = 0;

    public OreVeinLayerManager() {
        super(OreVeinButtonManager.instance);
    }

    @Override
    public void onOpenMap() {
        VeinTypeCaching.recalculateNEISearch();
    }

    @Override
    protected boolean needsRegenerateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        int minOreChunkX = Utils.mapToCenterOreChunkCoord(Utils.coordBlockToChunk(minBlockX));
        int minOreChunkZ = Utils.mapToCenterOreChunkCoord(Utils.coordBlockToChunk(minBlockZ));
        int maxOreChunkX = Utils.mapToCenterOreChunkCoord(Utils.coordBlockToChunk(maxBlockX));
        int maxOreChunkZ = Utils.mapToCenterOreChunkCoord(Utils.coordBlockToChunk(maxBlockZ));
        if (minOreChunkX != this.oldMinOreChunkX || maxOreChunkX != this.oldMaxOreChunkX || minOreChunkZ != this.oldMinOreChunkZ || maxOreChunkZ != this.oldMaxOreChunkZ) {
            this.oldMinOreChunkX = minOreChunkX;
            this.oldMaxOreChunkX = maxOreChunkX;
            this.oldMinOreChunkZ = minOreChunkZ;
            this.oldMaxOreChunkZ = maxOreChunkZ;
            return true;
        }
        return false;
    }

    @Override
    protected List<? extends IWaypointAndLocationProvider> generateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        int minOreChunkX = Utils.mapToCenterOreChunkCoord(Utils.coordBlockToChunk(minBlockX));
        int minOreChunkZ = Utils.mapToCenterOreChunkCoord(Utils.coordBlockToChunk(minBlockZ));
        int maxOreChunkX = Utils.mapToCenterOreChunkCoord(Utils.coordBlockToChunk(maxBlockX));
        int maxOreChunkZ = Utils.mapToCenterOreChunkCoord(Utils.coordBlockToChunk(maxBlockZ));
        int playerDimensionId = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        ArrayList<OreVeinLocation> oreChunkLocations = new ArrayList<OreVeinLocation>();
        int chunkX = minOreChunkX;
        while (chunkX <= maxOreChunkX) {
            int chunkZ = minOreChunkZ;
            while (chunkZ <= maxOreChunkZ) {
                OreVeinPosition oreVeinPosition = ClientCache.instance.getOreVein(playerDimensionId, chunkX, chunkZ);
                if (oreVeinPosition.veinType != VeinType.NO_VEIN) {
                    oreChunkLocations.add(new OreVeinLocation(oreVeinPosition));
                }
                chunkZ = Utils.mapToCenterOreChunkCoord(chunkZ + 3);
            }
            chunkX = Utils.mapToCenterOreChunkCoord(chunkX + 3);
        }
        return oreChunkLocations;
    }
}

