/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds;

import appeng.api.AEApi;
import appeng.api.features.IWorldGen;
import java.util.Arrays;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.UW_PortalBlock;
import zarkov.utilityworlds.UW_WorldProviderGarden;
import zarkov.utilityworlds.UW_WorldProviderMining;
import zarkov.utilityworlds.UW_WorldProviderVoid;

public class UW_Utils {
    public static float getAngle(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 180.0f;
            }
            case EAST: {
                return 270.0f;
            }
            case WEST: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public static float getPlayerDirection(byte metadata) {
        float direction = 0.0f;
        switch (metadata) {
            case 2: {
                direction = 180.0f;
                return 180.0f;
            }
            case 3: {
                direction = 0.0f;
                return 0.0f;
            }
            case 4: {
                direction = 90.0f;
                return 90.0f;
            }
            case 5: {
                direction = -90.0f;
                return -90.0f;
            }
        }
        return direction;
    }

    public static Class<? extends WorldProvider> getWorldProvider(UW_PortalBlock.PORTAL_TYPE type) {
        switch (type) {
            case MINING: {
                return UW_WorldProviderMining.class;
            }
            case VOID: {
                return UW_WorldProviderVoid.class;
            }
            case GARDEN: {
                return UW_WorldProviderGarden.class;
            }
            case RETURN: {
                return null;
            }
        }
        return null;
    }

    public static byte metadataFromDirection(int direction) {
        if (direction == 0) {
            return 2;
        }
        if (direction == 1) {
            return 5;
        }
        if (direction == 2) {
            return 3;
        }
        if (direction == 3) {
            return 4;
        }
        return 3;
    }

    public static boolean enableAe2MeteorsForDimension(int dimensionId) {
        boolean success = false;
        try {
            IWorldGen.WorldGenType type = null;
            try {
                type = IWorldGen.WorldGenType.valueOf((String)"Metorites");
            }
            catch (IllegalArgumentException e) {
                type = IWorldGen.WorldGenType.valueOf((String)"Meteorites");
            }
            if (null != type) {
                AEApi.instance().registries().worldgen().enableWorldGenForDimension(type, dimensionId);
                success = true;
            }
        }
        catch (Throwable outer) {
            UW_Log.warn("Exception while calling AE2 API", outer);
        }
        return success;
    }

    public static boolean initUnloadedDimension(int dimension_id) {
        DimensionManager.init();
        Object[] loadedDimensions = DimensionManager.getIDs();
        Arrays.sort(loadedDimensions);
        if (Arrays.binarySearch(loadedDimensions, (Object)dimension_id) < 0) {
            DimensionManager.initDimension((int)dimension_id);
            return true;
        }
        return false;
    }

    public static class BlockPos {
        int x;
        int y;
        int z;

        public BlockPos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public BlockPos(BlockPos pos) {
            this.x = pos.x;
            this.y = pos.y;
            this.z = pos.z;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }
    }

    public static class Offset {
        public float x;
        public float z;

        public Offset(byte metadata) {
            switch (metadata) {
                case 2: {
                    this.x = 0.5f;
                    this.z = -0.5f;
                    break;
                }
                case 3: {
                    this.x = 0.5f;
                    this.z = 1.5f;
                    break;
                }
                case 4: {
                    this.x = -0.5f;
                    this.z = 0.5f;
                    break;
                }
                case 5: {
                    this.x = 1.5f;
                    this.z = 0.5f;
                }
            }
        }
    }
}

