/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.UW_Messages;
import zarkov.utilityworlds.UW_PortalBlockReturn;
import zarkov.utilityworlds.UW_PortalTileEntity;
import zarkov.utilityworlds.UW_Utils;
import zarkov.utilityworlds.UtilityWorlds;

public abstract class UW_PortalBlock
extends Block
implements ITileEntityProvider {
    public abstract PORTAL_TYPE getPortalType();

    protected UW_PortalBlock() {
        super(Material.field_151580_n);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
        this.func_149713_g(0);
        this.func_149658_d("obsidian");
        this.func_149711_c(0.4f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public abstract UW_Utils.BlockPos getReturnPortalPos();

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        TileEntity tmpEntity = world.func_147438_o(x, y, z);
        if (tmpEntity instanceof UW_PortalTileEntity) {
            UW_PortalTileEntity portal = (UW_PortalTileEntity)tmpEntity;
            if (!world.field_72995_K) {
                if (player.func_70093_af() && null == portal.remoteDimensionId && FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152596_g(player.func_146103_bH())) {
                    TreeMap<Integer, String> dimMap = new TreeMap<Integer, String>();
                    DimensionManager.init();
                    Object[] ids = DimensionManager.getIDs();
                    Arrays.sort(ids);
                    Iterator<Integer> localIterator = UtilityWorlds.dimensionMap.keySet().iterator();
                    while (localIterator.hasNext()) {
                        WorldProvider provider;
                        int dim_id = localIterator.next();
                        if (dim_id == player.field_70170_p.field_73011_w.field_76574_g) continue;
                        if (Arrays.binarySearch(ids, (Object)dim_id) < 0) {
                            DimensionManager.initDimension((int)dim_id);
                        }
                        if (null != (provider = DimensionManager.getProvider((int)dim_id))) {
                            dimMap.put(dim_id, provider.func_80007_l());
                            continue;
                        }
                        UW_Log.error("Failed to get provider for dimension " + dim_id + ".");
                    }
                    UW_Messages.MsgLinkDimension link_message = new UW_Messages.MsgLinkDimension(world.field_73011_w.field_76574_g, -1, portal.localPos, portal.localDir, dimMap);
                    UtilityWorlds.channel.sendTo((IMessage)link_message, (EntityPlayerMP)player);
                    return true;
                }
                if (null == portal.remoteDimensionId && !(this instanceof UW_PortalBlockReturn)) {
                    int id = UtilityWorlds.getNextDimensionID();
                    UW_Log.debug("Got new DimensionID to use: " + id + ".");
                    portal.remoteDimensionId = id;
                    PORTAL_TYPE portalType = this.getPortalType();
                    switch (portalType) {
                        case MINING: {
                            portal.remotePos = UtilityWorlds.portalBlockMining.getReturnPortalPos();
                            break;
                        }
                        case VOID: {
                            portal.remotePos = UtilityWorlds.portalBlockVoid.getReturnPortalPos();
                            break;
                        }
                        case GARDEN: {
                            portal.remotePos = UtilityWorlds.portalBlockGarden.getReturnPortalPos();
                        }
                    }
                    portal.remoteDir = 3;
                    portal.localDimensionId = world.field_73011_w.field_76574_g;
                    portal.isReturnPortal = false;
                    UW_Log.debug("Creating new dimension with id " + id + ".");
                    UtilityWorlds.dimensionMap.put(id, this.getPortalType().value());
                    UW_Messages.MsgDimensionList dimensionListMessage = new UW_Messages.MsgDimensionList();
                    UtilityWorlds.channel.sendToAll((IMessage)dimensionListMessage);
                    DimensionManager.registerProviderType((int)id, UW_Utils.getWorldProvider(portalType), (boolean)false);
                    DimensionManager.registerDimension((int)id, (int)id);
                    if (portalType == PORTAL_TYPE.MINING && Loader.isModLoaded((String)"appliedenergistics2-core") && !UtilityWorlds.preventAe2Meteors) {
                        UW_Utils.enableAe2MeteorsForDimension(id);
                    }
                    DimensionManager.initDimension((int)id);
                    WorldServer remoteWorld = DimensionManager.getWorld((int)id);
                    if (null != remoteWorld) {
                        UW_Utils.BlockPos spawn = new UW_Utils.BlockPos(portal.remotePos);
                        GameRegistry.generateWorld((int)(x >> 4), (int)(z >> 4), (World)remoteWorld, (IChunkProvider)remoteWorld.func_72863_F(), (IChunkProvider)remoteWorld.func_72863_F());
                        UW_PortalTileEntity remotePortal = new UW_PortalTileEntity();
                        remotePortal.remoteDimensionId = portal.localDimensionId;
                        remotePortal.remotePos = new UW_Utils.BlockPos(portal.localPos);
                        remotePortal.remoteDir = portal.localDir;
                        remotePortal.localDimensionId = portal.remoteDimensionId;
                        remotePortal.localPos = new UW_Utils.BlockPos(portal.remotePos);
                        remotePortal.localDir = portal.remoteDir;
                        remotePortal.isReturnPortal = true;
                        remoteWorld.func_147449_b(portal.remotePos.x, portal.remotePos.y + 1, portal.remotePos.z, (Block)UtilityWorlds.portalBlockReturn);
                        remoteWorld.func_147455_a(portal.remotePos.x, portal.remotePos.y + 1, portal.remotePos.z, (TileEntity)remotePortal);
                        remoteWorld.func_72921_c(portal.remotePos.x, portal.remotePos.y + 1, portal.remotePos.z, (int)UW_Utils.metadataFromDirection(portal.remoteDir.byteValue()), 2);
                        remoteWorld.func_147449_b(portal.remotePos.x + 1, portal.remotePos.y, portal.remotePos.z, Blocks.field_150343_Z);
                        remoteWorld.func_147449_b(portal.remotePos.x, portal.remotePos.y, portal.remotePos.z + 1, Blocks.field_150343_Z);
                        remoteWorld.func_147449_b(portal.remotePos.x, portal.remotePos.y, portal.remotePos.z - 1, Blocks.field_150343_Z);
                        remoteWorld.func_147449_b(portal.remotePos.x, portal.remotePos.y, portal.remotePos.z, Blocks.field_150343_Z);
                        remoteWorld.func_72938_d(portal.remotePos.x, portal.remotePos.z).func_76630_e();
                    }
                }
                if (null != portal.remoteDimensionId) {
                    UW_Messages.MsgTeleport message = new UW_Messages.MsgTeleport(portal.remoteDimensionId, this.getPortalType().value(), portal.remotePos, portal.remoteDir);
                    UtilityWorlds.channel.sendTo((IMessage)message, (EntityPlayerMP)player);
                }
            }
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        if (!world.field_72995_K) {
            int dir = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            UW_PortalTileEntity portal = (UW_PortalTileEntity)world.func_147438_o(x, y, z);
            if (null != portal) {
                NBTTagCompound tagCompound = itemStack.func_77978_p();
                if (null != tagCompound) {
                    portal.func_145839_a(tagCompound);
                }
                boolean invalid_location = false;
                ArrayList<ChatComponentText> components = new ArrayList<ChatComponentText>();
                if (null != portal.isReturnPortal && portal.isReturnPortal.booleanValue() && world.field_73011_w.field_76574_g != portal.localDimensionId) {
                    invalid_location = true;
                    WorldServer homeWorld = DimensionManager.getWorld((int)portal.localDimensionId);
                    if (null == homeWorld) {
                        DimensionManager.initDimension((int)portal.localDimensionId);
                        homeWorld = DimensionManager.getWorld((int)portal.localDimensionId);
                    }
                    components.add(new ChatComponentText(EnumChatFormatting.RED + "This portal can only be placed in " + world.field_73011_w.func_80007_l() + "." + EnumChatFormatting.RESET));
                }
                if (portal.remoteDimensionId != null && portal.remoteDimensionId == world.field_73011_w.field_76574_g) {
                    invalid_location = true;
                    components.add(new ChatComponentText(EnumChatFormatting.RED + "A portal cannot be placed in the target dimension." + EnumChatFormatting.RESET));
                }
                if (invalid_location) {
                    world.func_147455_a(x, y, z, (TileEntity)portal);
                    world.func_72938_d(x, z).func_76630_e();
                    world.func_147439_a(x, y, z).func_149697_b(world, x, y, z, 0, 0);
                    if (entityLiving instanceof EntityPlayerMP) {
                        EntityPlayerMP player = (EntityPlayerMP)entityLiving;
                        for (ChatComponentText component : components) {
                            player.func_145747_a((IChatComponent)component);
                        }
                    }
                    return;
                }
                portal.localDimensionId = world.field_73011_w.field_76574_g;
                portal.localPos = new UW_Utils.BlockPos(x, y, z);
                portal.localDir = (byte)dir;
                NBTTagCompound compound = new NBTTagCompound();
                portal.func_145841_b(compound);
                portal.func_145843_s();
                UW_PortalTileEntity te = new UW_PortalTileEntity();
                te.func_145839_a(compound);
                te.savedName = null;
                world.func_147475_p(x, y, z);
                world.func_147455_a(x, y, z, (TileEntity)te);
                te.func_70296_d();
                world.func_72921_c(x, y, z, (int)UW_Utils.metadataFromDirection(dir), 2);
                world.func_147438_o(x, y, z).func_145829_t();
                world.func_72938_d(x, z).func_76630_e();
                world.func_147471_g(x, y, z);
                if (null != portal.remoteDimensionId) {
                    WorldServer remoteWorld;
                    if (!DimensionManager.isDimensionRegistered((int)portal.remoteDimensionId)) {
                        DimensionManager.registerProviderType((int)portal.remoteDimensionId, UW_Utils.getWorldProvider(this.getPortalType()), (boolean)false);
                        DimensionManager.registerDimension((int)portal.remoteDimensionId, (int)portal.remoteDimensionId);
                    }
                    if (null == (remoteWorld = DimensionManager.getWorld((int)portal.remoteDimensionId))) {
                        DimensionManager.initDimension((int)portal.remoteDimensionId);
                        remoteWorld = DimensionManager.getWorld((int)portal.remoteDimensionId);
                    }
                    boolean remoteUpdated = false;
                    UW_PortalTileEntity remotePortal = null;
                    if (null != remoteWorld && null != (remotePortal = (UW_PortalTileEntity)remoteWorld.func_147438_o(portal.remotePos.x, portal.remotePos.y, portal.remotePos.z))) {
                        remotePortal.remoteDimensionId = world.field_73011_w.field_76574_g;
                        remotePortal.remotePos = new UW_Utils.BlockPos(portal.localPos);
                        remotePortal.remoteDir = portal.localDir;
                        remotePortal.savedName = null;
                        remotePortal.func_70296_d();
                        remoteWorld.func_147455_a(remotePortal.localPos.x, remotePortal.localPos.y, remotePortal.localPos.z, (TileEntity)remotePortal);
                        remoteWorld.func_72938_d(remotePortal.localPos.x, remotePortal.localPos.z).func_76630_e();
                        remoteUpdated = true;
                    }
                    if (!remoteUpdated) {
                        UW_Log.error("Failed to update remote portal. remoteWorld = " + remoteWorld + ", remotePortal = " + (Object)((Object)remotePortal) + ".");
                    }
                }
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        if (!world.field_72995_K) {
            TileEntity tmpEntity = null;
            for (Object o : world.field_147482_g) {
                TileEntity e = (TileEntity)o;
                if (x != e.field_145851_c || z != e.field_145849_e || y != e.field_145848_d || !(o instanceof UW_PortalTileEntity)) continue;
                tmpEntity = e;
                break;
            }
            if (null != tmpEntity) {
                UW_PortalTileEntity portal = (UW_PortalTileEntity)tmpEntity;
                ItemStack stack = null;
                switch (this.getPortalType()) {
                    case RETURN: {
                        stack = new ItemStack((Block)UtilityWorlds.portalBlockReturn);
                        stack.func_151001_c("Return Portal");
                        break;
                    }
                    case MINING: {
                        stack = new ItemStack((Block)UtilityWorlds.portalBlockMining);
                        stack.func_151001_c("Mining Portal");
                        break;
                    }
                    case VOID: {
                        stack = new ItemStack((Block)UtilityWorlds.portalBlockVoid);
                        stack.func_151001_c("Void Portal");
                        break;
                    }
                    case GARDEN: {
                        stack = new ItemStack((Block)UtilityWorlds.portalBlockGarden);
                        stack.func_151001_c("Garden Portal");
                    }
                }
                stack.func_77973_b().func_77625_d(1);
                NBTTagCompound tagCompound = stack.func_77978_p();
                portal.func_145841_b(tagCompound);
                stack.func_77982_d(tagCompound);
                stackList.add(stack);
                world.func_147475_p(x, y, z);
                world.func_147468_f(x, y, z);
                world.func_72938_d(x, z).func_76630_e();
            }
        }
        return stackList;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new UW_PortalTileEntity();
    }

    public static enum PORTAL_TYPE {
        RETURN(-1),
        MINING(0),
        VOID(1),
        GARDEN(2);

        private final int id;

        private PORTAL_TYPE(int id) {
            this.id = id;
        }

        public int value() {
            return this.id;
        }

        public static PORTAL_TYPE fromValue(int value) {
            for (PORTAL_TYPE type : PORTAL_TYPE.values()) {
                if (type.value() != value) continue;
                return type;
            }
            return null;
        }
    }
}

