/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S06PacketUpdateHealth;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.UW_PortalBlock;
import zarkov.utilityworlds.UW_PortalGui;
import zarkov.utilityworlds.UW_PortalTileEntity;
import zarkov.utilityworlds.UW_Teleporter;
import zarkov.utilityworlds.UW_Utils;
import zarkov.utilityworlds.UW_WorldProviderGarden;
import zarkov.utilityworlds.UW_WorldProviderMining;
import zarkov.utilityworlds.UW_WorldProviderVoid;
import zarkov.utilityworlds.UtilityWorlds;

public class UW_Messages {

    public static class MsgLinkDimensionHandler
    implements IMessageHandler<MsgLinkDimension, MsgLinkDimension> {
        @SideOnly(value=Side.CLIENT)
        private void showGUI(MsgLinkDimension message) {
            UW_Log.info("Displaying dimension linking GUI.");
            UW_PortalGui portalGUI = new UW_PortalGui(message);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)portalGUI);
        }

        public MsgLinkDimension onMessage(MsgLinkDimension message, MessageContext ctx) {
            MsgLinkDimension ret = null;
            if (ctx.side == Side.CLIENT) {
                this.showGUI(message);
            } else if (ctx.side == Side.SERVER && FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152596_g(ctx.getServerHandler().field_147369_b.func_146103_bH())) {
                TileEntity tmpEntity;
                boolean success = false;
                UW_Log.info("MsgLinkDimensionHandler: Restoring link from dimension " + message.from_dimension_id + " to dimension " + message.to_dimension_id + ".");
                World localWorld = DimensionManager.getProvider((int)message.from_dimension_id).field_76579_a;
                UW_Utils.initUnloadedDimension(message.to_dimension_id);
                World remoteWorld = DimensionManager.getProvider((int)message.to_dimension_id).field_76579_a;
                if (null != localWorld && null != remoteWorld && null != (tmpEntity = localWorld.func_147438_o(message.portalPos.x, message.portalPos.y, message.portalPos.z)) && tmpEntity instanceof UW_PortalTileEntity) {
                    UW_PortalTileEntity localPortal = (UW_PortalTileEntity)tmpEntity;
                    UW_PortalBlock portalBlock = UtilityWorlds.portalBlockReturn;
                    if (remoteWorld.field_73011_w instanceof UW_WorldProviderMining) {
                        localPortal.remotePos = UtilityWorlds.portalBlockMining.getReturnPortalPos();
                        portalBlock = UtilityWorlds.portalBlockMining;
                    } else if (remoteWorld.field_73011_w instanceof UW_WorldProviderVoid) {
                        localPortal.remotePos = UtilityWorlds.portalBlockVoid.getReturnPortalPos();
                        portalBlock = UtilityWorlds.portalBlockVoid;
                    } else if (remoteWorld.field_73011_w instanceof UW_WorldProviderGarden) {
                        localPortal.remotePos = UtilityWorlds.portalBlockGarden.getReturnPortalPos();
                        portalBlock = UtilityWorlds.portalBlockGarden;
                    } else {
                        localPortal.remotePos = UtilityWorlds.portalBlockMining.getReturnPortalPos();
                        if (localWorld.field_73011_w instanceof UW_WorldProviderMining) {
                            portalBlock = UtilityWorlds.portalBlockMining;
                        } else if (localWorld.field_73011_w instanceof UW_WorldProviderVoid) {
                            portalBlock = UtilityWorlds.portalBlockVoid;
                        } else if (localWorld.field_73011_w instanceof UW_WorldProviderGarden) {
                            portalBlock = UtilityWorlds.portalBlockGarden;
                        }
                    }
                    localPortal.remoteDir = 3;
                    localPortal.localDimensionId = localWorld.field_73011_w.field_76574_g;
                    localPortal.remoteDimensionId = remoteWorld.field_73011_w.field_76574_g;
                    localPortal.isReturnPortal = message.to_dimension_id == 0;
                    localWorld.func_147449_b(localPortal.localPos.x, localPortal.localPos.y, localPortal.localPos.z, (Block)(localPortal.isReturnPortal != false ? UtilityWorlds.portalBlockReturn : portalBlock));
                    localWorld.func_72921_c(localPortal.localPos.x, localPortal.localPos.y, localPortal.localPos.z, (int)UW_Utils.metadataFromDirection(localPortal.localDir.byteValue()), 2);
                    localPortal.func_70296_d();
                    localPortal.func_145829_t();
                    localWorld.func_147475_p(localPortal.localPos.x, localPortal.localPos.y, localPortal.localPos.z);
                    localWorld.func_147455_a(localPortal.localPos.x, localPortal.localPos.y, localPortal.localPos.z, (TileEntity)localPortal);
                    localWorld.func_147471_g(localPortal.localPos.x, localPortal.localPos.y, localPortal.localPos.z);
                    localWorld.func_72938_d(localPortal.field_145851_c, localPortal.field_145849_e).func_76630_e();
                    UW_Utils.BlockPos spawn = new UW_Utils.BlockPos(localPortal.remotePos);
                    remoteWorld.func_147449_b(spawn.x - 1, spawn.y + 1, spawn.z, Blocks.field_150350_a);
                    remoteWorld.func_147449_b(spawn.x - 1, spawn.y + 2, spawn.z, Blocks.field_150350_a);
                    remoteWorld.func_72938_d(spawn.x, spawn.z).func_76630_e();
                    UW_PortalTileEntity remotePortal = new UW_PortalTileEntity();
                    remotePortal.remoteDimensionId = localPortal.localDimensionId;
                    ++localPortal.localPos.y;
                    remotePortal.remotePos = new UW_Utils.BlockPos(localPortal.localPos);
                    remotePortal.remoteDir = localPortal.localDir;
                    remotePortal.localDimensionId = localPortal.remoteDimensionId;
                    --localPortal.localPos.y;
                    remotePortal.localPos = new UW_Utils.BlockPos(localPortal.remotePos);
                    remotePortal.localDir = localPortal.remoteDir;
                    remotePortal.isReturnPortal = message.to_dimension_id != 0;
                    remoteWorld.func_147449_b(localPortal.remotePos.x, localPortal.remotePos.y + 1, localPortal.remotePos.z, (Block)(remotePortal.isReturnPortal != false ? UtilityWorlds.portalBlockReturn : portalBlock));
                    remotePortal.func_70296_d();
                    remotePortal.func_145829_t();
                    remoteWorld.func_147475_p(localPortal.remotePos.x, localPortal.remotePos.y + 1, localPortal.remotePos.z);
                    remoteWorld.func_147455_a(localPortal.remotePos.x, localPortal.remotePos.y + 1, localPortal.remotePos.z, (TileEntity)remotePortal);
                    remoteWorld.func_72921_c(localPortal.remotePos.x, localPortal.remotePos.y + 1, localPortal.remotePos.z, (int)UW_Utils.metadataFromDirection(localPortal.remoteDir.byteValue()), 2);
                    remoteWorld.func_147471_g(localPortal.remotePos.x, localPortal.remotePos.y + 1, localPortal.remotePos.z);
                    remoteWorld.func_72938_d(remotePortal.field_145851_c, remotePortal.field_145849_e).func_76630_e();
                    success = true;
                }
                ChatComponentText chat = null;
                chat = !success ? new ChatComponentText(EnumChatFormatting.RED + "Link failed." + EnumChatFormatting.RESET) : new ChatComponentText(EnumChatFormatting.GREEN + "Link successful - portal can now be used." + EnumChatFormatting.RESET);
                ctx.getServerHandler().field_147369_b.func_146105_b((IChatComponent)chat);
            }
            return ret;
        }
    }

    public static class MsgLinkDimension
    implements IMessage {
        public int from_dimension_id;
        public int to_dimension_id;
        public UW_Utils.BlockPos portalPos;
        public byte portalDir;
        public Map<Integer, String> dimensionNames;

        public MsgLinkDimension() {
        }

        public MsgLinkDimension(int from_dimension_id, int to_dimension_id, UW_Utils.BlockPos portalPos, byte portalDir, Map<Integer, String> dimensionNames) {
            this.from_dimension_id = from_dimension_id;
            this.to_dimension_id = to_dimension_id;
            this.portalPos = portalPos;
            this.portalDir = portalDir;
            this.dimensionNames = new TreeMap<Integer, String>(dimensionNames);
        }

        public void fromBytes(ByteBuf buf) {
            this.dimensionNames = new TreeMap<Integer, String>();
            this.from_dimension_id = buf.readInt();
            this.to_dimension_id = buf.readInt();
            this.portalPos = new UW_Utils.BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.portalDir = buf.readByte();
            int numDimensions = buf.readInt();
            for (int i = 0; i < numDimensions; ++i) {
                int dimID = buf.readInt();
                int nameLen = buf.readInt();
                byte[] dst = new byte[nameLen];
                buf.readBytes(dst, 0, nameLen);
                this.dimensionNames.put(dimID, new String(dst));
            }
            for (Map.Entry<Integer, String> entry : this.dimensionNames.entrySet()) {
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.from_dimension_id);
            buf.writeInt(this.to_dimension_id);
            buf.writeInt(this.portalPos.getX());
            buf.writeInt(this.portalPos.getY());
            buf.writeInt(this.portalPos.getZ());
            buf.writeByte((int)this.portalDir);
            buf.writeInt(this.dimensionNames.size());
            for (Map.Entry<Integer, String> dim : this.dimensionNames.entrySet()) {
                buf.writeInt(dim.getKey().intValue());
                byte[] name = dim.getValue().getBytes();
                buf.writeInt(name.length);
                buf.writeBytes(name);
            }
        }
    }

    public static class MsgDimensionListHandler
    implements IMessageHandler<MsgDimensionList, MsgDimensionList> {
        public MsgDimensionList onMessage(MsgDimensionList message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                UW_Log.trace("Received dimension list packet with " + message.dimensions.size() + " dimensions on client.");
                UtilityWorlds.dimensionMap.clear();
                for (int dimension_id : message.dimensions.keySet()) {
                    UtilityWorlds.dimensionMap.put(dimension_id, dimension_id);
                    if (DimensionManager.isDimensionRegistered((int)dimension_id)) continue;
                    UW_Log.trace("Registering provider and dimension with id " + dimension_id + ".");
                    DimensionManager.registerProviderType((int)dimension_id, UW_Utils.getWorldProvider(UW_PortalBlock.PORTAL_TYPE.fromValue(message.dimensions.get(dimension_id))), (boolean)false);
                    DimensionManager.registerDimension((int)dimension_id, (int)dimension_id);
                }
                return null;
            }
            return null;
        }
    }

    public static class MsgDimensionList
    implements IMessage {
        HashMap<Integer, Integer> dimensions = new HashMap();

        public void fromBytes(ByteBuf buf) {
            this.dimensions.clear();
            int numDimensions = buf.readInt();
            for (int i = 0; i < numDimensions; ++i) {
                this.dimensions.put(buf.readInt(), buf.readInt());
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(UtilityWorlds.dimensionMap.size());
            for (int dimension_id : UtilityWorlds.dimensionMap.keySet()) {
                buf.writeInt(dimension_id);
                buf.writeInt(UtilityWorlds.dimensionMap.get(dimension_id).intValue());
            }
        }
    }

    public static class MsgTeleportHandler
    implements IMessageHandler<MsgTeleport, MsgTeleport> {
        public MsgTeleport onMessage(MsgTeleport message, MessageContext ctx) {
            MsgTeleport ret = null;
            if (ctx.side == Side.CLIENT) {
                if (!DimensionManager.isDimensionRegistered((int)message.dimension_id)) {
                    DimensionManager.registerProviderType((int)message.dimension_id, UW_Utils.getWorldProvider(UW_PortalBlock.PORTAL_TYPE.fromValue(message.blockType)), (boolean)false);
                    DimensionManager.registerDimension((int)message.dimension_id, (int)message.dimension_id);
                }
                ret = message;
            } else if (ctx.side == Side.SERVER) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                WorldServer remoteWorld = DimensionManager.getWorld((int)message.dimension_id);
                if (null == remoteWorld) {
                    UW_Log.trace("Remote world not loaded, running initDimension.");
                    DimensionManager.initDimension((int)message.dimension_id);
                    remoteWorld = DimensionManager.getWorld((int)message.dimension_id);
                }
                if (null != remoteWorld) {
                    UW_Teleporter teleport = new UW_Teleporter(remoteWorld, message.pos, message.dir);
                    player.field_70170_p.func_72956_a((Entity)player, "note.bass", 1.0f, 1.0f);
                    UW_Log.trace("Teleporting player '" + player.getDisplayName() + "' to dimension " + message.dimension_id + " (pos = " + message.pos + ", dir = " + message.dir + ")");
                    MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(player, message.dimension_id, (Teleporter)teleport);
                    player.field_71135_a.func_147359_a((Packet)new S06PacketUpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
                    player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
                    player.field_70170_p.func_72956_a((Entity)player, "note.bass", 1.0f, 1.0f);
                } else {
                    UW_Log.error("MsgTeleportHandler: Remote world is still null, can't teleport.");
                }
            }
            return ret;
        }
    }

    public static class MsgTeleport
    implements IMessage {
        private int dimension_id;
        private UW_Utils.BlockPos pos;
        private byte dir;
        private int blockType;

        public MsgTeleport() {
        }

        public MsgTeleport(int dimension_id, int blockType, UW_Utils.BlockPos pos, byte dir) {
            this.dimension_id = dimension_id;
            this.blockType = blockType;
            this.pos = pos;
            this.dir = dir;
        }

        public void fromBytes(ByteBuf buf) {
            this.dimension_id = buf.readInt();
            this.blockType = buf.readInt();
            this.pos = new UW_Utils.BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.dir = buf.readByte();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.dimension_id);
            buf.writeInt(this.blockType);
            buf.writeInt(this.pos.getX());
            buf.writeInt(this.pos.getY());
            buf.writeInt(this.pos.getZ());
            buf.writeByte((int)this.dir);
        }
    }
}

