/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.inventory;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.common.tiles.TileEssentiaReservoir;
import thaumcraft.common.tiles.TileJarFillableVoid;
import thaumicenergistics.api.grid.IEssentiaGrid;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.common.fluids.GaseousEssentia;
import thaumicenergistics.common.grid.GridEssentiaCache;
import thaumicenergistics.common.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.common.integration.tc.EssentiaTileContainerHelper;
import thaumicenergistics.common.inventory.HandlerEssentiaStorageBusBase;
import thaumicenergistics.common.parts.PartEssentiaStorageBus;

class HandlerEssentiaStorageBusContainer
extends HandlerEssentiaStorageBusBase {
    private IAspectContainer aspectContainer;
    Hashtable<Aspect, Long> cachedContainerAspects = new Hashtable();

    public HandlerEssentiaStorageBusContainer(PartEssentiaStorageBus part) {
        super(part);
    }

    private void addListToDictionary(List<IAspectStack> essentiaList, Hashtable<Aspect, Long> dictionary) {
        if (essentiaList != null) {
            for (IAspectStack stack : essentiaList) {
                dictionary.put(stack.getAspect(), stack.getStackSize());
            }
        }
    }

    private void adjustCache(Aspect aspect, long diff) {
        long newAmount;
        long cachedAmount = 0L;
        if (this.cachedContainerAspects.containsKey(aspect)) {
            cachedAmount = this.cachedContainerAspects.get(aspect);
        }
        if ((newAmount = cachedAmount + diff) > 0L) {
            this.cachedContainerAspects.put(aspect, newAmount);
        } else if (cachedAmount > 0L) {
            this.cachedContainerAspects.remove(aspect);
        }
    }

    private List<IAspectStack> getContainerEssentia() {
        if (this.aspectContainer == null) {
            return null;
        }
        if (!TEAPI.transportPermissions().canExtractFromAspectContainerTile(this.aspectContainer)) {
            return null;
        }
        List<IAspectStack> containerStacks = EssentiaTileContainerHelper.INSTANCE.getAspectStacksFromContainer(this.aspectContainer);
        if (containerStacks.isEmpty()) {
            return null;
        }
        ArrayList<IAspectStack> essentiaList = new ArrayList<IAspectStack>();
        boolean skipFilterCheck = this.allowAny();
        for (IAspectStack essentiaStack : containerStacks) {
            GaseousEssentia gas;
            if (!skipFilterCheck && !this.filteredAspects.contains(essentiaStack.getAspect()) || (gas = GaseousEssentia.getGasFromAspect(essentiaStack.getAspect())) == null) continue;
            essentiaList.add(essentiaStack);
        }
        return essentiaList;
    }

    @Override
    public boolean canAccept(IAEFluidStack fluidStack) {
        if (this.aspectContainer == null) {
            return false;
        }
        if (!this.hasSecurityPermission()) {
            return false;
        }
        if (!this.isFluidEssentiaGas(fluidStack)) {
            return false;
        }
        if (!TEAPI.transportPermissions().canInjectToAspectContainerTile(this.aspectContainer)) {
            return false;
        }
        if (!this.canTransferGas((GaseousEssentia)fluidStack.getFluid())) {
            return false;
        }
        if (this.aspectContainer instanceof TileEssentiaReservoir) {
            return true;
        }
        IAspectStack containerStack = EssentiaTileContainerHelper.INSTANCE.getAspectStackFromContainer(this.aspectContainer);
        if (containerStack == null) {
            return true;
        }
        Aspect gasAspect = ((GaseousEssentia)fluidStack.getFluid()).getAspect();
        return gasAspect == containerStack.getAspect();
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource source) {
        if (this.aspectContainer == null || request == null) {
            return null;
        }
        if (!this.isFluidEssentiaGas(request)) {
            return null;
        }
        FluidStack toDrain = request.getFluidStack();
        if (!this.canTransferGas((GaseousEssentia)toDrain.getFluid())) {
            return null;
        }
        FluidStack drained = EssentiaTileContainerHelper.INSTANCE.extractFromContainer(this.aspectContainer, toDrain, Actionable.SIMULATE);
        if (drained == null || drained.amount == 0) {
            return null;
        }
        int drainedAmount_EU = (int)EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(drained.amount);
        if (!this.partStorageBus.extractPowerForEssentiaTransfer(drainedAmount_EU, Actionable.SIMULATE)) {
            return null;
        }
        if (mode == Actionable.MODULATE) {
            EssentiaTileContainerHelper.INSTANCE.extractFromContainer(this.aspectContainer, toDrain, Actionable.MODULATE);
            this.partStorageBus.extractPowerForEssentiaTransfer(drainedAmount_EU, Actionable.MODULATE);
            this.adjustCache(((GaseousEssentia)toDrain.getFluid()).getAspect(), -drainedAmount_EU);
        }
        IAEFluidStack extractedFluid = request.copy();
        extractedFluid.setStackSize((long)drained.amount);
        return extractedFluid;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        if (this.aspectContainer != null) {
            List<IAspectStack> essentiaList = this.getContainerEssentia();
            this.cachedContainerAspects.clear();
            this.addListToDictionary(essentiaList, this.cachedContainerAspects);
            if (essentiaList != null) {
                for (IAspectStack essentia : essentiaList) {
                    GaseousEssentia gas = GaseousEssentia.getGasFromAspect(essentia.getAspect());
                    out.add((IAEStack)EssentiaConversionHelper.INSTANCE.createAEFluidStackInEssentiaUnits(gas, essentia.getStackSize()));
                }
            }
        }
        return out;
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource source) {
        int remaining_FU;
        int filled_FU;
        boolean canVoid;
        if (this.aspectContainer == null || input == null || !this.canAccept(input)) {
            return input;
        }
        FluidStack toFill = input.getFluidStack();
        boolean bl = canVoid = this.isVoidAllowed() && this.aspectContainer instanceof TileJarFillableVoid;
        if (canVoid) {
            filled_FU = (int)input.getStackSize();
        } else {
            filled_FU = (int)EssentiaTileContainerHelper.INSTANCE.injectFluidIntoContainer(this.aspectContainer, input, Actionable.SIMULATE);
            if (filled_FU == 0) {
                return input;
            }
        }
        int filled_EU = (int)EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(filled_FU);
        if (!this.partStorageBus.extractPowerForEssentiaTransfer(filled_EU, Actionable.SIMULATE)) {
            return input;
        }
        if (mode == Actionable.MODULATE) {
            filled_FU = (int)EssentiaTileContainerHelper.INSTANCE.injectFluidIntoContainer(this.aspectContainer, input, Actionable.MODULATE);
            this.partStorageBus.extractPowerForEssentiaTransfer(filled_EU, Actionable.MODULATE);
            filled_EU = (int)EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(filled_FU);
            this.adjustCache(((GaseousEssentia)toFill.getFluid()).getAspect(), filled_EU);
        }
        if ((remaining_FU = toFill.amount - filled_FU) == 0) {
            return null;
        }
        if (canVoid) {
            this.invalidateGlobalEssentiaCache();
            return null;
        }
        IAEFluidStack remainingFluid = input.copy();
        remainingFluid.setStackSize((long)remaining_FU);
        return remainingFluid;
    }

    private void invalidateGlobalEssentiaCache() {
        IGrid grid;
        IGridNode node = this.partStorageBus.getGridNode();
        if (node != null && (grid = node.getGrid()) != null) {
            GridEssentiaCache globalCache = (GridEssentiaCache)grid.getCache(IEssentiaGrid.class);
            globalCache.onListUpdate();
        }
    }

    @Override
    public boolean onNeighborChange() {
        TileEntity tileEntity = this.getFaceingTile();
        if (tileEntity instanceof IAspectContainer) {
            if (this.aspectContainer != tileEntity) {
                this.aspectContainer = (IAspectContainer)tileEntity;
                this.cachedContainerAspects.clear();
                return true;
            }
            return false;
        }
        if (this.aspectContainer != null) {
            this.aspectContainer = null;
            this.tickingRequest(null, 0);
            return true;
        }
        return false;
    }

    @Override
    public void tickingRequest(IGridNode node, int TicksSinceLastCall) {
        HashSet<Aspect> aspectsToCheck = new HashSet<Aspect>();
        List<IAspectStack> currentContainerContents = this.getContainerEssentia();
        Hashtable<Aspect, Long> currentContainerAspects = new Hashtable<Aspect, Long>();
        if (currentContainerContents != null) {
            this.addListToDictionary(currentContainerContents, currentContainerAspects);
            aspectsToCheck.addAll(currentContainerAspects.keySet());
        }
        aspectsToCheck.addAll(this.cachedContainerAspects.keySet());
        if (aspectsToCheck.size() == 0) {
            return;
        }
        ArrayList<IAEFluidStack> alterations = null;
        for (Aspect aspect : aspectsToCheck) {
            long diff;
            long cachedAmount = 0L;
            if (this.cachedContainerAspects.containsKey(aspect)) {
                cachedAmount = this.cachedContainerAspects.get(aspect);
            }
            long currentAmount = 0L;
            if (currentContainerAspects.containsKey(aspect)) {
                currentAmount = currentContainerAspects.get(aspect);
            }
            if ((diff = currentAmount - cachedAmount) == 0L) continue;
            if (alterations == null) {
                alterations = new ArrayList<IAEFluidStack>();
            }
            alterations.add(EssentiaConversionHelper.INSTANCE.createAEFluidStackInEssentiaUnits(aspect, diff));
            this.adjustCache(aspect, diff);
        }
        if (alterations != null) {
            this.postAlterationToHostGrid(alterations);
        }
    }

    @Override
    public boolean validForPass(int pass) {
        if (this.aspectContainer != null) {
            boolean hasStored;
            boolean hasFilters = !this.allowAny();
            boolean bl = hasStored = !EssentiaTileContainerHelper.INSTANCE.getAspectStacksFromContainer(this.aspectContainer).isEmpty();
            if (pass == 1) {
                return hasFilters || hasStored;
            }
            return !hasFilters;
        }
        return false;
    }
}

