/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.inventory;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.tile.misc.TileCondenser;
import com.google.common.collect.ImmutableList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import thaumicenergistics.common.fluids.GaseousEssentia;
import thaumicenergistics.common.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.common.inventory.HandlerEssentiaStorageBusBase;
import thaumicenergistics.common.parts.PartEssentiaStorageBus;

public class HandlerEssentiaStorageBusCondenser
extends HandlerEssentiaStorageBusBase {
    private TileCondenser condenser = null;

    public HandlerEssentiaStorageBusCondenser(PartEssentiaStorageBus part) {
        super(part);
    }

    @Override
    public boolean canAccept(IAEFluidStack fluidStack) {
        if (this.condenser == null) {
            return false;
        }
        if (!this.hasSecurityPermission()) {
            return false;
        }
        if (!this.isFluidEssentiaGas(fluidStack)) {
            return false;
        }
        return this.canTransferGas((GaseousEssentia)fluidStack.getFluid());
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource source) {
        return null;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        return out;
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource source) {
        if (this.condenser == null || input == null || !this.canAccept(input)) {
            return input;
        }
        if (mode == Actionable.SIMULATE) {
            return null;
        }
        IAEFluidStack injectStack = input.copy();
        injectStack.setStackSize(500L * EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(input.getStackSize()));
        this.condenser.fill(this.partStorageBus.getSide().getOpposite(), injectStack.getFluidStack(), mode == Actionable.MODULATE);
        this.postAlterationToHostGrid((Iterable<IAEFluidStack>)ImmutableList.of((Object)AEApi.instance().storage().createFluidStack(new FluidStack(input.getFluid(), (int)(-input.getStackSize())))));
        return null;
    }

    @Override
    public boolean onNeighborChange() {
        TileEntity te = this.getFaceingTile();
        this.condenser = te instanceof TileCondenser ? (TileCondenser)te : null;
        return false;
    }

    @Override
    public void tickingRequest(IGridNode node, int TicksSinceLastCall) {
    }

    @Override
    public boolean validForPass(int pass) {
        return true;
    }
}

