/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.grid;

import appeng.api.networking.IGridNode;
import java.util.HashMap;
import java.util.HashSet;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.IEssentiaWatcher;
import thaumicenergistics.api.grid.IEssentiaWatcherHost;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.api.grid.IMEEssentiaMonitorReceiver;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.common.grid.GridEssentiaCache;

class EssentiaWatcherManager
implements IMEEssentiaMonitorReceiver {
    private HashMap<IGridNode, IEssentiaWatcher> watchers = new HashMap();
    private HashMap<Aspect, HashSet<IEssentiaWatcher>> watchedAspects = new HashMap();
    private boolean isListeningForChanges = false;
    private final GridEssentiaCache gridCache;

    public EssentiaWatcherManager(GridEssentiaCache gridCache) {
        this.gridCache = gridCache;
    }

    public void addWatcher(IGridNode node, IEssentiaWatcher watcher) {
        this.watchers.put(node, watcher);
        if (!this.isListeningForChanges) {
            this.gridCache.addListener(this, this.gridCache.internalGrid);
            this.isListeningForChanges = true;
        }
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return this.isListeningForChanges && verificationToken == this.gridCache.internalGrid;
    }

    public void onWatcherAddAspect(IEssentiaWatcher watcher, Aspect aspect) {
        HashSet<Object> aWatchers;
        if (!this.watchedAspects.containsKey(aspect)) {
            aWatchers = new HashSet();
            this.watchedAspects.put(aspect, aWatchers);
        } else {
            aWatchers = this.watchedAspects.get(aspect);
        }
        aWatchers.add(watcher);
    }

    public void onWatcherCleared(IEssentiaWatcher watcher, HashSet<Aspect> previouslyTrackedAspects) {
        for (Aspect aspect : previouslyTrackedAspects) {
            this.onWatcherRemoveAspect(watcher, aspect);
        }
    }

    public void onWatcherRemoveAspect(IEssentiaWatcher watcher, Aspect aspect) {
        HashSet<IEssentiaWatcher> aWatchers = this.watchedAspects.get(aspect);
        if (aWatchers != null) {
            aWatchers.remove(watcher);
            if (aWatchers.isEmpty()) {
                this.watchedAspects.remove(aspect);
            }
        }
    }

    @Override
    public void postChange(IMEEssentiaMonitor fromMonitor, Iterable<IAspectStack> changes) {
        if (this.watchedAspects.isEmpty()) {
            return;
        }
        for (IAspectStack change : changes) {
            if (!this.watchedAspects.containsKey(change.getAspect())) continue;
            HashSet<IEssentiaWatcher> watcherSet = this.watchedAspects.get(change.getAspect());
            long fullAmount = this.gridCache.getEssentiaAmount(change.getAspect());
            for (IEssentiaWatcher watcher : watcherSet) {
                IEssentiaWatcherHost host = watcher.getHost();
                if (host == null) continue;
                host.onEssentiaChange(change.getAspect(), fullAmount, change.getStackSize());
            }
        }
    }

    public void removeWatcher(IGridNode node) {
        IEssentiaWatcher watcher = this.watchers.get(node);
        if (watcher != null) {
            watcher.clear();
            this.watchers.remove(node);
            if (this.watchers.isEmpty()) {
                this.watchedAspects.clear();
                this.gridCache.removeListener(this);
                this.isListeningForChanges = false;
            }
        }
    }
}

