/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration.tc;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.items.ItemEldritchObject;

public class ArcaneCraftingPattern
implements ICraftingPatternDetails {
    private static final String NBTKEY_INGREDIENT_NUM = "input#";
    private static final String NBTKEY_RESULT = "output";
    private static final String NBTKEY_INGREDIENT_TYPE = "ThE_crafting_type";
    private static final String NBTKEY_ARRAY_SIZE = "size";
    private static final int NBTKEY_ARRAYTYPE = 2;
    private static final int NBTKEY_ITEMTYPE = 1;
    private static final int GRID_SIZE = 9;
    protected AspectList aspects;
    protected Object[] ingredients = new Object[9];
    protected IAEItemStack result;
    protected ItemStack knowledgeCoreHost;
    protected Aspect[] cachedAspects;
    protected IAEItemStack[] ingredientsAE = null;
    protected IAEItemStack[] allResults = null;
    protected boolean isValid = false;

    public ArcaneCraftingPattern(ItemStack knowledgeCore, AspectList aspects, ItemStack craftingResult, Object[] craftingIngredients) {
        this.knowledgeCoreHost = knowledgeCore;
        this.aspects = aspects.copy();
        this.result = AEApi.instance().storage().createItemStack(craftingResult);
        boolean hasAtLeastOneValidInput = false;
        for (int index = 0; index < this.ingredients.length && index < craftingIngredients.length; ++index) {
            Object nextIng = craftingIngredients[index];
            if (nextIng == null) continue;
            this.ingredients[index] = nextIng;
            hasAtLeastOneValidInput = true;
        }
        this.setPatternValidity(this.aspects.size() > 0 && this.result != null && hasAtLeastOneValidInput);
    }

    public ArcaneCraftingPattern(@Nullable ItemStack knowledgeCore, NBTTagCompound data) {
        this.knowledgeCoreHost = knowledgeCore;
        this.aspects = new AspectList();
        this.readFromNBT(data);
    }

    private static boolean canSubItem(ItemStack target, ItemStack input) {
        if (ItemStack.func_77989_b((ItemStack)target, (ItemStack)input)) {
            return true;
        }
        if (target.func_77973_b() != input.func_77973_b()) {
            return false;
        }
        if (target.func_77942_o() && !ThaumcraftApiHelper.areItemStackTagsEqualForCrafting((ItemStack)input, (ItemStack)target)) {
            return false;
        }
        if (!target.func_77984_f()) {
            return target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == input.func_77960_j();
        }
        return true;
    }

    public static boolean canSubstitueFor(Object target, ItemStack input) {
        if (target instanceof ItemStack) {
            return ArcaneCraftingPattern.canSubItem((ItemStack)target, input);
        }
        if (target instanceof ArrayList) {
            ArrayList items = (ArrayList)target;
            for (ItemStack item : items) {
                if (!ArcaneCraftingPattern.canSubItem(item, input)) continue;
                return true;
            }
        }
        return false;
    }

    private void setupAEIngredientList() {
        this.ingredientsAE = new AEItemStack[9];
        for (int index = 0; index < 9; ++index) {
            Object ing = this.ingredients[index];
            if (ing == null) {
                this.ingredientsAE[index] = null;
                continue;
            }
            if (ing instanceof ItemStack) {
                this.ingredientsAE[index] = AEApi.instance().storage().createItemStack((ItemStack)ing);
                continue;
            }
            if (!(ing instanceof ArrayList)) continue;
            ItemStack firstIng = (ItemStack)((ArrayList)ing).get(0);
            this.ingredientsAE[index] = AEApi.instance().storage().createItemStack(firstIng);
        }
    }

    private void setupAEResults() {
        if (this.ingredientsAE == null) {
            this.setupAEIngredientList();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (IAEItemStack stack : this.ingredientsAE) {
            if (stack == null) continue;
            if (stack.getItem().hasContainerItem(stack.getItemStack())) {
                results.add(AEApi.instance().storage().createItemStack(stack.getItem().getContainerItem(stack.getItemStack())));
                continue;
            }
            if (stack.getStackSize() > 1L) {
                results.add(stack.copy().setStackSize(stack.getStackSize() - 1L));
                continue;
            }
            if (!(stack.getItem() instanceof ItemEldritchObject) || stack.getItemDamage() != 3) continue;
            results.add(stack);
        }
        results.add(this.result);
        this.allResults = results.toArray(new IAEItemStack[results.size()]);
    }

    protected void setPatternValidity(boolean valid) {
        this.isValid = valid;
        if (!valid) {
            this.result = null;
            this.ingredientsAE = null;
            for (int index = 0; index < 9; ++index) {
                this.ingredients[index] = null;
            }
            this.aspects = new AspectList();
            this.cachedAspects = null;
        }
    }

    public boolean canSubstitute() {
        return true;
    }

    public IAEItemStack[] getAllResults() {
        if (this.allResults == null) {
            this.setupAEResults();
        }
        return this.allResults;
    }

    public int getAspectCost(Aspect aspect) {
        return this.aspects.getAmount(aspect);
    }

    public Aspect[] getCachedAspects() {
        if (this.cachedAspects == null) {
            this.cachedAspects = this.aspects.getAspects();
        }
        return this.cachedAspects;
    }

    public IAEItemStack[] getCondensedInputs() {
        ArrayList<IAEItemStack> cond = new ArrayList<IAEItemStack>();
        if (this.ingredientsAE == null) {
            this.setupAEIngredientList();
        }
        for (int index = 0; index < this.ingredientsAE.length; ++index) {
            if (this.ingredientsAE[index] == null) continue;
            cond.add(this.ingredientsAE[index]);
        }
        return cond.toArray(new IAEItemStack[cond.size()]);
    }

    public IAEItemStack[] getCondensedOutputs() {
        if (this.result == null) {
            return new IAEItemStack[0];
        }
        return new IAEItemStack[]{this.result};
    }

    public IAEItemStack[] getInputs() {
        if (this.ingredientsAE == null) {
            this.setupAEIngredientList();
        }
        return this.ingredientsAE;
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        return this.result.getItemStack();
    }

    public IAEItemStack[] getOutputs() {
        return new IAEItemStack[]{this.result};
    }

    public ItemStack getPattern() {
        return this.knowledgeCoreHost;
    }

    public int getPriority() {
        return 0;
    }

    public IAEItemStack getResult() {
        return this.result;
    }

    public boolean isCraftable() {
        return true;
    }

    public boolean isPatternValid() {
        return this.isValid;
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack input, World world) {
        Object ing = this.ingredients[slotIndex];
        if (ing == null || input == null || input.func_77973_b() == null) {
            return false;
        }
        return ArcaneCraftingPattern.canSubstitueFor(ing, input);
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data == null) {
            return;
        }
        this.setPatternValidity(true);
        this.aspects.readFromNBT(data);
        if (this.aspects.size() == 0) {
            this.setPatternValidity(false);
            return;
        }
        for (int slotNumber = 0; this.isValid && slotNumber < 9; ++slotNumber) {
            ItemStack ing;
            if (!data.func_74764_b(NBTKEY_INGREDIENT_NUM + slotNumber)) continue;
            NBTTagCompound ingData = data.func_74775_l(NBTKEY_INGREDIENT_NUM + slotNumber);
            if (ingData == null || ingData.func_82582_d()) {
                this.setPatternValidity(false);
                return;
            }
            if (!ingData.func_74764_b(NBTKEY_INGREDIENT_TYPE)) {
                try {
                    IAEItemStack ingAE = AEItemStack.loadItemStackFromNBT((NBTTagCompound)ingData);
                    if (ingAE == null) {
                        this.setPatternValidity(false);
                        return;
                    }
                    ing = ingAE.getItemStack();
                    if (ing == null) {
                        this.setPatternValidity(false);
                        return;
                    }
                    this.ingredients[slotNumber] = ing;
                    continue;
                }
                catch (Exception e) {
                    this.setPatternValidity(false);
                    return;
                }
            }
            int type = ingData.func_74762_e(NBTKEY_INGREDIENT_TYPE);
            if (type == 1) {
                try {
                    ing = ItemStack.func_77949_a((NBTTagCompound)ingData);
                    if (ing == null) {
                        this.setPatternValidity(false);
                        return;
                    }
                    this.ingredients[slotNumber] = ing;
                    continue;
                }
                catch (Exception e) {
                    this.setPatternValidity(false);
                    return;
                }
            }
            if (type == 2) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                if (!ingData.func_74764_b(NBTKEY_ARRAY_SIZE)) {
                    this.setPatternValidity(false);
                    return;
                }
                int count = ingData.func_74762_e(NBTKEY_ARRAY_SIZE);
                for (int arrayIndex = 0; arrayIndex < count; ++arrayIndex) {
                    NBTTagCompound subTag = ingData.func_74775_l(NBTKEY_INGREDIENT_NUM + arrayIndex);
                    if (subTag == null || subTag.func_82582_d()) continue;
                    try {
                        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)subTag);
                        if (stack == null) continue;
                        itemList.add(stack);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (itemList.size() == 0) {
                    this.setPatternValidity(false);
                    return;
                }
                this.ingredients[slotNumber] = itemList;
                continue;
            }
            this.setPatternValidity(false);
            return;
        }
        if (data.func_74764_b(NBTKEY_RESULT)) {
            NBTTagCompound resultData = data.func_74775_l(NBTKEY_RESULT);
            if (resultData == null || resultData.func_82582_d()) {
                this.setPatternValidity(false);
                return;
            }
            try {
                this.result = AEItemStack.loadItemStackFromNBT((NBTTagCompound)resultData);
                if (this.result == null) {
                    this.setPatternValidity(false);
                    return;
                }
            }
            catch (Exception e) {
                this.setPatternValidity(false);
                return;
            }
        }
    }

    public void setKnowledgeCore(ItemStack knowledgeCore) {
        this.knowledgeCoreHost = knowledgeCore;
    }

    public void setPriority(int priority) {
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        this.aspects.writeToNBT(data);
        for (int index = 0; index < 9; ++index) {
            if (this.ingredients[index] == null) continue;
            Object ing = this.ingredients[index];
            NBTTagCompound ingData = new NBTTagCompound();
            if (ing instanceof IAEItemStack) {
                ((IAEItemStack)ing).getItemStack().func_77955_b(ingData);
                ingData.func_74768_a(NBTKEY_INGREDIENT_TYPE, 1);
            } else if (ing instanceof ItemStack) {
                ((ItemStack)ing).func_77955_b(ingData);
                ingData.func_74768_a(NBTKEY_INGREDIENT_TYPE, 1);
            } else if (ing instanceof ArrayList) {
                ArrayList ingList = (ArrayList)ing;
                ingData.func_74768_a(NBTKEY_INGREDIENT_TYPE, 2);
                ingData.func_74768_a(NBTKEY_ARRAY_SIZE, ingList.size());
                for (int i = 0; i < ingList.size(); ++i) {
                    NBTTagCompound subTag = new NBTTagCompound();
                    ((ItemStack)ingList.get(i)).func_77955_b(subTag);
                    ingData.func_74782_a(NBTKEY_INGREDIENT_NUM + i, (NBTBase)subTag);
                }
            }
            if (ingData.func_82582_d()) continue;
            data.func_74782_a(NBTKEY_INGREDIENT_NUM + index, (NBTBase)ingData);
        }
        NBTTagCompound outData = new NBTTagCompound();
        this.result.writeToNBT(outData);
        data.func_74782_a(NBTKEY_RESULT, (NBTBase)outData);
        return data;
    }
}

