/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.storage.data.IAEItemStack;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotInaccessible;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumicenergistics.common.container.ContainerWithPlayerInventory;
import thaumicenergistics.common.container.slot.SlotRestrictive;
import thaumicenergistics.common.integration.tc.ArcaneCraftingPattern;
import thaumicenergistics.common.integration.tc.ArcaneRecipeHelper;
import thaumicenergistics.common.inventory.HandlerKnowledgeCore;
import thaumicenergistics.common.inventory.TheInternalInventory;
import thaumicenergistics.common.items.ItemKnowledgeCore;
import thaumicenergistics.common.network.packet.client.Packet_C_KnowledgeInscriber;
import thaumicenergistics.common.tiles.TileKnowledgeInscriber;
import thaumicenergistics.common.utils.EffectiveSide;

public class ContainerKnowledgeInscriber
extends ContainerWithPlayerInventory {
    private static final int MAXIMUM_PATTERNS = 21;
    private static final int PLAYER_INV_POSITION_Y = 162;
    private static final int HOTBAR_INV_POSITION_Y = 220;
    public static final int KCORE_SLOT_X = 186;
    public static final int KCORE_SLOT_Y = 8;
    private static final int PATTERN_SLOT = 0;
    private static final int PATTERN_SLOT_X = 26;
    private static final int PATTERN_SLOT_Y = 18;
    private static final int PATTERN_ROWS = 3;
    private static final int PATTERN_COLS = 7;
    private static final int PATTERN_SLOT_SPACING = 18;
    public static final int CRAFTING_MATRIX_SLOT = 21;
    public static final int CRAFTING_SLOT_X = 26;
    public static final int CRAFTING_SLOT_Y = 90;
    public static final int CRAFTING_ROWS = 3;
    public static final int CRAFTING_COLS = 3;
    public static final int CRAFTING_GRID_SIZE = 9;
    public static final int CRAFTING_SLOT_SPACING = 18;
    public static final int CRAFTING_RESULT_SLOT = 30;
    private final HandlerKnowledgeCore kCoreHandler;
    private final SlotRestrictive kCoreSlot;
    private final SlotFake resultSlot;
    private final SlotInaccessible[] patternSlots = new SlotInaccessible[21];
    private final SlotFakeCraftingMatrix[] craftingSlots = new SlotFakeCraftingMatrix[9];
    private IArcaneRecipe activeRecipe = null;
    private TileKnowledgeInscriber inscriber;
    private final TheInternalInventory internalInventory;

    public ContainerKnowledgeInscriber(EntityPlayer player, World world, int x, int y, int z) {
        super(player);
        this.bindPlayerInventory((IInventory)player.field_71071_by, 162, 220);
        this.inscriber = (TileKnowledgeInscriber)world.func_147438_o(x, y, z);
        this.kCoreSlot = new SlotRestrictive(this.inscriber, 0, 186, 8);
        this.func_75146_a(this.kCoreSlot);
        this.internalInventory = new TheInternalInventory("cki", 31, 64);
        this.initPatternSlots();
        this.initCraftingSlots();
        this.resultSlot = new SlotFake((IInventory)this.internalInventory, 30, 116, 108);
        this.func_75146_a((Slot)this.resultSlot);
        this.kCoreHandler = new HandlerKnowledgeCore();
    }

    private CoreSaveState getSaveState() {
        CoreSaveState saveState;
        if (!this.kCoreHandler.hasCore()) {
            saveState = CoreSaveState.Disabled_MissingCore;
        } else if (this.activeRecipe == null) {
            saveState = CoreSaveState.Disabled_InvalidRecipe;
        } else {
            ItemStack recipeOutput = ArcaneRecipeHelper.INSTANCE.getRecipeOutput(this.internalInventory, 21, 9, this.activeRecipe);
            if (recipeOutput == null) {
                saveState = CoreSaveState.Disabled_InvalidRecipe;
            } else {
                boolean isNew;
                boolean bl = isNew = !this.kCoreHandler.hasPatternFor(recipeOutput);
                saveState = isNew ? (this.kCoreHandler.hasRoomToStorePattern() ? CoreSaveState.Enabled_Save : CoreSaveState.Disabled_CoreFull) : CoreSaveState.Enabled_Delete;
            }
        }
        return saveState;
    }

    private void initCraftingSlots() {
        int slotIndex = 21;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int index = row * 3 + column;
                int posX = 26 + 18 * column;
                int posY = 90 + 18 * row;
                this.craftingSlots[index] = new SlotFakeCraftingMatrix((IInventory)this.internalInventory, slotIndex++, posX, posY);
                this.func_75146_a((Slot)this.craftingSlots[index]);
            }
        }
    }

    private void initPatternSlots() {
        int slotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 7; ++column) {
                int index = row * 7 + column;
                int posX = 26 + 18 * column;
                int posY = 18 + 18 * row;
                this.patternSlots[index] = new SlotInaccessible((IInventory)this.internalInventory, slotIndex++, posX, posY);
                this.func_75146_a((Slot)this.patternSlots[index]);
            }
        }
    }

    private void loadPattern(ArcaneCraftingPattern pattern) {
        if (pattern == null || !pattern.isPatternValid()) {
            return;
        }
        for (int index = 0; index < this.craftingSlots.length; ++index) {
            IAEItemStack ingStack = pattern.getInputs()[index];
            if (ingStack != null) {
                this.craftingSlots[index].func_75215_d(ingStack.getItemStack());
                continue;
            }
            this.craftingSlots[index].func_75215_d(null);
        }
    }

    private Object preparePatternInput(Object input, int slotNumber) {
        if (input instanceof ArrayList) {
            ItemStack preferedItem = this.craftingSlots[slotNumber].func_75211_c();
            ArrayList<ItemStack> ingList = new ArrayList<ItemStack>();
            if (preferedItem != null) {
                ingList.add(preferedItem);
            }
            ArrayList inputList = (ArrayList)input;
            for (ItemStack item : inputList) {
                if (item == null || ItemStack.func_77989_b((ItemStack)preferedItem, (ItemStack)item)) continue;
                ingList.add(item);
            }
            return ingList;
        }
        if (input instanceof ItemStack && ((ItemStack)input).func_77960_j() == Short.MAX_VALUE) {
            ArrayList<ItemStack> ingList = new ArrayList<ItemStack>();
            ingList.add(this.craftingSlots[slotNumber].func_75211_c());
            ingList.add((ItemStack)input);
            return ingList;
        }
        return input;
    }

    private boolean prepareShapless(Object[] inputs) {
        ShapelessArcaneRecipe recipe = (ShapelessArcaneRecipe)this.activeRecipe;
        ArrayList ings = recipe.getInput();
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            ItemStack slotStack = this.craftingSlots[slotIndex].func_75211_c();
            if (slotStack == null) continue;
            Object matchingIng = null;
            for (int ingIndex = 0; ingIndex < ings.size(); ++ingIndex) {
                Object ing = ings.get(ingIndex);
                if (!ArcaneCraftingPattern.canSubstitueFor(ing, slotStack)) continue;
                matchingIng = ing;
                break;
            }
            if (matchingIng == null) {
                return false;
            }
            inputs[ingIndex] = this.preparePatternInput(matchingIng, slotIndex);
        }
        return true;
    }

    private void updatePatternSlots() {
        Iterator<ItemStack> iterator = null;
        if (this.kCoreHandler.hasCore()) {
            ArrayList<ItemStack> storedResults = this.kCoreHandler.getStoredOutputs();
            iterator = storedResults.iterator();
        }
        for (SlotInaccessible patternSlot : this.patternSlots) {
            if (iterator != null && iterator.hasNext()) {
                patternSlot.func_75215_d(iterator.next());
            } else {
                patternSlot.func_75215_d(null);
            }
            for (int cIndex = 0; cIndex < this.field_75149_d.size(); ++cIndex) {
                ((ICrafting)this.field_75149_d.get(cIndex)).func_71111_a((Container)this, patternSlot.field_75222_d, patternSlot.func_75211_c());
            }
        }
    }

    @Override
    protected boolean detectAndSendChangesMP(@Nonnull EntityPlayerMP playerMP) {
        if (!this.kCoreHandler.isHandlingCore(this.kCoreSlot.func_75211_c())) {
            if (this.kCoreSlot.func_75216_d()) {
                this.kCoreHandler.open(this.kCoreSlot.func_75211_c());
            } else {
                this.kCoreHandler.close();
            }
            this.updatePatternSlots();
            this.sendSaveState(false);
            return true;
        }
        return false;
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.inscriber != null) {
            return this.inscriber.func_70300_a(player);
        }
        return false;
    }

    public void onClientRequestClearGrid() {
        for (int index = 21; index < 30; ++index) {
            this.internalInventory.func_70299_a(index, null);
        }
        this.func_75130_a(this.internalInventory);
    }

    public void onClientRequestSaveOrDelete(EntityPlayer player) {
        ArcaneCraftingPattern pattern;
        CoreSaveState saveState = this.getSaveState();
        Object[] inputs = new Object[9];
        if (saveState == CoreSaveState.Enabled_Save) {
            if (this.activeRecipe instanceof ShapedArcaneRecipe) {
                ShapedArcaneRecipe recipe = (ShapedArcaneRecipe)this.activeRecipe;
                for (int slotNumber = 0; slotNumber < recipe.input.length; ++slotNumber) {
                    inputs[slotNumber] = this.preparePatternInput(recipe.input[slotNumber], slotNumber);
                }
            } else if (this.activeRecipe instanceof ShapelessArcaneRecipe) {
                if (!this.prepareShapless(inputs)) {
                    return;
                }
            } else {
                return;
            }
            AspectList recipeAspects = ArcaneRecipeHelper.INSTANCE.getRecipeAspectCost(this.internalInventory, 21, 9, this.activeRecipe);
            ArcaneCraftingPattern pattern2 = new ArcaneCraftingPattern(this.kCoreSlot.func_75211_c(), recipeAspects, this.resultSlot.func_75211_c(), inputs);
            this.kCoreHandler.addPattern(pattern2);
            this.updatePatternSlots();
            this.loadPattern(pattern2);
            this.sendSaveState(true);
            this.inscriber.func_70296_d();
        } else if (saveState == CoreSaveState.Enabled_Delete && (pattern = this.kCoreHandler.getPatternForItem(this.resultSlot.func_75211_c())) != null) {
            this.kCoreHandler.removePattern(pattern);
            this.updatePatternSlots();
            this.sendSaveState(false);
            this.inscriber.func_70296_d();
        }
    }

    public void onClientRequestSaveState() {
        this.sendSaveState(false);
    }

    public void func_75130_a(IInventory inv) {
        this.activeRecipe = ArcaneRecipeHelper.INSTANCE.findMatchingArcaneResult(inv, 21, 9, this.player);
        ItemStack craftResult = null;
        if (this.activeRecipe != null) {
            craftResult = ArcaneRecipeHelper.INSTANCE.getRecipeOutput(inv, 21, 9, this.activeRecipe);
        }
        this.resultSlot.func_75215_d(craftResult);
        if (EffectiveSide.isServerSide()) {
            this.sendSaveState(false);
        }
        this.func_75142_b();
    }

    public void sendSaveState(boolean justSaved) {
        Packet_C_KnowledgeInscriber.sendSaveState(this.player, this.getSaveState(), justSaved);
    }

    public ItemStack func_75144_a(int slotNumber, int buttonPressed, int flag, EntityPlayer player) {
        ItemStack draggingStack = player.field_71071_by.func_70445_o();
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            if (slotFakeCraftingMatrix.field_75222_d != slotNumber) continue;
            if (draggingStack != null) {
                ItemStack copiedStack = draggingStack.func_77946_l();
                copiedStack.field_77994_a = 1;
                slotFakeCraftingMatrix.func_75215_d(copiedStack);
            } else {
                slotFakeCraftingMatrix.func_75215_d(null);
            }
            this.func_75130_a(slotFakeCraftingMatrix.field_75224_c);
            return draggingStack;
        }
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.patternSlots) {
            if (slotFakeCraftingMatrix.field_75222_d != slotNumber) continue;
            if (slotFakeCraftingMatrix.func_75216_d()) {
                this.loadPattern(this.kCoreHandler.getPatternForItem(slotFakeCraftingMatrix.func_75211_c()));
                this.func_75130_a(slotFakeCraftingMatrix.field_75224_c);
            }
            return draggingStack;
        }
        return super.func_75144_a(slotNumber, buttonPressed, flag, player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        if (EffectiveSide.isClientSide()) {
            return null;
        }
        Slot slot = this.getSlotOrNull(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            boolean didMerge = false;
            ItemStack slotStack = slot.func_75211_c();
            if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                if (slotStack.func_77973_b() instanceof ItemKnowledgeCore) {
                    didMerge = this.func_75135_a(slotStack, this.kCoreSlot.field_75222_d, this.kCoreSlot.field_75222_d + 1, false);
                }
                if (!didMerge) {
                    didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                }
            } else if (this.kCoreSlot.field_75222_d == slotNumber && !(didMerge = this.mergeSlotWithHotbarInventory(slotStack))) {
                didMerge = this.mergeSlotWithPlayerInventory(slotStack);
            }
            if (didMerge) {
                if (slotStack == null || slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
                this.func_75142_b();
            }
        }
        return null;
    }

    public static enum CoreSaveState {
        Disabled_InvalidRecipe,
        Disabled_CoreFull,
        Disabled_MissingCore,
        Enabled_Save,
        Enabled_Delete;

    }
}

