/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.tiles;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.core.localization.WailaText;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketAssemblerAnimation;
import appeng.me.GridAccessException;
import appeng.parts.automation.BlockUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.grid.IDigiVisSource;
import thaumicenergistics.client.gui.ThEGuiHelper;
import thaumicenergistics.common.integration.IWailaSource;
import thaumicenergistics.common.integration.tc.ArcaneCraftingPattern;
import thaumicenergistics.common.integration.tc.DigiVisSourceData;
import thaumicenergistics.common.integration.tc.VisCraftingHelper;
import thaumicenergistics.common.inventory.HandlerKnowledgeCore;
import thaumicenergistics.common.inventory.TheInternalInventory;
import thaumicenergistics.common.items.ItemKnowledgeCore;
import thaumicenergistics.common.utils.EffectiveSide;

public class TileArcaneAssembler
extends AENetworkInvTile
implements ICraftingProvider,
IWailaSource {
    private static final String NBTKEY_VIS_INTERFACE = "vis_interface";
    private static final String NBTKEY_UPGRADES = "upgradeCount";
    private static final String NBTKEY_UPGRADEINV = "upgrades";
    private static final String NBTKEY_CRAFTING = "isCrafting";
    private static final String NBTKEY_CRAFTING_PATTERN = "pattern";
    public static final String NBTKEY_STORED_VIS = "stored_vis";
    private static final int CVIS_MULTIPLER = 10;
    private static final int BASE_TICKS_PER_CRAFT = 20;
    public static final Aspect[] PRIMALS = new Aspect[]{Aspect.AIR, Aspect.WATER, Aspect.FIRE, Aspect.ORDER, Aspect.ENTROPY, Aspect.EARTH};
    public static final int SLOT_COUNT = 27;
    public static final int KCORE_SLOT_INDEX = 0;
    public static final int PATTERN_SLOT_INDEX = 1;
    public static final int TARGET_SLOT_INDEX = 22;
    public static final int DISCOUNT_ARMOR_INDEX = 23;
    public static final int MAX_STORED_CVIS = 1500;
    public static double IDLE_POWER = 0.0;
    public static double ACTIVE_POWER = 1.5;
    public static double WARP_POWER_PERCENT = 0.15;
    private final AAInv internalInventory;
    private UpgradeInventory upgradeInventory;
    private boolean isCrafting = false;
    private ArcaneCraftingPattern currentPattern = null;
    private final HandlerKnowledgeCore kCoreHandler;
    private boolean stalePatterns = false;
    private DigiVisSourceData visSourceInfo = new DigiVisSourceData();
    private AspectList storedVis = new AspectList();
    private int visTickCounter = 0;
    private int craftTickCounter = 0;
    private int delayTickCounter = 0;
    private MachineSource mySource;
    private boolean isActive = false;
    private int upgradeCount = 0;
    private Hashtable<Aspect, Float> visDiscount = new Hashtable();
    private float warpPowerMultiplier = 1.0f;
    private boolean delayedUpdate = false;
    boolean flag_CoreChanged = false;
    boolean flag_RecalcVis = false;

    public TileArcaneAssembler() {
        this.internalInventory = new AAInv();
        this.upgradeInventory = new BlockUpgradeInventory(ThEApi.instance().blocks().ArcaneAssembler.getBlock(), (IAEAppEngInventory)this, 4);
        this.mySource = new MachineSource((IActionHost)this);
        for (Aspect primal : PRIMALS) {
            this.visDiscount.put(primal, Float.valueOf(VisCraftingHelper.INSTANCE.getScepterVisModifier(primal)));
        }
        this.kCoreHandler = new HandlerKnowledgeCore();
        this.getProxy().setIdlePowerUsage(IDLE_POWER);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public static NBTTagCompound getCraftTag() {
        NBTTagCompound data = new NBTTagCompound();
        AspectList vis = new AspectList();
        for (Aspect primal : PRIMALS) {
            vis.add(primal, 1500);
        }
        vis.writeToNBT(data, NBTKEY_STORED_VIS);
        return data;
    }

    private void calculateVisDiscounts() {
        this.flag_RecalcVis = false;
        for (Aspect primal : PRIMALS) {
            float discount = VisCraftingHelper.INSTANCE.getScepterVisModifier(primal);
            this.visDiscount.put(primal, Float.valueOf(discount -= VisCraftingHelper.INSTANCE.calculateArmorDiscount(this.internalInventory, 23, 4, primal)));
        }
        this.warpPowerMultiplier = 1.0f;
        this.warpPowerMultiplier = (float)((double)this.warpPowerMultiplier + (double)VisCraftingHelper.INSTANCE.calculateArmorWarp(this.internalInventory, 23, 4) * WARP_POWER_PERCENT);
    }

    private void craftingTick() {
        if (this.currentPattern == null) {
            this.isCrafting = false;
        }
        if (!this.hasEnoughVisForCraft()) {
            return;
        }
        if (this.craftTickCounter >= this.ticksPerCraft()) {
            try {
                IStorageGrid storageGrid = this.getProxy().getStorage();
                boolean rejected = false;
                for (IAEItemStack output : this.currentPattern.getAllResults()) {
                    IAEItemStack rejectedResult = (IAEItemStack)storageGrid.getItemInventory().injectItems((IAEStack)output, Actionable.SIMULATE, (BaseActionSource)this.mySource);
                    if (rejectedResult == null || rejectedResult.getStackSize() <= 0L) continue;
                    rejected = true;
                    break;
                }
                if (!rejected) {
                    for (IAEItemStack output : this.currentPattern.getAllResults()) {
                        storageGrid.getItemInventory().injectItems((IAEStack)output, Actionable.MODULATE, (BaseActionSource)this.mySource);
                    }
                    this.isCrafting = false;
                    this.internalInventory.func_70299_a(22, null);
                    this.currentPattern = null;
                    this.markForDelayedUpdate();
                }
            }
            catch (GridAccessException storageGrid) {}
        } else {
            try {
                double powerRequired = (ACTIVE_POWER + ACTIVE_POWER * (double)this.upgradeCount / 2.0) * (double)this.warpPowerMultiplier;
                IEnergyGrid eGrid = this.getProxy().getEnergy();
                double powerExtracted = eGrid.extractAEPower(powerRequired, Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (powerExtracted - powerRequired <= 0.0) {
                    ++this.craftTickCounter;
                    if (this.craftTickCounter >= this.ticksPerCraft()) {
                        Aspect[] requiredAspects;
                        for (Aspect aspect : requiredAspects = this.currentPattern.getCachedAspects()) {
                            int requiredAmount = this.getRequiredAmountForAspect(aspect);
                            this.storedVis.reduce(aspect, requiredAmount);
                        }
                        this.markForDelayedUpdate();
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private int getRequiredAmountForAspect(Aspect aspect) {
        return (int)Math.ceil(this.visDiscount.get(aspect).floatValue() * (float)(this.currentPattern.getAspectCost(aspect) * 10));
    }

    private boolean hasEnoughVisForCraft() {
        Aspect[] requiredAspects;
        if (this.currentPattern == null) {
            return false;
        }
        for (Aspect aspect : requiredAspects = this.currentPattern.getCachedAspects()) {
            int requiredAmount = this.getRequiredAmountForAspect(aspect);
            if (this.storedVis.getAmount(aspect) >= requiredAmount) continue;
            return false;
        }
        return true;
    }

    private boolean isActive() {
        if (EffectiveSide.isServerSide() && this.getProxy() != null && this.getProxy().getNode() != null) {
            this.isActive = this.getProxy().getNode().isActive();
        }
        return this.isActive;
    }

    private void markForDelayedUpdate() {
        this.delayedUpdate = true;
    }

    private void replenishVis() {
        IDigiVisSource visSource = null;
        if (!this.getProxy().isReady()) {
            return;
        }
        try {
            visSource = this.visSourceInfo.tryGetSource(this.getProxy().getGrid());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (visSource == null) {
            return;
        }
        for (Aspect primal : PRIMALS) {
            int amountDrained;
            int numNeeded = 1500 - this.storedVis.getAmount(primal);
            if (numNeeded <= 0 || (amountDrained = visSource.consumeVis(primal, numNeeded)) <= 0) continue;
            this.storedVis.add(primal, amountDrained);
            this.markForDelayedUpdate();
        }
    }

    private int ticksPerCraft() {
        return 20 - 4 * this.upgradeCount;
    }

    private void updateCoreHandler() {
        this.flag_CoreChanged = false;
        ItemStack kCore = this.internalInventory.func_70301_a(0);
        if (kCore != null) {
            if (!this.kCoreHandler.isHandlingCore(kCore)) {
                this.kCoreHandler.open(kCore);
                this.updatePatternSlots();
            }
        } else if (this.kCoreHandler.hasCore()) {
            this.kCoreHandler.close();
            this.updatePatternSlots();
        }
    }

    private void updatePatternSlots() {
        Iterator<ItemStack> pIterator = null;
        if (this.kCoreHandler != null) {
            ArrayList<ItemStack> patternOutputs = this.kCoreHandler.getStoredOutputs();
            pIterator = patternOutputs.iterator();
        }
        for (int index = 1; index < 22; ++index) {
            if (pIterator != null && pIterator.hasNext()) {
                this.internalInventory.func_70299_a(index, pIterator.next());
                continue;
            }
            this.internalInventory.func_70299_a(index, null);
        }
        this.stalePatterns = true;
    }

    protected ItemStack getItemFromTile(Object obj) {
        return ThEApi.instance().blocks().ArcaneAssembler.getStack();
    }

    @Override
    public void addWailaInformation(List<String> tooltip) {
        if (this.isActive()) {
            tooltip.add(WailaText.DeviceOnline.getLocal());
        } else {
            tooltip.add(WailaText.DeviceOffline.getLocal());
        }
        if (this.isCrafting && this.internalInventory.getHasStack(22)) {
            tooltip.add(String.format("%s, %.0f%%", this.internalInventory.func_70301_a(22).func_82833_r(), Float.valueOf(this.getPercentComplete() * 100.0f)));
        }
        StringBuilder strAspects = new StringBuilder();
        for (int i = 0; i < PRIMALS.length; ++i) {
            Aspect primal = PRIMALS[i];
            strAspects.append(ThEGuiHelper.INSTANCE.getAspectChatColor(primal));
            strAspects.append((float)this.storedVis.getAmount(primal) / 10.0f);
            if (i + 1 >= PRIMALS.length) continue;
            strAspects.append(EnumChatFormatting.WHITE.toString());
            strAspects.append(" | ");
        }
        tooltip.add(strAspects.toString());
    }

    @MENetworkEventSubscribe
    public final void channelEvent(MENetworkChannelsChanged event) {
        this.markForUpdate();
    }

    public int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return new int[0];
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public void getDrops(World world, int x, int y, int z, List<ItemStack> drops) {
        int i;
        ItemStack kCore = this.internalInventory.func_70301_a(0);
        if (kCore != null) {
            drops.add(kCore);
        }
        for (i = 0; i < this.upgradeInventory.func_70302_i_(); ++i) {
            ItemStack upgrade = this.upgradeInventory.func_70301_a(i);
            if (upgrade == null) continue;
            drops.add(upgrade);
        }
        for (i = 0; i < 4; ++i) {
            ItemStack armor = this.internalInventory.func_70301_a(23 + i);
            if (armor == null) continue;
            drops.add(armor);
        }
    }

    public IInventory getInternalInventory() {
        return this.internalInventory;
    }

    public HandlerKnowledgeCore getKCoreHandler() {
        return this.kCoreHandler;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public float getPercentComplete() {
        float percent = 0.0f;
        if (this.isCrafting) {
            percent = Math.min((float)this.craftTickCounter / (float)this.ticksPerCraft(), 1.0f);
        }
        return percent;
    }

    public AspectList getStoredVis() {
        return this.storedVis;
    }

    public UpgradeInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public float getVisDiscountForAspect(Aspect aspect) {
        return this.visDiscount.get(aspect).floatValue();
    }

    public boolean isBusy() {
        return this.isCrafting;
    }

    public boolean func_94041_b(int slotId, ItemStack itemStack) {
        if (slotId == 0) {
            return itemStack == null || itemStack.func_77973_b() instanceof ItemKnowledgeCore;
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (EffectiveSide.isClientSide()) {
            return false;
        }
        if (!this.internalInventory.isUseableByPlayer(player, (TileEntity)this)) {
            return false;
        }
        try {
            ISecurityGrid sGrid = this.getProxy().getSecurity();
            return sGrid.hasPermission(player, SecurityPermissions.INJECT) && sGrid.hasPermission(player, SecurityPermissions.EXTRACT);
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    public void onBreak() {
        this.isCrafting = false;
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        this.upgradeCount = 0;
        IMaterials aeMaterals = AEApi.instance().definitions().materials();
        for (int i = 0; i < this.upgradeInventory.func_70302_i_(); ++i) {
            ItemStack slotStack = this.upgradeInventory.func_70301_a(i);
            if (slotStack == null || !aeMaterals.cardSpeed().isSameAs(slotStack)) continue;
            ++this.upgradeCount;
        }
        if (EffectiveSide.isServerSide()) {
            this.func_70296_d();
            this.markForUpdate();
        }
    }

    public void onMemoryCardActivate(EntityPlayer player, IMemoryCard memoryCard, ItemStack playerHolding) {
        String settingsName = memoryCard.getSettingsName(playerHolding);
        if (settingsName.equals(DigiVisSourceData.SOURCE_UNLOC_NAME)) {
            NBTTagCompound data = memoryCard.getData(playerHolding);
            this.visSourceInfo.readFromNBT(data);
            if (this.visSourceInfo.hasSourceData()) {
                memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
            }
            this.func_70296_d();
        } else if (settingsName.equals("gui.appliedenergistics2.Blank")) {
            this.visSourceInfo.clearData();
            memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
            this.func_70296_d();
        }
    }

    public void onReady() {
        super.onReady();
        this.updateCoreHandler();
        if (this.internalInventory.getHasStack(0)) {
            if (this.currentPattern != null) {
                this.currentPattern.setKnowledgeCore(this.internalInventory.func_70301_a(0));
            }
        } else if (this.currentPattern != null) {
            this.isCrafting = false;
            this.currentPattern = null;
        }
        this.calculateVisDiscounts();
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    @SideOnly(value=Side.CLIENT)
    public boolean onReceiveNetworkData(ByteBuf stream) {
        int i;
        this.isActive = stream.readBoolean();
        this.isCrafting = stream.readBoolean();
        if (this.isCrafting) {
            this.craftTickCounter = stream.readInt();
            for (i = 0; i < 2; ++i) {
                Thaumcraft.proxy.blockRunes(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 0.5f, 0.0f, 0.5f, 10, -0.1f);
            }
        }
        this.storedVis.aspects.clear();
        for (i = 0; i < PRIMALS.length; ++i) {
            this.storedVis.add(PRIMALS[i], stream.readInt());
        }
        this.upgradeCount = stream.readInt();
        return true;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void onSendNetworkData(ByteBuf stream) throws IOException {
        stream.writeBoolean(this.isActive());
        stream.writeBoolean(this.isCrafting);
        if (this.isCrafting) {
            stream.writeInt(this.craftTickCounter);
        }
        for (int i = 0; i < PRIMALS.length; ++i) {
            stream.writeInt(this.storedVis.getAmount(PRIMALS[i]));
        }
        stream.writeInt(this.upgradeCount);
    }

    @TileEvent(value=TileEventType.TICK)
    public void onTick() {
        if (this.flag_RecalcVis) {
            this.calculateVisDiscounts();
        }
        if (EffectiveSide.isClientSide()) {
            if (this.isCrafting && this.craftTickCounter < 20) {
                ++this.craftTickCounter;
            }
            return;
        }
        if (this.flag_CoreChanged) {
            this.updateCoreHandler();
        }
        if (!this.isActive()) {
            return;
        }
        if (this.stalePatterns && this.getProxy().isReady()) {
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getActionableNode()));
                this.stalePatterns = false;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (this.visSourceInfo.hasSourceData()) {
            ++this.visTickCounter;
            if (this.visTickCounter == 5) {
                this.visTickCounter = 0;
                this.replenishVis();
            }
        }
        if (this.delayedUpdate) {
            ++this.delayTickCounter;
            if (this.delayTickCounter >= 5) {
                this.markForUpdate();
                this.delayedUpdate = false;
                this.delayTickCounter = 0;
            }
        }
        if (this.isCrafting) {
            this.craftingTick();
        }
    }

    @MENetworkEventSubscribe
    public final void powerEvent(MENetworkPowerStatusChange event) {
        this.markForUpdate();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.kCoreHandler != null) {
            ArrayList<ArcaneCraftingPattern> corePatterns = this.kCoreHandler.getPatterns();
            for (ArcaneCraftingPattern pattern : corePatterns) {
                if (pattern == null) continue;
                craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)pattern);
            }
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (!this.isCrafting && patternDetails instanceof ArcaneCraftingPattern) {
            this.isCrafting = true;
            this.craftTickCounter = 0;
            this.currentPattern = (ArcaneCraftingPattern)patternDetails;
            this.internalInventory.func_70299_a(22, this.currentPattern.getResult().getItemStack());
            try {
                NetworkRegistry.TargetPoint where = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0);
                NetworkHandler.instance.sendToAllAround((AppEngPacket)new PacketAssemblerAnimation(this.field_145851_c, this.field_145848_d, this.field_145849_e, (byte)(10 + 9 * this.upgradeCount), this.currentPattern.getResult()), where);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_ArcaneAssembler(NBTTagCompound data) {
        if (data.func_74764_b(NBTKEY_VIS_INTERFACE)) {
            this.visSourceInfo.readFromNBT(data, NBTKEY_VIS_INTERFACE);
        }
        this.readVisLevelsFromNBT(data);
        if (data.func_74764_b(NBTKEY_UPGRADES)) {
            this.upgradeCount = data.func_74762_e(NBTKEY_UPGRADES);
        }
        this.upgradeInventory.readFromNBT(data, NBTKEY_UPGRADEINV);
        if (data.func_74764_b(NBTKEY_CRAFTING)) {
            this.isCrafting = data.func_74767_n(NBTKEY_CRAFTING);
        }
        if (data.func_74764_b(NBTKEY_CRAFTING_PATTERN)) {
            this.currentPattern = new ArcaneCraftingPattern(null, data.func_74775_l(NBTKEY_CRAFTING_PATTERN));
        }
    }

    public void readVisLevelsFromNBT(NBTTagCompound data) {
        if (data.func_74764_b(NBTKEY_STORED_VIS)) {
            this.storedVis.readFromNBT(data, NBTKEY_STORED_VIS);
        }
    }

    public void setOwner(EntityPlayer player) {
        this.getProxy().setOwner(player);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_ArcaneAssembler(NBTTagCompound data) {
        this.visSourceInfo.writeToNBT(data, NBTKEY_VIS_INTERFACE);
        this.writeVisLevelsToNBT(data);
        data.func_74768_a(NBTKEY_UPGRADES, this.upgradeCount);
        this.upgradeInventory.writeToNBT(data, NBTKEY_UPGRADEINV);
        data.func_74757_a(NBTKEY_CRAFTING, this.isCrafting);
        if (this.currentPattern != null) {
            data.func_74782_a(NBTKEY_CRAFTING_PATTERN, (NBTBase)this.currentPattern.writeToNBT(new NBTTagCompound()));
        }
    }

    public void writeVisLevelsToNBT(NBTTagCompound data) {
        if (this.storedVis.size() > 0) {
            this.storedVis.writeToNBT(data, NBTKEY_STORED_VIS);
        }
    }

    private class AAInv
    extends TheInternalInventory {
        public AAInv() {
            super("ArcaneAssemblerInventory", 27, 64);
        }

        @Override
        public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return itemStack == null || itemStack.func_77973_b() instanceof ItemKnowledgeCore;
            }
            return true;
        }

        @Override
        public void func_70296_d() {
            TileArcaneAssembler.this.func_70296_d();
        }

        @Override
        public void func_70299_a(int slotIndex, ItemStack itemStack) {
            super.func_70299_a(slotIndex, itemStack);
            if (slotIndex == 0) {
                TileArcaneAssembler.this.flag_CoreChanged = true;
            }
            if (slotIndex >= 23) {
                TileArcaneAssembler.this.flag_RecalcVis = true;
            }
        }
    }
}

