/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.config.RedstoneMode;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.container.ContainerWithNetworkTool;
import thaumicenergistics.common.network.packet.client.Packet_C_AspectSlot;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaIOBus;
import thaumicenergistics.common.parts.ThEPartEssentiaIOBus_Base;

public class ContainerPartEssentiaIOBus
extends ContainerWithNetworkTool {
    private static int NUMBER_OF_UPGRADE_SLOTS = 4;
    private static int UPGRADE_X_POS = 187;
    private static int UPGRADE_Y_POS = 8;
    private static int PLAYER_INV_POSITION_Y = 102;
    private static int HOTBAR_INV_POSITION_Y = 160;
    private final ThEPartEssentiaIOBus_Base bus;
    private boolean isVoidAllowed;

    public ContainerPartEssentiaIOBus(ThEPartEssentiaIOBus_Base part, EntityPlayer player) {
        super(player);
        this.bus = part;
        this.bindPlayerInventory((IInventory)player.field_71071_by, PLAYER_INV_POSITION_Y, HOTBAR_INV_POSITION_Y);
        this.addUpgradeSlots(part.getUpgradeInventory(), NUMBER_OF_UPGRADE_SLOTS, UPGRADE_X_POS, UPGRADE_Y_POS);
        this.bindToNetworkTool(player.field_71071_by, part.getHost().getLocation(), 0, 0);
        this.bus.addListener(this);
    }

    @Override
    protected boolean detectAndSendChangesMP(EntityPlayerMP playerMP) {
        if (this.isVoidAllowed != this.bus.isVoidAllowed()) {
            this.isVoidAllowed = this.bus.isVoidAllowed();
            Packet_C_EssentiaIOBus.sendVoidMode(this.player, this.isVoidAllowed);
        }
        return false;
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.bus != null) {
            return this.bus.isPartUseableByPlayer(player);
        }
        return false;
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        if (this.bus != null) {
            this.bus.removeListener(this);
        }
    }

    public void setFilteredAspect(List<Aspect> filteredAspects) {
        Packet_C_AspectSlot.setFilterList(filteredAspects, this.player);
    }

    public void setFilterSize(byte filterSize) {
        Packet_C_EssentiaIOBus.sendFilterSize(this.player, filterSize);
    }

    public void setRedstoneControlled(boolean isRedstoneControlled) {
        Packet_C_EssentiaIOBus.sendRedstoneControlled(this.player, isRedstoneControlled);
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        Packet_C_EssentiaIOBus.sendRedstoneMode(this.player, redstoneMode);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        Slot slot = this.getSlotOrNull(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            if (this.bus != null && this.bus.addFilteredAspectFromItemstack(player, slot.func_75211_c())) {
                return null;
            }
            return super.func_82846_b(player, slotNumber);
        }
        return null;
    }
}

