/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.me.ItemRepo;
import appeng.client.render.AppEngRenderItem;
import appeng.core.AEConfig;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.config.Config;
import thaumicenergistics.client.gui.ThEGuiHelper;
import thaumicenergistics.client.gui.abstraction.GuiConstants_ACT;
import thaumicenergistics.client.gui.abstraction.ThEScrollbarGui;
import thaumicenergistics.client.gui.buttons.GuiButtonClearCraftingGrid;
import thaumicenergistics.client.gui.buttons.GuiButtonSearchMode;
import thaumicenergistics.client.gui.buttons.GuiButtonSortingDirection;
import thaumicenergistics.client.gui.buttons.GuiButtonSortingMode;
import thaumicenergistics.client.gui.buttons.GuiButtonSwapArmor;
import thaumicenergistics.client.gui.buttons.GuiButtonTerminalStyle;
import thaumicenergistics.client.gui.buttons.GuiButtonViewType;
import thaumicenergistics.client.gui.widget.WidgetAEItem;
import thaumicenergistics.client.textures.AEStateIconsEnum;
import thaumicenergistics.client.textures.GuiTextureManager;
import thaumicenergistics.common.container.ContainerPartArcaneCraftingTerminal;
import thaumicenergistics.common.integration.AEHooks;
import thaumicenergistics.common.integration.tc.MEItemAspectBridgeContainer;
import thaumicenergistics.common.network.packet.server.Packet_S_ArcaneCraftingTerminal;
import thaumicenergistics.common.parts.PartArcaneCraftingTerminal;
import thaumicenergistics.common.registries.ThEStrings;
import thaumicenergistics.common.utils.ThEUtils;

@SideOnly(value=Side.CLIENT)
public class GuiArcaneCraftingTerminal
extends GuiConstants_ACT
implements ISortSource {
    private AppEngRenderItem aeItemRenderer = new AppEngRenderItem();
    private String guiTitle;
    private int widgetCount = 27;
    private List<WidgetAEItem> itemWidgets = new ArrayList<WidgetAEItem>();
    private EntityPlayer player;
    private GuiTextField searchField;
    private final ItemRepo repo;
    private SortOrder sortingOrder = SortOrder.NAME;
    private SortDir sortingDirection = SortDir.ASCENDING;
    private ViewItems viewMode = ViewItems.ALL;
    private TerminalStyle terminalStyle = TerminalStyle.SMALL;
    private int lowerTerminalYOffset = 0;
    private int previousMouseX = 0;
    private int previousMouseY = 0;
    private WidgetAEItem previousWidgetUnderMouse = null;
    private long lastTooltipUpdateTime = 0L;
    private MEItemAspectBridgeContainer meAspectBridge;
    private int numberOfWidgetRows = 3;
    private GuiButtonSortingMode btnSortingMode;
    private GuiButtonSortingDirection btnSortingDirection;
    private GuiButtonViewType btnViewType;
    private GuiButtonSearchMode btnSearchMode;
    private boolean viewNeedsUpdate = true;
    private ArrayList<String> cachedItemTooltip = new ArrayList();

    public GuiArcaneCraftingTerminal(PartArcaneCraftingTerminal part, EntityPlayer player) {
        super(new ContainerPartArcaneCraftingTerminal(part, player));
        this.player = player;
        this.field_146999_f = 230;
        this.field_147000_g = 243;
        this.guiTitle = ThEStrings.Gui_TitleArcaneCraftingTerminal.getLocalized();
        this.repo = new ItemRepo((IScrollSource)this.scrollBar, (ISortSource)this);
        this.terminalStyle = (TerminalStyle)AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE);
    }

    private boolean clickHandler_RegionDeposit(int mouseX, int mouseY) {
        Slot slotClicked;
        if (Keyboard.isKeyDown((int)57) && (slotClicked = this.getSlotAtMousePosition(mouseX, mouseY)) != null) {
            Packet_S_ArcaneCraftingTerminal.sendDepositRegion(this.player, slotClicked.field_75222_d);
            return true;
        }
        return false;
    }

    private boolean clickHandler_SearchBox(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 1 && ThEGuiHelper.INSTANCE.isPointInGuiRegion(6, 98, 10, 65, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            this.searchField.func_146180_a("");
            this.repo.setSearchString("");
            this.viewNeedsUpdate = true;
            this.searchField.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
            return true;
        }
        return false;
    }

    private boolean clickHandler_Widgets(int mouseX, int mouseY, int mouseButton) {
        if (ThEGuiHelper.INSTANCE.isPointInGuiRegion(17, 7, this.numberOfWidgetRows * 18, 161, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            boolean doExtract = this.player.field_71071_by.func_70445_o() == null;
            if (doExtract |= Keyboard.isKeyDown((int)42) && mouseButton == 1) {
                this.sendItemWidgetClicked(mouseX, mouseY, mouseButton);
            } else {
                Packet_S_ArcaneCraftingTerminal.sendDeposit(this.player, mouseButton);
            }
            return true;
        }
        return false;
    }

    private void doMEWheelAction(int deltaZ, int mouseX, int mouseY) {
        if (ThEGuiHelper.INSTANCE.isPointInGuiRegion(17, 7, this.numberOfWidgetRows * 18, 161, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            if (deltaZ > 0) {
                if (this.player.field_71071_by.func_70445_o() != null) {
                    Packet_S_ArcaneCraftingTerminal.sendDeposit(this.player, -2);
                }
            } else {
                this.sendItemWidgetClicked(mouseX, mouseY, -2);
            }
        }
    }

    private void drawCraftingAspects(List<ContainerPartArcaneCraftingTerminal.ArcaneCrafingCost> craftingCost) {
        int posY = 90 + this.lowerTerminalYOffset;
        int column = 0;
        for (ContainerPartArcaneCraftingTerminal.ArcaneCrafingCost cost : craftingCost) {
            float alpha = 1.0f;
            if (!cost.hasEnoughVis) {
                alpha = ThEUtils.pingPongFromTime(0.5, 0.25f, 0.75f);
            }
            int posX = 136 + column * 18;
            UtilsFX.drawTag((int)posX, (int)posY, (Aspect)cost.primal, (float)cost.visCost, (int)0, (double)this.field_73735_i, (int)771, (float)alpha, (boolean)false);
            if (++column != 2) continue;
            column = 0;
            posY += 18;
        }
    }

    private WidgetAEItem drawItemWidgets(int mouseX, int mouseY) {
        boolean hasNoOverlay = true;
        WidgetAEItem widgetUnderMouse = null;
        for (int index = 0; index < this.widgetCount; ++index) {
            WidgetAEItem currentWidget = this.itemWidgets.get(index);
            currentWidget.drawWidget();
            if (!hasNoOverlay || !currentWidget.isMouseOverWidget(mouseX, mouseY)) continue;
            currentWidget.drawMouseHoverUnderlay();
            hasNoOverlay = false;
            widgetUnderMouse = currentWidget;
        }
        return widgetUnderMouse;
    }

    private void sendItemWidgetClicked(int mouseX, int mouseY, int mouseButton) {
        for (int index = 0; index < this.widgetCount; ++index) {
            WidgetAEItem currentWidget = this.itemWidgets.get(index);
            if (!currentWidget.isMouseOverWidget(mouseX, mouseY)) continue;
            IAEItemStack widgetStack = currentWidget.getItemStack();
            if (widgetStack != null) {
                if ((widgetStack.getStackSize() == 0L || mouseButton == 2) && widgetStack.isCraftable() && mouseButton != 1) {
                    Packet_S_ArcaneCraftingTerminal.sendAutoCraft(this.player, widgetStack);
                    return;
                }
                Packet_S_ArcaneCraftingTerminal.sendExtract(this.player, widgetStack, mouseButton, GuiScreen.func_146272_n());
            }
            return;
        }
    }

    private void setupTerminalStyle() {
        int extraRows = 0;
        if (this.terminalStyle == TerminalStyle.TALL) {
            extraRows = Math.max(0, (this.field_146295_m - 243) / 18 - 3);
        }
        this.field_147000_g = 243 + extraRows * 18;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.numberOfWidgetRows = 3 + extraRows;
        this.widgetCount = this.numberOfWidgetRows * 9;
        try {
            this.meAspectBridge = new MEItemAspectBridgeContainer(this.widgetCount);
        }
        catch (Exception e) {
            this.meAspectBridge = null;
        }
        this.itemWidgets.clear();
        for (int row = 0; row < this.numberOfWidgetRows; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = row * 9 + column;
                int posX = 7 + column * 18;
                int posY = 17 + row * 18;
                this.itemWidgets.add(new WidgetAEItem(this, posX, posY, this.aeItemRenderer));
                if (this.meAspectBridge == null) continue;
                this.meAspectBridge.addSlot(index, posX, posY);
            }
        }
        this.updateScrollbarRange();
        this.setScrollBarHeight(52 + extraRows * 18);
        int prevYOffset = this.lowerTerminalYOffset;
        this.lowerTerminalYOffset = extraRows * 18;
        if (prevYOffset != this.lowerTerminalYOffset) {
            ((ContainerPartArcaneCraftingTerminal)this.field_147002_h).changeSlotsYOffset(this.lowerTerminalYOffset - prevYOffset);
        }
        this.cachedItemTooltip.clear();
    }

    private void updateMEWidgets() {
        int repoIndex = 0;
        for (int index = 0; index < this.widgetCount; ++index) {
            IAEItemStack stack;
            if ((stack = this.repo.getReferenceItem(repoIndex++)) != null) {
                this.itemWidgets.get(index).setItemStack(stack);
                if (this.meAspectBridge == null) continue;
                this.meAspectBridge.setSlot(index, stack.getItemStack().func_77946_l());
                continue;
            }
            this.itemWidgets.get(index).setItemStack(null);
            if (this.meAspectBridge == null) continue;
            this.meAspectBridge.setSlot(index, null);
        }
    }

    private void updateScrollbarRange() {
        int totalNumberOfRows = (int)Math.ceil((double)this.repo.size() / 9.0);
        int max = Math.max(0, totalNumberOfRows - this.numberOfWidgetRows);
        this.scrollBar.setRange(0, max, 2);
    }

    private void updateSorting() {
        this.btnSortingDirection.setSortingDirection(this.sortingDirection);
        this.btnSortingMode.setSortMode(this.sortingOrder);
        this.btnViewType.setViewMode(this.viewMode);
        this.viewNeedsUpdate = true;
    }

    private void updateView() {
        this.viewNeedsUpdate = false;
        this.repo.updateView();
        this.updateScrollbarRange();
        this.updateMEWidgets();
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        if (this.viewNeedsUpdate) {
            this.updateView();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiTextureManager.ARCANE_CRAFTING_TERMINAL.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 195, 35);
        for (int i = 0; i < this.numberOfWidgetRows - 3; ++i) {
            int yPos = this.field_147009_r + 35 + i * 18;
            this.func_73729_b(this.field_147003_i, yPos, 0, 35, 195, 18);
        }
        this.func_73729_b(this.field_147003_i, this.field_147009_r + 35 + this.lowerTerminalYOffset, 0, 35, 195, 208);
        this.func_73729_b(this.field_147003_i + 195, this.field_147009_r, 195, 0, 35, 104);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AEStateIconsEnum.AE_STATES_TEXTURE);
        int u = AEStateIconsEnum.VIEW_CELL_BACKGROUND.getU();
        int v = AEStateIconsEnum.VIEW_CELL_BACKGROUND.getV();
        int h = AEStateIconsEnum.VIEW_CELL_BACKGROUND.getHeight();
        int w = AEStateIconsEnum.VIEW_CELL_BACKGROUND.getWidth();
        int x = this.field_147003_i + ContainerPartArcaneCraftingTerminal.VIEW_SLOT_XPOS;
        int y = this.field_147009_r + ContainerPartArcaneCraftingTerminal.VIEW_SLOT_YPOS;
        for (int row = 0; row < 5; ++row) {
            this.func_73729_b(x, y + row * 18, u, v, w, h);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        boolean forceTooltipUpdate;
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.guiTitle, 8, 6, 0);
        this.searchField.func_146194_f();
        GL11.glEnable((int)2896);
        WidgetAEItem widgetUnderMouse = this.drawItemWidgets(mouseX, mouseY);
        List<ContainerPartArcaneCraftingTerminal.ArcaneCrafingCost> craftingCost = ((ContainerPartArcaneCraftingTerminal)this.field_147002_h).getCraftingCost(false);
        if (!craftingCost.isEmpty()) {
            this.drawCraftingAspects(craftingCost);
        }
        boolean bl = forceTooltipUpdate = System.currentTimeMillis() - this.lastTooltipUpdateTime >= 3000L;
        if (forceTooltipUpdate || this.previousMouseX != mouseX || this.previousMouseY != mouseY) {
            if (widgetUnderMouse != null) {
                if (forceTooltipUpdate || widgetUnderMouse != this.previousWidgetUnderMouse) {
                    this.cachedItemTooltip.clear();
                    widgetUnderMouse.getTooltip(this.cachedItemTooltip);
                    this.lastTooltipUpdateTime = System.currentTimeMillis();
                }
            } else {
                this.cachedItemTooltip.clear();
            }
            this.previousMouseX = mouseX;
            this.previousMouseY = mouseY;
            this.previousWidgetUnderMouse = widgetUnderMouse;
        }
        if (!this.cachedItemTooltip.isEmpty()) {
            this.tooltip.addAll(this.cachedItemTooltip);
        }
    }

    @Override
    protected ThEScrollbarGui.ScrollbarParams getScrollbarParameters() {
        return new ThEScrollbarGui.ScrollbarParams(175, 18, 52 + (3 - this.numberOfWidgetRows) * 18);
    }

    @Override
    protected void func_73869_a(char key, int keyID) {
        if (keyID == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        if (key == ' ' && this.searchField.func_146179_b().length() == 0) {
            return;
        }
        if (this.searchField.func_146201_a(key, keyID)) {
            String newSearch = this.searchField.func_146179_b().trim().toLowerCase();
            if (!newSearch.equals(this.repo.getSearchString())) {
                this.repo.setSearchString(newSearch);
                this.viewNeedsUpdate = true;
            }
        } else {
            super.func_73869_a(key, keyID);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.clickHandler_Widgets(mouseX, mouseY, mouseButton)) {
            return;
        }
        if (this.clickHandler_RegionDeposit(mouseX, mouseY)) {
            return;
        }
        if (this.clickHandler_SearchBox(mouseX, mouseY, mouseButton)) {
            return;
        }
        SearchBoxMode searchBoxMode = (SearchBoxMode)AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        if (searchBoxMode != SearchBoxMode.AUTOSEARCH && searchBoxMode != SearchBoxMode.NEI_AUTOSEARCH) {
            this.searchField.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void onButtonClicked(GuiButton button, int mouseButton) {
        boolean sortingChanged = false;
        boolean wasLeftClick = true;
        switch (mouseButton) {
            case 0: {
                break;
            }
            case 1: {
                wasLeftClick = false;
                break;
            }
            default: {
                return;
            }
        }
        switch (button.field_146127_k) {
            case 0: {
                Packet_S_ArcaneCraftingTerminal.sendClearGrid(this.player);
                break;
            }
            case 1: {
                switch (this.sortingOrder) {
                    case AMOUNT: {
                        this.sortingOrder = wasLeftClick ? SortOrder.MOD : SortOrder.NAME;
                        break;
                    }
                    case INVTWEAKS: {
                        break;
                    }
                    case MOD: {
                        this.sortingOrder = wasLeftClick ? SortOrder.NAME : SortOrder.AMOUNT;
                        break;
                    }
                    case NAME: {
                        this.sortingOrder = wasLeftClick ? SortOrder.AMOUNT : SortOrder.MOD;
                    }
                }
                sortingChanged = true;
                break;
            }
            case 2: {
                switch (this.sortingDirection) {
                    case ASCENDING: {
                        this.sortingDirection = SortDir.DESCENDING;
                        break;
                    }
                    case DESCENDING: {
                        this.sortingDirection = SortDir.ASCENDING;
                    }
                }
                sortingChanged = true;
                break;
            }
            case 3: {
                this.viewMode = (ViewItems)Platform.rotateEnum((Enum)this.viewMode, (!wasLeftClick ? 1 : 0) != 0, (EnumSet)Settings.VIEW_MODE.getPossibleValues());
                sortingChanged = true;
                break;
            }
            case 4: {
                Packet_S_ArcaneCraftingTerminal.sendSwapArmor(this.player);
                break;
            }
            case 6: {
                switch (this.terminalStyle) {
                    case SMALL: {
                        this.terminalStyle = TerminalStyle.TALL;
                        break;
                    }
                    case TALL: {
                        this.terminalStyle = TerminalStyle.SMALL;
                        break;
                    }
                    default: {
                        this.terminalStyle = TerminalStyle.SMALL;
                    }
                }
                AEConfig.instance.getConfigManager().putSetting(Settings.TERMINAL_STYLE, (Enum)this.terminalStyle);
                this.func_73866_w_();
                break;
            }
            case 5: {
                SearchBoxMode searchBoxMode = (SearchBoxMode)AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
                searchBoxMode = (SearchBoxMode)Platform.rotateEnum((Enum)searchBoxMode, (!wasLeftClick ? 1 : 0) != 0, (EnumSet)Settings.SEARCH_MODE.getPossibleValues());
                this.searchField.func_146195_b(searchBoxMode == SearchBoxMode.AUTOSEARCH || searchBoxMode == SearchBoxMode.NEI_AUTOSEARCH);
                AEConfig.instance.settings.putSetting(Settings.SEARCH_MODE, (Enum)searchBoxMode);
                this.btnSearchMode.setSearchMode(searchBoxMode);
                this.cachedItemTooltip.clear();
                this.lastTooltipUpdateTime = 0L;
            }
        }
        if (sortingChanged) {
            this.updateSorting();
            this.lastTooltipUpdateTime = 0L;
            Packet_S_ArcaneCraftingTerminal.sendMode(this.player, this.sortingOrder, this.sortingDirection, this.viewMode);
        }
    }

    @Override
    protected void onMouseWheel(int deltaZ, int mouseX, int mouseY) {
        if (mouseX > this.field_147003_i + 230) {
            return;
        }
        if (GuiScreen.func_146272_n()) {
            this.doMEWheelAction(deltaZ, mouseX, mouseY);
        } else {
            this.scrollBar.wheel(deltaZ);
            this.onScrollbarMoved();
        }
    }

    @Override
    protected void onScrollbarMoved() {
        this.updateMEWidgets();
        this.cachedItemTooltip.clear();
        this.lastTooltipUpdateTime = 0L;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float mouseBtn) {
        super.func_73863_a(mouseX, mouseY, mouseBtn);
        if (this.meAspectBridge != null && !Config.showTags == Keyboard.isKeyDown((int)42)) {
            this.meAspectBridge.renderAspects(this, this.player);
        }
    }

    public Enum getSortBy() {
        return this.sortingOrder;
    }

    public Enum getSortDir() {
        return this.sortingDirection;
    }

    public Enum getSortDisplay() {
        return this.viewMode;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Mouse.getDWheel();
        Keyboard.enableRepeatEvents((boolean)true);
        this.setupTerminalStyle();
        SearchBoxMode searchBoxMode = (SearchBoxMode)AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        if (this.searchField == null) {
            this.searchField = new GuiTextField(this.field_146289_q, 98, 6, 65, 10);
            this.searchField.func_146185_a(false);
            this.searchField.func_146203_f(15);
        }
        this.searchField.func_146195_b(searchBoxMode == SearchBoxMode.AUTOSEARCH || searchBoxMode == SearchBoxMode.NEI_AUTOSEARCH);
        this.searchField.func_146180_a(this.repo.getSearchString());
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButtonClearCraftingGrid(0, this.field_147003_i + 98, this.field_147009_r + 89 + this.lowerTerminalYOffset, 8, 8, true));
        this.btnSortingMode = new GuiButtonSortingMode(1, this.field_147003_i + -18, this.field_147009_r + 8, 16, 16);
        this.field_146292_n.add(this.btnSortingMode);
        this.btnSortingDirection = new GuiButtonSortingDirection(2, this.field_147003_i + -18, this.field_147009_r + 28, 16, 16);
        this.field_146292_n.add(this.btnSortingDirection);
        this.btnViewType = new GuiButtonViewType(3, this.field_147003_i + -18, this.field_147009_r + 48, 16, 16);
        this.field_146292_n.add(this.btnViewType);
        this.field_146292_n.add(new GuiButtonSwapArmor(4, this.field_147003_i + 26, this.field_147009_r + 112 + this.lowerTerminalYOffset, 8, 8));
        this.btnSearchMode = new GuiButtonSearchMode(5, this.field_147003_i + -18, this.field_147009_r + 68, 16, 16, searchBoxMode);
        this.field_146292_n.add(this.btnSearchMode);
        this.field_146292_n.add(new GuiButtonTerminalStyle(6, this.field_147003_i + -18, this.field_147009_r + 88, 16, 16, this.terminalStyle));
        ((ContainerPartArcaneCraftingTerminal)this.field_147002_h).registerForUpdates();
        Packet_S_ArcaneCraftingTerminal.sendFullListRequest(this.player);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void onReceiveChange(IAEItemStack change) {
        if (AEHooks.isItemGUIBlacklisted(change)) {
            return;
        }
        this.repo.postUpdate(change);
        this.viewNeedsUpdate = true;
    }

    public void onReceiveFullList(IItemList<IAEItemStack> itemList) {
        this.repo.clear();
        for (IAEItemStack stack : itemList) {
            this.onReceiveChange(stack);
        }
    }

    public void onReceiveSorting(SortOrder order, SortDir direction, ViewItems viewMode) {
        this.sortingDirection = direction;
        this.sortingOrder = order;
        this.viewMode = viewMode;
        this.updateSorting();
    }

    public void onServerSendForceUpdateCost() {
        ((ContainerPartArcaneCraftingTerminal)this.field_147002_h).getCraftingCost(true);
    }

    public void onViewCellsChanged(ItemStack[] viewCells) {
        this.repo.setViewCell(viewCells);
        this.viewNeedsUpdate = true;
    }
}

