/*
 * Decompiled with CFR 0.152.
 */
package thaumicboots.main.utils.compat;

import flaxbeard.thaumicexploration.ThaumicExploration;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import taintedmagic.common.registry.ItemRegistry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.common.config.ConfigItems;
import thaumicboots.api.TB_Aspect;
import thaumicboots.main.Config;
import thaumicboots.main.utils.BlockInterface;
import thaumicboots.main.utils.CalendarHelper;
import thaumicboots.main.utils.ItemInterface;
import thaumicboots.main.utils.LocalizationManager;
import thaumicboots.main.utils.compat.EMTHelper;
import thaumicboots.main.utils.compat.ExplorationsHelper;
import thaumicboots.main.utils.compat.IModHelper;
import thaumicboots.main.utils.compat.TaintedHelper;

public class ThaumcraftHelper
implements IModHelper {
    public static Block plant;
    public static Block candle;
    public static Block crystal;
    public static Block marker;
    public static Block jar;
    public static Block log;
    public static Block leaf;
    public static Block warded;
    public static Block wooden;
    public static Block metal;
    public static Block airy;
    public static Item filledJar;
    public static Item miscResource;
    public static Item shard;
    public static Item golem;
    public static Item nuggetMetal;
    public static Item nuggetChicken;
    public static Item nuggetBeef;
    public static Item nuggetPork;
    public static Item zombieBrain;
    public static final String THAUMCRAFT = "Thaumcraft";
    public static CrucibleRecipe thaumaturgicCombinator;
    public static InfusionRecipe voidMeteor;
    public static InfusionRecipe voidComet;
    public static InfusionRecipe cometMeteor;
    public static InfusionRecipe meteorComet;
    public static InfusionRecipe seasonalBoot;
    public static CrucibleRecipe seasonalToChristmas;
    public static CrucibleRecipe slowBoot;

    @Override
    public void preInit() {
        TB_Aspect.addTB_Aspects();
    }

    @Override
    public void init() {
        ThaumcraftHelper.getBlocks();
        ThaumcraftHelper.getItems();
    }

    @Override
    public void postInit() {
        ThaumcraftHelper.setupItemAspects();
        ThaumcraftHelper.setupCrafting();
        ThaumcraftHelper.setupResearch();
        if (EMTHelper.isActive()) {
            EMTHelper.setupItemAspects();
            EMTHelper.setupCrafting();
            EMTHelper.setupResearch();
        }
    }

    public static void getBlocks() {
        plant = BlockInterface.getBlock(THAUMCRAFT, "blockCustomPlant");
        candle = BlockInterface.getBlock(THAUMCRAFT, "blockCandle");
        crystal = BlockInterface.getBlock(THAUMCRAFT, "blockCrystal");
        marker = BlockInterface.getBlock(THAUMCRAFT, "blockMarker");
        jar = BlockInterface.getBlock(THAUMCRAFT, "blockJar");
        log = BlockInterface.getBlock(THAUMCRAFT, "blockMagicalLog");
        leaf = BlockInterface.getBlock(THAUMCRAFT, "blockMagicalLeaves");
        warded = BlockInterface.getBlock(THAUMCRAFT, "blockWarded");
        wooden = BlockInterface.getBlock(THAUMCRAFT, "blockWoodenDevice");
        metal = BlockInterface.getBlock(THAUMCRAFT, "blockMetalDevice");
        airy = BlockInterface.getBlock(THAUMCRAFT, "blockAiry");
    }

    public static void getItems() {
        filledJar = ItemInterface.getItem(THAUMCRAFT, "BlockJarFilledItem");
        miscResource = ItemInterface.getItem(THAUMCRAFT, "ItemResource");
        shard = ItemInterface.getItem(THAUMCRAFT, "ItemShard");
        golem = ItemInterface.getItem(THAUMCRAFT, "ItemGolemPlacer");
        nuggetMetal = ItemInterface.getItem(THAUMCRAFT, "ItemNugget");
        shard = ItemInterface.getItem(THAUMCRAFT, "ItemShard");
        nuggetChicken = ItemInterface.getItem(THAUMCRAFT, "ItemNuggetChicken");
        nuggetBeef = ItemInterface.getItem(THAUMCRAFT, "ItemNuggetBeef");
        nuggetPork = ItemInterface.getItem(THAUMCRAFT, "ItemNuggetPork");
        zombieBrain = ItemInterface.getItem(THAUMCRAFT, "ItemZombieBrain");
    }

    public static void setupCrafting() {
        thaumaturgicCombinator = ThaumcraftApi.addCrucibleRecipe((String)"TB_Core_Research", (ItemStack)new ItemStack(Config.arcaniumLens), (Object)new ItemStack(miscResource, 1, MiscResource.THAUMIUM.ordinal()), (AspectList)new AspectList().add(TB_Aspect.BOOTS, 25).add(Aspect.EXCHANGE, 25).add(TB_Aspect.SPACE, 25));
        seasonalBoot = ThaumcraftApi.addInfusionCraftingRecipe((String)"TB_Seasonal_Boots", (Object)new ItemStack(Config.seasonBoots), (int)10, (AspectList)new AspectList().add(TB_Aspect.BOOTS, 75).add(Aspect.LIGHT, 50).add(Aspect.MAGIC, 50).add(Aspect.MOTION, 50).add(Aspect.AURA, 25), (ItemStack)new ItemStack(ConfigItems.itemBootsTraveller), (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151152_bP, 1, Short.MAX_VALUE), new ItemStack(Items.field_151100_aR, 1, 10), new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151152_bP, 1, Short.MAX_VALUE), new ItemStack(Items.field_151040_l), new ItemStack(Blocks.field_150428_aP), new ItemStack(ConfigItems.itemFocusFrost), new ItemStack(Blocks.field_150345_g, 1, 1)});
        slowBoot = ThaumcraftApi.addCrucibleRecipe((String)"TB_Unique_Boots", (ItemStack)new ItemStack(Config.slowBoots), (Object)new ItemStack(ConfigItems.itemBootsTraveller), (AspectList)new AspectList().add(Aspect.TRAP, 25).add(TB_Aspect.BOOTS, 25).add(Aspect.EXCHANGE, 10));
        if (CalendarHelper.isChristmas()) {
            seasonalToChristmas = ThaumcraftApi.addCrucibleRecipe((String)"TB_Seasonal_Boots", (ItemStack)new ItemStack(Config.christmasBoots), (Object)new ItemStack(Config.seasonBoots), (AspectList)new AspectList().add(Aspect.TRAP, 50).add(Aspect.EXCHANGE, 25).add(Aspect.COLD, 25));
        }
        if (!(EMTHelper.isActive() || ExplorationsHelper.isActive() || TaintedHelper.isActive())) {
            return;
        }
        if (ExplorationsHelper.isActive() && TaintedHelper.isActive()) {
            voidMeteor = ThaumcraftApi.addInfusionCraftingRecipe((String)"TB_Explorations_Tainted_Compat", (Object)new ItemStack(ExplorationsHelper.bootsMeteorVoid), (int)0, (AspectList)new AspectList().add(Aspect.EXCHANGE, 75).add(Aspect.MAGIC, 50).add(Aspect.CRAFT, 50).add(TB_Aspect.SPACE, 25).add(TB_Aspect.BOOTS, 25), (ItemStack)new ItemStack(Config.arcaniumLens), (ItemStack[])new ItemStack[]{new ItemStack(ItemRegistry.ItemVoidwalkerBoots), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ThaumicExploration.bootsMeteor), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal())});
            voidComet = ThaumcraftApi.addInfusionCraftingRecipe((String)"TB_Explorations_Tainted_Compat", (Object)new ItemStack(ExplorationsHelper.bootsCometVoid), (int)0, (AspectList)new AspectList().add(Aspect.EXCHANGE, 75).add(Aspect.MAGIC, 50).add(Aspect.CRAFT, 50).add(TB_Aspect.SPACE, 25).add(TB_Aspect.BOOTS, 25), (ItemStack)new ItemStack(Config.arcaniumLens), (ItemStack[])new ItemStack[]{new ItemStack(ItemRegistry.ItemVoidwalkerBoots), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ThaumicExploration.bootsComet), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal())});
        }
        if (ExplorationsHelper.isActive()) {
            cometMeteor = ThaumcraftApi.addInfusionCraftingRecipe((String)"TB_Explorations_Compat", (Object)new ItemStack(ExplorationsHelper.bootsCometMeteor), (int)0, (AspectList)new AspectList().add(Aspect.EXCHANGE, 75).add(Aspect.MAGIC, 50).add(Aspect.CRAFT, 50).add(TB_Aspect.SPACE, 25).add(TB_Aspect.BOOTS, 25), (ItemStack)new ItemStack(Config.arcaniumLens), (ItemStack[])new ItemStack[]{new ItemStack(ThaumicExploration.bootsComet), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ThaumicExploration.bootsMeteor), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal())});
            meteorComet = ThaumcraftApi.addInfusionCraftingRecipe((String)"TB_Explorations_Compat", (Object)new ItemStack(ExplorationsHelper.bootsMeteoricComet), (int)0, (AspectList)new AspectList().add(Aspect.EXCHANGE, 75).add(Aspect.MAGIC, 50).add(Aspect.CRAFT, 50).add(TB_Aspect.SPACE, 25).add(TB_Aspect.BOOTS, 25), (ItemStack)new ItemStack(Config.arcaniumLens), (ItemStack[])new ItemStack[]{new ItemStack(ThaumicExploration.bootsMeteor), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ThaumicExploration.bootsComet), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal()), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(miscResource, 1, MiscResource.SALIS.ordinal())});
        }
    }

    public static void setupResearch() {
        String category = "THAUMICBOOTS";
        ResearchCategories.registerCategory((String)category, (ResourceLocation)new ResourceLocation("thaumicboots", "textures/items/bootsCometMeteor.png"), (ResourceLocation)new ResourceLocation("thaumicboots", "textures/gui/research_bg1_b.png"));
        ResearchItem coreResearch = new ResearchItem("TB_Core_Research", category, new AspectList().add(TB_Aspect.BOOTS, 10).add(Aspect.EXCHANGE, 10), 0, 0, 0, new ItemStack(Config.arcaniumLens));
        ResearchPage core1 = new ResearchPage("Core.1");
        ResearchPage core2 = new ResearchPage(thaumaturgicCombinator);
        coreResearch.setPages(new ResearchPage[]{core1, core2});
        coreResearch.setParents(new String[]{"THAUMIUM"});
        ResearchCategories.addResearch((ResearchItem)coreResearch);
        ResearchItem seasonalCore = new ResearchItem("TB_Seasonal_Boots", category, new AspectList().add(TB_Aspect.BOOTS, 25).add(Aspect.EXCHANGE, 25).add(Aspect.COLD, 25).add(Aspect.MAGIC, 25).add(Aspect.ENERGY, 25), 2, 0, 0, new ItemStack(Config.seasonBoots));
        ResearchPage seasonalCore1 = new ResearchPage("SeasonalCore.1");
        ResearchPage seasonalCore2 = new ResearchPage(seasonalBoot);
        seasonalCore.setPages(new ResearchPage[]{seasonalCore1, seasonalCore2});
        seasonalCore.setParents(new String[]{"TB_Core_Research"});
        ResearchCategories.addResearch((ResearchItem)seasonalCore);
        ResearchItem seasonalStabilized = new ResearchItem("TB_Seasonal_Stabilized", category, new AspectList().add(Aspect.TRAP, 50).add(Aspect.CRYSTAL, 25).add(Aspect.EXCHANGE, 25).add(Aspect.COLD, 25).add(Aspect.LIGHT, 25), 4, 0, 0, new ItemStack(Config.christmasBoots));
        ResearchPage seasonalStabilized1 = new ResearchPage("SeasonalStabilized.1");
        ResearchPage seasonalStabilized2 = CalendarHelper.isChristmas() ? new ResearchPage(seasonalToChristmas) : new ResearchPage("seasonalStabilized.2");
        seasonalStabilized.setPages(new ResearchPage[]{seasonalStabilized1, seasonalStabilized2});
        seasonalStabilized.setParents(new String[]{"TB_Seasonal_Boots"});
        ResearchCategories.addResearch((ResearchItem)seasonalStabilized);
        ResearchItem uniqueCore = new ResearchItem("TB_Unique_Boots", category, new AspectList().add(TB_Aspect.BOOTS, 25).add(Aspect.EXCHANGE, 25).add(Aspect.TOOL, 25).add(Aspect.MAGIC, 25).add(Aspect.ENERGY, 25), -2, 0, 0, new ItemStack(Config.slowBoots));
        ResearchPage uniqueCore1 = new ResearchPage("UniqueCore.1");
        ResearchPage uniqueCore2 = new ResearchPage(slowBoot);
        uniqueCore.setPages(new ResearchPage[]{uniqueCore1, uniqueCore2});
        uniqueCore.setParents(new String[]{"TB_Core_Research"});
        ResearchCategories.addResearch((ResearchItem)uniqueCore);
        if (!(EMTHelper.isActive() || ExplorationsHelper.isActive() || TaintedHelper.isActive())) {
            return;
        }
        if (ExplorationsHelper.isActive()) {
            ResearchItem explorationsCore = new ResearchItem("TB_Explorations_Core", category, new AspectList().add(TB_Aspect.BOOTS, 25).add(TB_Aspect.SPACE, 25).add(Aspect.EXCHANGE, 15), 0, -3, 0, new ItemStack(ThaumicExploration.bootsMeteor));
            ResearchPage explorationsCore1 = new ResearchPage("ExplorationsCore.1");
            explorationsCore.setPages(new ResearchPage[]{explorationsCore1});
            explorationsCore.setConcealed().setParents(new String[]{"METEORBOOTS", "COMETBOOTS"});
            ResearchCategories.addResearch((ResearchItem)explorationsCore);
            ResearchItem explorationsCompat = new ResearchItem("TB_Explorations_Compat", category, new AspectList().add(TB_Aspect.BOOTS, 25).add(TB_Aspect.SPACE, 25).add(Aspect.EXCHANGE, 15), 0, -2, 0, new ItemStack(ExplorationsHelper.bootsCometMeteor));
            ResearchPage explorationsCompat1 = new ResearchPage("ExplorationsCompat.1");
            ResearchPage explorationsCompat2 = new ResearchPage(cometMeteor);
            ResearchPage explorationsCompat3 = new ResearchPage(meteorComet);
            explorationsCompat.setPages(new ResearchPage[]{explorationsCompat1, explorationsCompat2, explorationsCompat3});
            explorationsCompat.setConcealed().setParents(new String[]{"TB_Core_Research", "TB_Explorations_Core"});
            ResearchCategories.addResearch((ResearchItem)explorationsCompat);
        }
        if (TaintedHelper.isActive()) {
            ResearchItem taintedCore = new ResearchItem("TB_Tainted_Core", category, new AspectList().add(TB_Aspect.BOOTS, 25).add(Aspect.ELDRITCH, 25).add(Aspect.EXCHANGE, 15), 3, 2, 0, new ItemStack(ItemRegistry.ItemVoidwalkerBoots));
            ResearchPage taintedCore1 = new ResearchPage("TaintedCore.1");
            taintedCore.setPages(new ResearchPage[]{taintedCore1});
            taintedCore.setConcealed().setParents(new String[]{"VOIDWALKERBOOTS"});
            ResearchCategories.addResearch((ResearchItem)taintedCore);
        }
        if (ExplorationsHelper.isActive() && TaintedHelper.isActive()) {
            ResearchItem explorationsTaintedCompat = new ResearchItem("TB_Explorations_Tainted_Compat", category, new AspectList().add(TB_Aspect.BOOTS, 25).add(TB_Aspect.SPACE, 25).add(Aspect.ELDRITCH, 25).add(Aspect.EXCHANGE, 15), 3, -2, 0, new ItemStack(ExplorationsHelper.bootsMeteorVoid));
            ResearchPage explorationsTainted1 = new ResearchPage("ExplorationsTainted.1");
            ResearchPage explorationsTainted2 = new ResearchPage(voidMeteor);
            ResearchPage explorationsTainted3 = new ResearchPage(voidComet);
            explorationsTaintedCompat.setPages(new ResearchPage[]{explorationsTainted1, explorationsTainted2, explorationsTainted3});
            explorationsTaintedCompat.setConcealed().setParents(new String[]{"TB_Explorations_Core", "TB_Tainted_Core", "TB_Core_Research"});
            ResearchCategories.addResearch((ResearchItem)explorationsTaintedCompat);
        }
    }

    public static ResearchPage getResearchPage(String ident) {
        return new ResearchPage(LocalizationManager.getLocalizedString("tc.research_page." + ident));
    }

    public static void setupItemAspects() {
        AspectList list = new AspectList(new ItemStack((Item)Items.field_151021_T)).add(TB_Aspect.BOOTS, 2);
        ItemStack item = new ItemStack((Item)Items.field_151021_T);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList(new ItemStack((Item)Items.field_151029_X)).add(TB_Aspect.BOOTS, 4);
        item = new ItemStack((Item)Items.field_151029_X);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList(new ItemStack((Item)Items.field_151167_ab)).add(TB_Aspect.BOOTS, 4);
        item = new ItemStack((Item)Items.field_151167_ab);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList(new ItemStack((Item)Items.field_151151_aj)).add(TB_Aspect.BOOTS, 8);
        item = new ItemStack((Item)Items.field_151151_aj);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList(new ItemStack((Item)Items.field_151175_af)).add(TB_Aspect.BOOTS, 16);
        item = new ItemStack((Item)Items.field_151175_af);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList(new ItemStack(ConfigItems.itemBootsCultist)).add(TB_Aspect.BOOTS, 6);
        item = new ItemStack(ConfigItems.itemBootsCultist);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList(new ItemStack(ConfigItems.itemBootsTraveller)).add(TB_Aspect.BOOTS, 12);
        item = new ItemStack(ConfigItems.itemBootsTraveller);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList(new ItemStack(Items.field_151079_bi)).add(TB_Aspect.SPACE, 4);
        item = new ItemStack(Items.field_151079_bi);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList(new ItemStack(Items.field_151061_bv)).add(TB_Aspect.SPACE, 8);
        item = new ItemStack(Items.field_151061_bv);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList(new ItemStack(Items.field_151065_br)).add(TB_Aspect.SPACE, 1);
        item = new ItemStack(Items.field_151065_br);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        list = new AspectList(new ItemStack(Items.field_151072_bj)).add(TB_Aspect.SPACE, 4);
        item = new ItemStack(Items.field_151072_bj);
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        if (ExplorationsHelper.isActive()) {
            list = new AspectList(new ItemStack(ThaumicExploration.bootsComet)).add(TB_Aspect.BOOTS, 12).add(TB_Aspect.SPACE, 8);
            item = new ItemStack(ThaumicExploration.bootsComet);
            ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
            list = new AspectList(new ItemStack(ThaumicExploration.bootsMeteor)).add(TB_Aspect.BOOTS, 12).add(TB_Aspect.SPACE, 8);
            item = new ItemStack(ThaumicExploration.bootsMeteor);
            ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        }
        if (TaintedHelper.isActive()) {
            list = new AspectList(new ItemStack(ItemRegistry.ItemVoidwalkerBoots)).add(TB_Aspect.BOOTS, 12);
            item = new ItemStack(ItemRegistry.ItemVoidwalkerBoots);
            ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)list);
        }
    }

    public static enum MiscResource {
        ALUMENTUM,
        NITOR,
        THAUMIUM,
        QUICKSILVER,
        MAGIC_TALLOW,
        BRAIN_DEPRECATED,
        AMBER,
        ENCHANTED_FABRIC,
        VIS_FILTER,
        KNOWLEDGE_FRAGMENT,
        MIRRORED_GLASS,
        TAINTED_GOO,
        TAINTED_TENDRIL,
        JAR_LABEL,
        SALIS,
        CHARM,
        VOID_INGOT,
        VOID_SEED,
        COIN;

    }

    public static enum TreeType {
        GREATWOOD,
        SILVERWOOD;

    }

    public static enum BlockPlant {
        GREATWOOD_SAPLING,
        SILVERWOOD_SAPLING,
        SHIMMERLEAF,
        CINDERPEARL,
        PURIFYING_PLANT,
        VISHROOM;

    }

    public static enum Entity {
        BRAINY_ZOMBIE("entBrainyZombie", "EntityBrainyZombie"),
        GIANT_BRAINY_ZOMBIE("entGiantBrainyZombie", "EntityGiantBrainyZombie"),
        WISP("entWisp", "EntityWisp"),
        FIREBAT("entFirebat", "EntityFireBat");

        private static final String packageName = "thaumcraft.common.entities.monster.";
        public final String entityID;
        private final String className;

        private Entity(String id, String clazz) {
            this.entityID = id;
            this.className = clazz;
        }

        public String getClassName() {
            return packageName + this.className;
        }
    }

    public static enum AiryBlockType {
        NODE,
        NITOR,
        _2,
        _3,
        WARDING_STONE_FENCE,
        ENERGIZED_NODE;

    }

    public static enum WoodenDeviceType {
        BELLOWS,
        EAR,
        PRESSURE_PLATE,
        PRESSURE_PLATE_B,
        BORE_BASE,
        BORE,
        PLANKS_GREATWOOD,
        PLANKS_SILVERWOOD,
        BANNER;

    }

    public static enum MetalDeviceType {
        CRUCIBLE,
        ALEMBIC,
        VIS_CHARGE_RELAY,
        ADVANCED_ALCHEMICAL_CONSTRUCT,
        _4,
        ITEM_GRATE,
        _6,
        ARCANE_LAMP,
        LAMP_OF_GROWTH,
        ALCHEMICAL_CONSTRUCT,
        THAUMATORIUM,
        _11,
        MNEMONIC_MATRIX,
        LAMP_OF_FERTILITY,
        VIS_RELAY;

    }

    public static enum ShardType {
        AIR,
        FIRE,
        WATER,
        EARTH,
        ORDER,
        CHAOS,
        BALANCED;

    }

    public static enum NuggetType {
        IRON,
        COPPER,
        TIN,
        SILVER,
        LEAD,
        QUICKSILVER,
        THAUMIUM,
        VOID_METAL,
        _8,
        _9,
        _10,
        _11,
        _12,
        _13,
        _14,
        _15,
        NATIVE_IRON,
        NATIVE_COPPER,
        NATIVE_TIN,
        NATIVE_SILVER,
        NATIVE_LEAD,
        NATIVE_CINNABAR,
        _22,
        _23,
        _24,
        _25,
        _26,
        _27,
        _28,
        _29,
        _30,
        NATIVE_GOLD;

    }
}

