/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.util;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import cpw.mods.fml.common.Loader;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;
import ru.timeconqueror.tcneiadditions.client.TCNAClient;
import ru.timeconqueror.tcneiadditions.util.TCNAConfig;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.lib.research.ResearchManager;
import tuhljin.automagy.config.ModResearchItems;

public class TCUtil {
    private static TCNAClient tcnaClient = TCNAClient.getInstance();

    public static List<InfusionRecipe> getInfusionRecipes(ItemStack result) {
        ArrayList<InfusionRecipe> list = new ArrayList<InfusionRecipe>();
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            ItemStack output;
            if (!(r instanceof InfusionRecipe) || !(((InfusionRecipe)r).getRecipeOutput() instanceof ItemStack) || !NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)(output = (ItemStack)((InfusionRecipe)r).getRecipeOutput()), (ItemStack)result)) continue;
            list.add((InfusionRecipe)r);
        }
        return list;
    }

    public static List<CrucibleRecipe> getCrucibleRecipes(ItemStack result) {
        ArrayList<CrucibleRecipe> list = new ArrayList<CrucibleRecipe>();
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            ItemStack output;
            if (!(r instanceof CrucibleRecipe) || ((CrucibleRecipe)r).getRecipeOutput() == null || !NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)(output = ((CrucibleRecipe)r).getRecipeOutput()), (ItemStack)result)) continue;
            list.add((CrucibleRecipe)r);
        }
        return list;
    }

    public static List<InfusionRecipe> getInfusionRecipesByInput(ItemStack input) {
        ArrayList<InfusionRecipe> list = new ArrayList<InfusionRecipe>();
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            InfusionRecipe tcRecipe;
            if (!(r instanceof InfusionRecipe) || (tcRecipe = (InfusionRecipe)r).getRecipeInput() == null || TCUtil.getAssociatedItemStack(tcRecipe.getRecipeOutput()) == null) continue;
            if (input.func_77973_b() instanceof ItemAspect) {
                Aspect aspect = ItemAspect.getAspects((ItemStack)input).getAspects()[0];
                if (!tcRecipe.getAspects().aspects.containsKey(aspect)) continue;
                list.add(tcRecipe);
                continue;
            }
            if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)tcRecipe.getRecipeInput(), (ItemStack)input) && !TCUtil.matchInfusionComponents(tcRecipe.getComponents(), input)) continue;
            list.add(tcRecipe);
        }
        return list;
    }

    public static List<CrucibleRecipe> getCrucibleRecipesByInput(ItemStack input) {
        ArrayList<CrucibleRecipe> list = new ArrayList<CrucibleRecipe>();
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            if (r == null || !(r instanceof CrucibleRecipe)) continue;
            CrucibleRecipe tcRecipe = (CrucibleRecipe)r;
            if (input.func_77973_b() instanceof ItemAspect) {
                Aspect aspect = ItemAspect.getAspects((ItemStack)input).getAspects()[0];
                if (!tcRecipe.aspects.aspects.containsKey(aspect)) continue;
                list.add(tcRecipe);
                continue;
            }
            if (!tcRecipe.catalystMatches(input)) continue;
            list.add(tcRecipe);
        }
        return list;
    }

    public static boolean matchInfusionComponents(ItemStack[] components, ItemStack stack) {
        for (ItemStack component : components) {
            for (ItemStack toCompare : TCUtil.getOreDictionaryMatchingItemsForInfusion(component)) {
                if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)toCompare, (ItemStack)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldShowRecipe(String username, String researchKey) {
        return ThaumcraftApiHelper.isResearchComplete((String)username, (String)researchKey) || TCNAConfig.showLockedRecipes;
    }

    public static ItemStack getAssociatedItemStack(Object o) {
        ItemStack stack;
        if (o instanceof ItemStack && (stack = (ItemStack)o).func_77973_b() == null) {
            return stack;
        }
        return NEIHelper.getAssociatedItemStack((Object)o);
    }

    public static List<ItemStack> getOreDictionaryMatchingItemsForInfusion(ItemStack stack) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            for (ItemStack matchedStack : OreDictionary.getOres((String)OreDictionary.getOreName((int)oreID))) {
                if (matchedStack.func_77960_j() == Short.MAX_VALUE || OreDictionary.getOreIDs((ItemStack)matchedStack).length != 1 || NEIServerUtils.areStacksSameTypeCrafting((ItemStack)matchedStack, (ItemStack)stack)) continue;
                result.add(matchedStack);
            }
        }
        result.add(stack);
        return result;
    }

    public static void getResearchPrerequisites(List<String> list, ResearchItem researchItem) {
        if (researchItem != null) {
            Set<String> set;
            String playerName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
            TCUtil.getResearchListByName(list, researchItem.parents, playerName, "parents");
            TCUtil.getResearchListByName(list, researchItem.parentsHidden, playerName, "parentsHidden");
            if (researchItem.getItemTriggers() != null && researchItem.getItemTriggers().length != 0) {
                list.add(StatCollector.func_74838_a((String)"tcneiadditions.research.prerequisites.item") + ":");
                for (ItemStack itemStack : researchItem.getItemTriggers()) {
                    String displayName = itemStack.func_82833_r();
                    list.add("    " + displayName);
                }
            }
            if (researchItem.getEntityTriggers() != null && researchItem.getEntityTriggers().length != 0) {
                list.add(StatCollector.func_74838_a((String)"tcneiadditions.research.prerequisites.entity") + ":");
                for (String string : researchItem.getEntityTriggers()) {
                    String entityName = StatCollector.func_74838_a((String)("entity." + string + ".name"));
                    list.add("    " + entityName);
                }
            }
            if (researchItem.getAspectTriggers() != null && researchItem.getAspectTriggers().length != 0) {
                list.add(StatCollector.func_74838_a((String)"tcneiadditions.research.prerequisites.aspect") + ":");
                for (Aspect aspect : researchItem.getAspectTriggers()) {
                    String aspectName = aspect.getName() + " - " + aspect.getLocalizedDescription();
                    list.add("    " + aspectName);
                }
            }
            if (Loader.isModLoaded((String)"Automagy") && researchItem.category.equals("AUTOMAGY") && !(set = TCUtil.getKeysByValue(ModResearchItems.cluesOnKill, researchItem.key)).isEmpty()) {
                list.add(StatCollector.func_74838_a((String)"tcneiadditions.research.prerequisites.kill") + ":");
                for (String entityKey : set) {
                    list.add("    " + StatCollector.func_74838_a((String)("entity." + entityKey + ".name")));
                }
            }
        }
    }

    public static <T, E> Set<T> getKeysByValue(Map<T, E> map, E value) {
        return map.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), value)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static void getResearchListByName(List<String> list, String[] researchKeys, String playerName, String keysName) {
        if (researchKeys != null && researchKeys.length != 0) {
            int needResearch = 0;
            list.add(StatCollector.func_74838_a((String)("tcneiadditions.research.prerequisites." + keysName)) + ":");
            for (String researchKey : researchKeys) {
                String researchName = ResearchCategories.getCategoryName((String)ResearchCategories.getResearch((String)researchKey).category) + " : " + ResearchCategories.getResearch((String)researchKey).getName();
                if (ResearchManager.isResearchComplete((String)playerName, (String)researchKey)) {
                    if (researchKeys.length > 10) continue;
                    researchName = EnumChatFormatting.GREEN + "" + EnumChatFormatting.STRIKETHROUGH + researchName;
                    list.add(EnumChatFormatting.RESET + "    " + researchName);
                    continue;
                }
                ++needResearch;
                researchName = EnumChatFormatting.RED + researchName;
                list.add(EnumChatFormatting.RESET + "    " + researchName);
            }
            if (researchKeys.length > 10 && needResearch == 0) {
                list.add(EnumChatFormatting.GREEN + "    " + StatCollector.func_74838_a((String)"tcneiadditions.research.prerequisites.allresearched"));
            }
        }
    }

    public static void loadTransferRects(TemplateRecipeHandler handler) {
        int stringLength = GuiDraw.getStringWidth((String)(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"tcneiadditions.gui.nei.seeAll")));
        handler.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(162 - stringLength, 5, stringLength, 9), handler.getOverlayIdentifier(), new Object[0]));
    }

    public static void drawSeeAllRecipesLabel() {
        GuiDraw.drawStringR((String)(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"tcneiadditions.gui.nei.seeAll")), (int)162, (int)5, (int)tcnaClient.getColor("tcneiadditions.gui.textColor"), (boolean)false);
    }
}

