/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei.arcaneworkbench;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.ModItems;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler.ArcaneShapelessRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.tcneiadditions.client.TCNAClient;
import ru.timeconqueror.tcneiadditions.nei.ResearchInfo;
import ru.timeconqueror.tcneiadditions.nei.arcaneworkbench.IArcaneOverlayProvider;
import ru.timeconqueror.tcneiadditions.util.TCNAConfig;
import ru.timeconqueror.tcneiadditions.util.TCUtil;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.client.lib.UtilsFX;

public class ArcaneCraftingShapelessHandler
extends ArcaneShapelessRecipeHandler {
    private final String userName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private TCNAClient tcnaClient = TCNAClient.getInstance();
    private int ySize;

    public void loadTransferRects() {
        TCUtil.loadTransferRects((TemplateRecipeHandler)this);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                boolean shouldShowRecipe;
                ShapelessArcaneRecipe tcRecipe;
                ArcaneShapelessCachedRecipe recipe;
                if (!(o instanceof ShapelessArcaneRecipe) || !(recipe = new ArcaneShapelessCachedRecipe(tcRecipe = (ShapelessArcaneRecipe)o, shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch()))).isValid()) continue;
                this.arecipes.add(recipe);
                this.aspectsAmount.add(ArcaneCraftingShapelessHandler.getAmounts((ShapelessArcaneRecipe)tcRecipe));
            }
        } else if (outputId.equals("item")) {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            boolean shouldShowRecipe;
            ShapelessArcaneRecipe tcRecipe;
            ArcaneShapelessCachedRecipe recipe;
            if (!(o instanceof ShapelessArcaneRecipe) || !(recipe = new ArcaneShapelessCachedRecipe(tcRecipe = (ShapelessArcaneRecipe)o, shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch()))).isValid() || !NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)tcRecipe.getRecipeOutput(), (ItemStack)result)) continue;
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneCraftingShapelessHandler.getAmounts((ShapelessArcaneRecipe)tcRecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            ShapelessArcaneRecipe tcRecipe;
            ArcaneShapelessCachedRecipe recipe;
            if (!(o instanceof ShapelessArcaneRecipe) || !(recipe = new ArcaneShapelessCachedRecipe(tcRecipe = (ShapelessArcaneRecipe)o, true)).isValid() || !recipe.containsWithNBT(recipe.ingredients, ingredient) || !TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch())) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneCraftingShapelessHandler.getAmounts((ShapelessArcaneRecipe)tcRecipe));
        }
    }

    public void drawBackground(int recipeIndex) {
        ArcaneShapelessCachedRecipe recipe = (ArcaneShapelessCachedRecipe)this.arecipes.get(recipeIndex);
        int x = 34;
        int y = -15;
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)1.7f, (float)1.7f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)20, (int)7, (int)20, (int)3, (int)16, (int)16);
        if (recipe.shouldShowRecipe) {
            GuiDraw.drawTexturedModalRect((int)2, (int)23, (int)112, (int)15, (int)52, (int)52);
        }
        GL11.glPopMatrix();
        if (recipe.shouldShowRecipe) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            GL11.glEnable((int)3042);
            GL11.glTranslatef((float)((float)x - 30.0f), (float)(y + 126), (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)68, (int)76, (int)12, (int)12);
            GL11.glPopMatrix();
            this.drawAspects(recipeIndex);
        }
    }

    public void drawAspects(int recipe) {
        int[] amounts = (int[])this.aspectsAmount.get(recipe);
        AspectList aspects = NEIHelper.getPrimalAspectListFromAmounts((int[])amounts);
        int baseX = 36;
        int baseY = 115;
        int count = 0;
        int columns = aspects.size();
        int xOffset = (100 - columns * 20) / 2;
        for (int column = 0; column < columns; ++column) {
            Aspect aspect = aspects.getAspectsSortedAmount()[count++];
            int posX = baseX + column * 18 + xOffset;
            UtilsFX.drawTag((int)posX, (int)baseY, (Aspect)aspect, (float)0.0f, (int)0, (double)GuiDraw.gui.getZLevel());
        }
    }

    public List<PositionedStack> getIngredientStacksForOverlay(int recipeIndex) {
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        return recipe instanceof IArcaneOverlayProvider ? ((IArcaneOverlayProvider)recipe).getPositionedStacksForOverlay() : null;
    }

    public void drawExtras(int recipeIndex) {
        ArcaneShapelessCachedRecipe cachedRecipe;
        TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        if (cRecipe instanceof ArcaneShapelessCachedRecipe && !(cachedRecipe = (ArcaneShapelessCachedRecipe)cRecipe).shouldShowRecipe) {
            String textToDraw = StatCollector.func_74838_a((String)"tcneiadditions.research.missing");
            int y = 28;
            for (Object text : Minecraft.func_71410_x().field_71466_p.func_78271_c(textToDraw, 162)) {
                GuiDraw.drawStringC((String)((String)text), (int)82, (int)y, (int)this.tcnaClient.getColor("tcneiadditions.gui.textColor"), (boolean)false);
                y += 11;
            }
        }
        if (TCNAConfig.showResearchKey) {
            GuiDraw.drawString((String)(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"tcneiadditions.research.researchName")), (int)0, (int)5, (int)this.tcnaClient.getColor("tcneiadditions.gui.textColor"), (boolean)false);
            if (cRecipe instanceof ArcaneShapelessCachedRecipe) {
                cachedRecipe = (ArcaneShapelessCachedRecipe)cRecipe;
                int recipeY = 15;
                for (ResearchInfo r : cachedRecipe.prereqs) {
                    r.onDraw(0, recipeY);
                    recipeY += 13;
                }
            }
        }
        TCUtil.drawSeeAllRecipesLabel();
    }

    private boolean isValidInput(Object input) {
        return NEIServerUtils.extractRecipeItems((Object)input).length != 0;
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> list, int recipeIndex) {
        if (TCNAConfig.showResearchKey && GuiContainerManager.shouldShowTooltip(gui) && list.isEmpty()) {
            TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
            Point mousePos = GuiDraw.getMousePosition();
            if (cRecipe instanceof ArcaneShapelessCachedRecipe) {
                ArcaneShapelessCachedRecipe cachedRecipe = (ArcaneShapelessCachedRecipe)cRecipe;
                for (ResearchInfo r : cachedRecipe.prereqs) {
                    Rectangle rect = r.getRect(gui, recipeIndex);
                    if (!rect.contains(mousePos)) continue;
                    r.onHover(list);
                }
            }
        }
        return super.handleTooltip(gui, list, recipeIndex);
    }

    private class ArcaneShapelessCachedRecipe
    extends ShapelessRecipeHandler.CachedShapelessRecipe
    implements IArcaneOverlayProvider {
        private final AspectList aspects;
        protected Object[] overlay;
        protected final List<ResearchInfo> prereqs;
        private final boolean shouldShowRecipe;
        private final ResearchItem researchItem;

        public ArcaneShapelessCachedRecipe(ShapelessArcaneRecipe recipe, boolean shouldShowRecipe) {
            super((ShapelessRecipeHandler)ArcaneCraftingShapelessHandler.this, (List)recipe.getInput(), recipe.getRecipeOutput());
            this.result = new PositionedStack((Object)recipe.getRecipeOutput(), 74, 2);
            this.overlay = recipe.getInput().toArray();
            this.aspects = recipe.getAspects();
            this.shouldShowRecipe = shouldShowRecipe;
            this.researchItem = ResearchCategories.getResearch((String)recipe.getResearch());
            this.prereqs = new ArrayList<ResearchInfo>();
            if (this.researchItem != null && this.researchItem.key != null) {
                this.prereqs.add(new ResearchInfo(this.researchItem, ThaumcraftApiHelper.isResearchComplete((String)ArcaneCraftingShapelessHandler.this.userName, (String)this.researchItem.key)));
            }
            this.addAspectsToIngredients(this.aspects);
        }

        public AspectList getAspectList() {
            return this.aspects;
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public void setIngredients(List<?> items) {
            if (!items.isEmpty()) {
                int[][] positions = new int[][]{{48, 32}, {75, 33}, {103, 33}, {49, 60}, {76, 60}, {103, 60}, {49, 87}, {76, 87}, {103, 87}};
                int shiftX = 0;
                int shiftY = 0;
                for (int x = 0; x < items.size(); ++x) {
                    if (items.get(x) == null || !ArcaneCraftingShapelessHandler.this.isValidInput(items.get(x))) continue;
                    PositionedStack stack = new PositionedStack(items.get(x), positions[x][0] + shiftX, positions[x][1] + shiftY, items.get(x) instanceof ItemStack);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        @Override
        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                for (int x = 0; x < this.overlay.length; ++x) {
                    Object object = this.overlay[x];
                    if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && (!(object instanceof List) || ((List)object).isEmpty())) continue;
                    stacks.add(new PositionedStack(object, 40 + x % 3 * 24, 40 + x / 3 * 24));
                }
            }
            return stacks;
        }

        public List<PositionedStack> getIngredients() {
            if (!this.shouldShowRecipe) {
                return Collections.emptyList();
            }
            return super.getIngredients();
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return;
            }
            super.setIngredientPermutation(ingredients, ingredient);
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                Aspect aspect = ItemAspect.getAspects((ItemStack)ingredient).getAspects()[0];
                return this.aspects.aspects.containsKey(aspect);
            }
            return super.contains(ingredients, ingredient);
        }

        protected void addAspectsToIngredients(AspectList aspects) {
            int baseX = 36;
            int baseY = 115;
            int count = 0;
            int columns = aspects.size();
            int xOffset = (100 - columns * 20) / 2;
            for (int column = 0; column < columns; ++column) {
                Aspect aspect = aspects.getAspectsSortedAmount()[count++];
                int posX = baseX + column * 18 + xOffset;
                ItemStack stack = new ItemStack(ModItems.itemAspect, aspects.getAmount(aspect), 1);
                ItemAspect.setAspect((ItemStack)stack, (Aspect)aspect);
                this.ingredients.add(new PositionedStack((Object)stack, posX, baseY, false));
            }
        }
    }
}

