/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei.arcaneworkbench;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler.ArcaneShapelessRecipeHandler;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.tcneiadditions.nei.arcaneworkbench.IArcaneOverlayProvider;
import ru.timeconqueror.tcneiadditions.util.GuiRecipeHelper;
import ru.timeconqueror.tcneiadditions.util.TCNAConfig;
import ru.timeconqueror.tcneiadditions.util.TCUtil;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.client.lib.UtilsFX;

public class ArcaneCraftingShapelessHandler
extends ArcaneShapelessRecipeHandler {
    private final String userName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private int ySize;

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                boolean shouldShowRecipe;
                ShapelessArcaneRecipe tcRecipe;
                ArcaneShapelessCachedRecipe recipe;
                if (!(o instanceof ShapelessArcaneRecipe) || !(recipe = new ArcaneShapelessCachedRecipe(tcRecipe = (ShapelessArcaneRecipe)o, shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch()))).isValid()) continue;
                this.arecipes.add(recipe);
                this.aspectsAmount.add(ArcaneCraftingShapelessHandler.getAmounts((ShapelessArcaneRecipe)tcRecipe));
            }
        } else if (outputId.equals("item")) {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            boolean shouldShowRecipe;
            ShapelessArcaneRecipe tcRecipe;
            ArcaneShapelessCachedRecipe recipe;
            if (!(o instanceof ShapelessArcaneRecipe) || !(recipe = new ArcaneShapelessCachedRecipe(tcRecipe = (ShapelessArcaneRecipe)o, shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch()))).isValid() || !NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)tcRecipe.getRecipeOutput(), (ItemStack)result)) continue;
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneCraftingShapelessHandler.getAmounts((ShapelessArcaneRecipe)tcRecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            ShapelessArcaneRecipe tcRecipe;
            ArcaneShapelessCachedRecipe recipe;
            if (!(o instanceof ShapelessArcaneRecipe) || !(recipe = new ArcaneShapelessCachedRecipe(tcRecipe = (ShapelessArcaneRecipe)o, true)).isValid() || !recipe.containsWithNBT(recipe.ingredients, ingredient) || !TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch())) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneCraftingShapelessHandler.getAmounts((ShapelessArcaneRecipe)tcRecipe));
        }
    }

    public void drawBackground(int recipeIndex) {
        ArcaneShapelessCachedRecipe recipe = (ArcaneShapelessCachedRecipe)this.arecipes.get(recipeIndex);
        if (recipe.shouldShowRecipe) {
            super.drawBackground(recipeIndex);
            return;
        }
        int x = 34;
        int y = -15;
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)1.7f, (float)1.7f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)20, (int)7, (int)20, (int)3, (int)16, (int)16);
        GL11.glPopMatrix();
    }

    public List<PositionedStack> getIngredientStacksForOverlay(int recipeIndex) {
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        return recipe instanceof IArcaneOverlayProvider ? ((IArcaneOverlayProvider)recipe).getPositionedStacksForOverlay() : null;
    }

    public void drawExtras(int recipeIndex) {
        ArcaneShapelessCachedRecipe recipe = (ArcaneShapelessCachedRecipe)this.arecipes.get(recipeIndex);
        if (recipe.shouldShowRecipe) {
            super.drawExtras(recipeIndex);
        } else {
            String textToDraw = I18n.func_135052_a((String)"tcneiadditions.research.missing", (Object[])new Object[0]);
            int y = 28;
            for (Object text : Minecraft.func_71410_x().field_71466_p.func_78271_c(textToDraw, 162)) {
                GuiDraw.drawStringC((String)((String)text), (int)82, (int)y, (int)Color.BLACK.getRGB(), (boolean)false);
                y += 11;
            }
        }
        if (TCNAConfig.showResearchKey) {
            int y = 135;
            String researchString = recipe.researchItem != null ? EnumChatFormatting.UNDERLINE + ResearchCategories.getCategoryName((String)((ArcaneShapelessCachedRecipe)recipe).researchItem.category) + " : " + recipe.researchItem.getName() : EnumChatFormatting.ITALIC + "null";
            List listResearchString = Minecraft.func_71410_x().field_71466_p.func_78271_c(researchString, 162);
            this.ySize = listResearchString.size() * 11;
            ArrayList<String> list = new ArrayList<String>();
            list.add(StatCollector.func_74838_a((String)"tcneiadditions.research.researchName") + ":");
            list.addAll(listResearchString);
            for (Object e : list) {
                GuiDraw.drawStringC((String)((String)e), (int)82, (int)y, (int)Color.BLACK.getRGB(), (boolean)false);
                y += 11;
            }
        }
    }

    private boolean isValidInput(Object input) {
        return NEIServerUtils.extractRecipeItems((Object)input).length != 0;
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> list, int recipeIndex) {
        if (TCNAConfig.showResearchKey && GuiContainerManager.shouldShowTooltip(gui) && list.size() == 0) {
            Point mousePos;
            ArcaneShapelessCachedRecipe recipe = (ArcaneShapelessCachedRecipe)this.arecipes.get(recipeIndex);
            Rectangle rectangle = this.getResearchRect(gui, recipeIndex);
            if (rectangle.contains(mousePos = GuiDraw.getMousePosition())) {
                TCUtil.getResearchPrerequisites(list, recipe.researchItem);
            }
        }
        return super.handleTooltip(gui, list, recipeIndex);
    }

    protected Rectangle getResearchRect(GuiRecipe<?> gui, int recipeIndex) {
        Point offset = gui.getRecipePosition(recipeIndex);
        return new Rectangle(GuiRecipeHelper.getGuiLeft(gui) + offset.x + 2, GuiRecipeHelper.getGuiTop(gui) + offset.y + 146, GuiRecipeHelper.getXSize(gui) - 9, this.ySize);
    }

    private class ArcaneShapelessCachedRecipe
    extends ShapelessRecipeHandler.CachedShapelessRecipe
    implements IArcaneOverlayProvider {
        private final AspectList aspects;
        protected Object[] overlay;
        private final boolean shouldShowRecipe;
        private final ResearchItem researchItem;

        public ArcaneShapelessCachedRecipe(ShapelessArcaneRecipe recipe, boolean shouldShowRecipe) {
            super((ShapelessRecipeHandler)ArcaneCraftingShapelessHandler.this, (List)recipe.getInput(), recipe.getRecipeOutput());
            this.result = new PositionedStack((Object)recipe.getRecipeOutput(), 74, 2);
            this.overlay = recipe.getInput().toArray();
            this.aspects = recipe.getAspects();
            this.shouldShowRecipe = shouldShowRecipe;
            this.researchItem = ResearchCategories.getResearch((String)recipe.getResearch());
            NEIHelper.addAspectsToIngredients((AspectList)this.aspects, (List)this.ingredients, (int)0);
        }

        public AspectList getAspectList() {
            return this.aspects;
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public void setIngredients(List<?> items) {
            if (!items.isEmpty()) {
                int[][] positions = new int[][]{{48, 32}, {75, 33}, {103, 33}, {49, 60}, {76, 60}, {103, 60}, {49, 87}, {76, 87}, {103, 87}};
                int shiftX = 0;
                int shiftY = 0;
                for (int x = 0; x < items.size(); ++x) {
                    if (items.get(x) == null || !ArcaneCraftingShapelessHandler.this.isValidInput(items.get(x))) continue;
                    PositionedStack stack = new PositionedStack(items.get(x), positions[x][0] + shiftX, positions[x][1] + shiftY, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        @Override
        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                for (int x = 0; x < this.overlay.length; ++x) {
                    Object object = this.overlay[x];
                    if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && (!(object instanceof List) || ((List)object).isEmpty())) continue;
                    stacks.add(new PositionedStack(object, 40 + x % 3 * 24, 40 + x / 3 * 24));
                }
            }
            return stacks;
        }

        public List<PositionedStack> getIngredients() {
            if (!this.shouldShowRecipe) {
                return Collections.emptyList();
            }
            return super.getIngredients();
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return;
            }
            super.setIngredientPermutation(ingredients, ingredient);
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                Aspect aspect = ItemAspect.getAspects((ItemStack)ingredient).getAspects()[0];
                return this.aspects.aspects.containsKey(aspect);
            }
            return super.contains(ingredients, ingredient);
        }
    }
}

