/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.ModItems;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler.InfusionRecipeHandler;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.tcneiadditions.util.GuiRecipeHelper;
import ru.timeconqueror.tcneiadditions.util.TCNAConfig;
import ru.timeconqueror.tcneiadditions.util.TCUtil;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.client.lib.UtilsFX;

public class TCNAInfusionRecipeHandler
extends InfusionRecipeHandler {
    private final String userName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private int ySize;

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                boolean shouldShowRecipe;
                InfusionCachedRecipe recipe;
                InfusionRecipe tcRecipe;
                if (!(o instanceof InfusionRecipe) || (tcRecipe = (InfusionRecipe)o).getRecipeInput() == null || TCUtil.getAssociatedItemStack(tcRecipe.getRecipeOutput()) == null || !(recipe = new InfusionCachedRecipe(tcRecipe, shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch()))).isValid()) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(recipe.aspects);
            }
        } else if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (InfusionRecipe tcRecipe : TCUtil.getInfusionRecipes(result)) {
            boolean shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch());
            InfusionCachedRecipe recipe = new InfusionCachedRecipe(tcRecipe, shouldShowRecipe);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
            this.aspectsAmount.add(recipe.aspects);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<InfusionRecipe> tcRecipeList = TCUtil.getInfusionRecipesByInput(ingredient);
        for (InfusionRecipe tcRecipe : tcRecipeList) {
            if (tcRecipe == null || !TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch())) continue;
            InfusionCachedRecipe recipe = new InfusionCachedRecipe(tcRecipe, true);
            recipe.computeVisuals();
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(recipe.aspects);
        }
    }

    public void drawBackground(int recipeIndex) {
        InfusionCachedRecipe recipe = (InfusionCachedRecipe)((Object)this.arecipes.get(recipeIndex));
        if (recipe.shouldShowRecipe) {
            super.drawBackground(recipeIndex);
            return;
        }
        int x = 34;
        int y = -24;
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)(y + 19), (float)0.0f);
        GL11.glScalef((float)1.75f, (float)1.75f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)3, (int)56, (int)17);
        GL11.glPopMatrix();
    }

    public void drawExtras(int recipeIndex) {
        InfusionCachedRecipe recipe = (InfusionCachedRecipe)((Object)this.arecipes.get(recipeIndex));
        if (recipe.shouldShowRecipe) {
            super.drawExtras(recipeIndex);
        } else {
            String textToDraw = I18n.func_135052_a((String)"tcneiadditions.research.missing", (Object[])new Object[0]);
            int y = 28;
            for (Object text : Minecraft.func_71410_x().field_71466_p.func_78271_c(textToDraw, 162)) {
                GuiDraw.drawStringC((String)((String)text), (int)82, (int)y, (int)Color.BLACK.getRGB(), (boolean)false);
                y += 11;
            }
        }
        if (TCNAConfig.showResearchKey) {
            int y = 170;
            String researchString = recipe.researchItem != null ? EnumChatFormatting.UNDERLINE + ResearchCategories.getCategoryName((String)((InfusionCachedRecipe)recipe).researchItem.category) + " : " + recipe.researchItem.getName() : EnumChatFormatting.ITALIC + "null";
            List listResearchString = Minecraft.func_71410_x().field_71466_p.func_78271_c(researchString, 162);
            this.ySize = listResearchString.size() * 11;
            ArrayList<String> list = new ArrayList<String>();
            list.add(StatCollector.func_74838_a((String)"tcneiadditions.research.researchName") + ":");
            list.addAll(listResearchString);
            for (Object e : list) {
                GuiDraw.drawStringC((String)((String)e), (int)82, (int)y, (int)Color.BLACK.getRGB(), (boolean)false);
                y += 11;
            }
        }
    }

    public void drawAspects(int recipe, int x, int y) {
        AspectList aspects = (AspectList)this.aspectsAmount.get(recipe);
        int aspectsPerRow = 7;
        int rows = (int)Math.ceil((double)aspects.size() / (double)aspectsPerRow);
        int baseX = x + 8;
        int baseY = y + 173;
        int count = 0;
        for (int row = 0; row < rows; ++row) {
            int reversedRow = -row + rows - 1;
            int columns = (aspects.size() + reversedRow) / rows;
            int xOffset = (100 - columns * 20) / 2;
            for (int column = 0; column < columns; ++column) {
                Aspect aspect = aspects.getAspectsSortedAmount()[count++];
                int posX = baseX + column * 20 + xOffset;
                int posY = baseY + row * 20;
                UtilsFX.drawTag((int)posX, (int)posY, (Aspect)aspect, (float)aspects.getAmount(aspect), (int)0, (double)GuiDraw.gui.getZLevel());
            }
        }
    }

    public void drawInstability(int recipeIndex, int x, int y) {
        InfusionCachedRecipe recipe = (InfusionCachedRecipe)((Object)this.arecipes.get(recipeIndex));
        if (!recipe.shouldShowRecipe) {
            return;
        }
        if (TCNAConfig.showInstabilityNumber) {
            int[] colors = new int[]{170, 0x5555FF, 0xAA00AA, 0xFFFF55, 0xFFAA00, 0xAA0000};
            int colorIndex = Math.min(5, recipe.getInstability() / 2);
            String text = StatCollector.func_74838_a((String)"tc.inst") + recipe.getInstability();
            GuiDraw.drawString((String)text, (int)(x + 56 - GuiDraw.fontRenderer.func_78256_a(text) / 2), (int)(y + 263), (int)colors[colorIndex], (boolean)false);
        } else {
            int inst = Math.min(5, recipe.getInstability() / 2);
            String text = StatCollector.func_74838_a((String)("tc.inst." + inst));
            GuiDraw.drawString((String)text, (int)(x + 56 - GuiDraw.fontRenderer.func_78256_a(text) / 2), (int)(y + 263), (int)0xFFFFFF, (boolean)false);
        }
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> list, int recipeIndex) {
        if (TCNAConfig.showResearchKey && GuiContainerManager.shouldShowTooltip(gui) && list.size() == 0) {
            Point mousePos;
            InfusionCachedRecipe recipe = (InfusionCachedRecipe)((Object)this.arecipes.get(recipeIndex));
            Rectangle rectangle = this.getResearchRect(gui, recipeIndex);
            if (rectangle.contains(mousePos = GuiDraw.getMousePosition())) {
                TCUtil.getResearchPrerequisites(list, recipe.researchItem);
            }
        }
        return super.handleTooltip(gui, list, recipeIndex);
    }

    protected Rectangle getResearchRect(GuiRecipe<?> gui, int recipeIndex) {
        Point offset = gui.getRecipePosition(recipeIndex);
        return new Rectangle(GuiRecipeHelper.getGuiLeft(gui) + offset.x + 2, GuiRecipeHelper.getGuiTop(gui) + offset.y + 181, GuiRecipeHelper.getXSize(gui) - 9, this.ySize);
    }

    private class InfusionCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final AspectList aspects;
        private PositionedStack result;
        private List<PositionedStack> ingredients;
        private int instability;
        private final boolean shouldShowRecipe;
        private final ResearchItem researchItem;

        public InfusionCachedRecipe(InfusionRecipe recipe, boolean shouldShowRecipe) {
            super((TemplateRecipeHandler)TCNAInfusionRecipeHandler.this);
            this.setIngredients(recipe);
            this.setOutput(recipe);
            this.aspects = recipe.getAspects();
            this.setInstability(recipe.getInstability());
            this.shouldShowRecipe = shouldShowRecipe;
            this.addAspectsToIngredients(this.aspects);
            this.researchItem = ResearchCategories.getResearch((String)recipe.getResearch());
        }

        protected void setInstability(int inst) {
            this.instability = inst;
        }

        protected int getInstability() {
            return this.instability;
        }

        protected void setIngredients(InfusionRecipe recipe) {
            int sy;
            int sx;
            int total;
            this.ingredients = new ArrayList<PositionedStack>();
            this.ingredients.add(new PositionedStack((Object)recipe.getRecipeInput(), 75, 58));
            int x = 27;
            int y = -35;
            int le = recipe.getComponents().length;
            ArrayList<Point> coords = new ArrayList<Point>();
            float pieSlice = 360 / le;
            float currentRot = -90.0f;
            for (total = 0; total < le; ++total) {
                sx = (int)(MathHelper.func_76134_b((float)(currentRot / 180.0f * 3.141593f)) * 40.0f) - 8;
                sy = (int)(MathHelper.func_76126_a((float)(currentRot / 180.0f * 3.141593f)) * 40.0f) - 8;
                currentRot += pieSlice;
                coords.add(new Point(sx, sy));
            }
            total = 0;
            sx = x + 56;
            sy = y + 102;
            for (ItemStack itemStack : recipe.getComponents()) {
                ItemStack ingredient = TCUtil.getAssociatedItemStack(itemStack);
                ingredient.field_77994_a = 1;
                int vx = sx + ((Point)coords.get((int)total)).x;
                int vy = sy + ((Point)coords.get((int)total)).y;
                this.ingredients.add(new PositionedStack(TCUtil.getOreDictionaryMatchingItemsForInfusion(ingredient), vx, vy));
                ++total;
            }
        }

        protected void setOutput(InfusionRecipe recipe) {
            ItemStack res;
            if (recipe.getRecipeOutput() instanceof ItemStack) {
                res = TCUtil.getAssociatedItemStack(recipe.getRecipeOutput());
            } else {
                res = TCUtil.getAssociatedItemStack(recipe.getRecipeOutput()).func_77946_l();
                Object[] obj = (Object[])recipe.getRecipeOutput();
                NBTBase tag = (NBTBase)obj[1];
                res.func_77983_a((String)obj[0], tag);
            }
            this.result = new PositionedStack((Object)res, 75, 0);
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return;
            }
            super.setIngredientPermutation(ingredients, ingredient);
        }

        public AspectList getAspectList() {
            return this.aspects;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            if (!this.shouldShowRecipe) {
                return Collections.emptyList();
            }
            return this.getCycledIngredients(TCNAInfusionRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return false;
            }
            return super.contains(ingredients, ingredient);
        }

        protected void addAspectsToIngredients(AspectList aspects) {
            int aspectsPerRow = 7;
            int rows = (int)Math.ceil((double)aspects.size() / (double)aspectsPerRow);
            int baseX = 35;
            int baseY = 129;
            int count = 0;
            for (int row = 0; row < rows; ++row) {
                int reversedRow = -row + rows - 1;
                int columns = (aspects.size() + reversedRow) / rows;
                int xOffset = (100 - columns * 20) / 2;
                for (int column = 0; column < columns; ++column) {
                    Aspect aspect = aspects.getAspectsSortedAmount()[count++];
                    int posX = baseX + column * 20 + xOffset;
                    int posY = baseY + row * 20;
                    ItemStack stack = new ItemStack(ModItems.itemAspect, 1, 1);
                    ItemAspect.setAspect((ItemStack)stack, (Aspect)aspect);
                    this.ingredients.add(new PositionedStack((Object)stack, posX, posY, false));
                }
            }
        }
    }
}

