/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FlushableCache<E> {
    private static final List<WeakReference<FlushableCache<?>>> allCaches = new CopyOnWriteArrayList();
    private E cache;

    protected FlushableCache() {
        FlushableCache.register(this);
    }

    private static void cleanStale() {
        allCaches.removeIf(r -> r.get() == null);
    }

    static void register(FlushableCache<?> cache) {
        allCaches.add(new WeakReference(cache));
    }

    public static void enableAll(boolean doCreate) {
        allCaches.stream().map(Reference::get).filter(Objects::nonNull).forEach(flushableCache -> flushableCache.populate(doCreate));
        FlushableCache.cleanStale();
    }

    public static void disableAll() {
        allCaches.stream().map(Reference::get).filter(Objects::nonNull).forEach(FlushableCache::clear);
    }

    protected void populate(boolean doCreate) {
        if (doCreate || this.cache == null) {
            this.cache = this.createCache();
        }
    }

    protected abstract E createCache();

    protected void clear() {
        this.cache = null;
    }

    public boolean isEnabled() {
        return this.cache != null;
    }

    public E getCache() {
        return this.cache;
    }
}

