/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

class FXSonicVisitor
extends ClassVisitor {
    private static final String FIELD_MODEL_DESC = "Lnet/minecraftforge/client/model/IModelCustom;";
    private static final String FIELD_MODEL_NAME = "model";

    public FXSonicVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals(FIELD_MODEL_NAME) && desc.equals(FIELD_MODEL_DESC)) {
            TC4Transformer.log.debug("Making field model static");
            return super.visitField(access | 8, name, desc, signature, value);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new FieldModelScrubberVisitor(this.api, name, desc, super.visitMethod(access, name, desc, signature, exceptions));
    }

    private static class FieldModelScrubberVisitor
    extends MethodVisitor {
        private final String name;
        private final String desc;

        public FieldModelScrubberVisitor(int api, String name, String desc, MethodVisitor mv) {
            super(api, mv);
            this.name = name;
            this.desc = desc;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (owner.equals("thaumcraft/client/fx/other/FXSonic") && name.equals(FXSonicVisitor.FIELD_MODEL_NAME) && desc.equals(FXSonicVisitor.FIELD_MODEL_DESC)) {
                TC4Transformer.log.debug("Replacing opcode {} with {} in method {}{}", new Object[]{opcode, opcode - 2, this.name, this.desc});
                if (opcode == 180) {
                    this.mv.visitInsn(87);
                    super.visitFieldInsn(178, owner, name, desc);
                } else if (opcode == 181) {
                    super.visitFieldInsn(179, owner, name, desc);
                    this.mv.visitInsn(87);
                }
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }
    }
}

