/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.StructureEvent;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.ChatThrottleKey;
import com.gtnewhorizon.structurelib.structure.IBlockPosConsumer;
import com.gtnewhorizon.structurelib.structure.ICustomBlockSetting;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.ISpecialItemBlock;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementChain;
import com.gtnewhorizon.structurelib.structure.IStructureElementCheckOnly;
import com.gtnewhorizon.structurelib.structure.IStructureElementDeferred;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.IStructureNavigate;
import com.gtnewhorizon.structurelib.structure.IStructureWalker;
import com.gtnewhorizon.structurelib.structure.ITierConverter;
import com.gtnewhorizon.structurelib.structure.IWithExtendedContext;
import com.gtnewhorizon.structurelib.structure.LazyStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureElement_Bridge;
import com.gtnewhorizon.structurelib.structure.adders.IBlockAdder;
import com.gtnewhorizon.structurelib.structure.adders.ITileAdder;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class StructureUtility {
    private static final String NICE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz=|!@#$%&()[]{};:<>/?_,.*^'`";
    private static final Map<Vec3Impl, IStructureNavigate> STEP = new HashMap<Vec3Impl, IStructureNavigate>();
    private static final IStructureElement AIR = new StructureElement_Bridge(){

        @Override
        public boolean check(Object t, World world, int x, int y, int z) {
            return world.func_147437_c(x, y, z);
        }

        @Override
        public boolean spawnHint(Object o, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle(world, x, y, z, StructureLibAPI.getBlockHint(), 13);
            return true;
        }

        @Override
        public boolean placeBlock(Object o, World world, int x, int y, int z, ItemStack trigger) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            return false;
        }

        @Override
        @Deprecated
        public IStructureElement.PlaceResult survivalPlaceBlock(Object o, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            if (this.check(o, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            if (!StructureLibAPI.isBlockTriviallyReplaceable(world, x, y, z, env.getActor())) {
                return IStructureElement.PlaceResult.REJECT;
            }
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            return IStructureElement.PlaceResult.ACCEPT;
        }
    };
    private static final IStructureElement NOT_AIR = new StructureElement_Bridge(){

        @Override
        public boolean check(Object t, World world, int x, int y, int z) {
            return !world.func_147437_c(x, y, z);
        }

        @Override
        public boolean spawnHint(Object o, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle(world, x, y, z, StructureLibAPI.getBlockHint(), 14);
            return true;
        }

        @Override
        public boolean placeBlock(Object o, World world, int x, int y, int z, ItemStack trigger) {
            world.func_147465_d(x, y, z, StructureLibAPI.getBlockHint(), 14, 2);
            return true;
        }

        @Override
        public IStructureElement.BlocksToPlace getBlocksToPlace(Object o, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.BlocksToPlace.create(Objects::nonNull);
        }

        @Override
        public IStructureElement.PlaceResult survivalPlaceBlock(Object o, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            if (this.check(o, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            if (env.getSource().takeOne(new ItemStack(Blocks.field_150347_e), false)) {
                world.func_147465_d(x, y, z, Blocks.field_150347_e, 0, 2);
            }
            return IStructureElement.PlaceResult.REJECT;
        }
    };
    private static final IStructureElement ERROR = new StructureElement_Bridge(){

        @Override
        public boolean check(Object t, World world, int x, int y, int z) {
            return false;
        }

        @Override
        public boolean spawnHint(Object o, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle(world, x, y, z, StructureLibAPI.getBlockHint(), 15);
            return true;
        }

        @Override
        public boolean placeBlock(Object o, World world, int x, int y, int z, ItemStack trigger) {
            return true;
        }

        @Override
        public IStructureElement.PlaceResult survivalPlaceBlock(Object o, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.PlaceResult.REJECT;
        }
    };

    private StructureUtility() {
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(Block block, int meta, World world, int x, int y, int z, IItemSource s, EntityPlayerMP actor) {
        return StructureUtility.survivalPlaceBlock(block, meta, world, x, y, z, s, (EntityPlayer)actor);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(Block block, int meta, World world, int x, int y, int z, IItemSource s, EntityPlayer actor) {
        return StructureUtility.survivalPlaceBlock(block, meta, world, x, y, z, s, actor, null);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(Block block, int meta, World world, int x, int y, int z, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
        return StructureUtility.survivalPlaceBlock(block, meta, world, x, y, z, s, (EntityPlayer)actor, chatter);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(Block block, int meta, World world, int x, int y, int z, IItemSource s, EntityPlayer actor, Consumer<IChatComponent> chatter) {
        int itemMeta;
        if (block == null) {
            throw new NullPointerException();
        }
        if (!StructureLibAPI.isBlockTriviallyReplaceable(world, x, y, z, actor)) {
            return IStructureElement.PlaceResult.REJECT;
        }
        Item itemBlock = Item.func_150898_a((Block)block);
        int n = itemMeta = itemBlock instanceof ISpecialItemBlock ? ((ISpecialItemBlock)itemBlock).getItemMetaFromBlockMeta(block, meta) : meta;
        if (!s.takeOne(new ItemStack(itemBlock, 1, itemMeta), false)) {
            if (chatter != null) {
                chatter.accept((IChatComponent)new ChatComponentTranslation("structurelib.autoplace.error.no_simple_block", new Object[]{new ItemStack(itemBlock, 1, itemMeta).func_151000_E()}));
            }
            return IStructureElement.PlaceResult.REJECT;
        }
        if (block instanceof ICustomBlockSetting) {
            ICustomBlockSetting block2 = (ICustomBlockSetting)block;
            block2.setBlock(world, x, y, z, meta);
        } else {
            world.func_147465_d(x, y, z, block, meta, 2);
        }
        return IStructureElement.PlaceResult.ACCEPT;
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(ItemStack stack, ItemStackPredicate.NBTMode nbtMode, NBTTagCompound tag, boolean assumeStackPresent, World world, int x, int y, int z, IItemSource s, EntityPlayerMP actor) {
        return StructureUtility.survivalPlaceBlock(stack, nbtMode, tag, assumeStackPresent, world, x, y, z, s, (EntityPlayer)actor);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(ItemStack stack, ItemStackPredicate.NBTMode nbtMode, NBTTagCompound tag, boolean assumeStackPresent, World world, int x, int y, int z, IItemSource s, EntityPlayer actor) {
        return StructureUtility.survivalPlaceBlock(stack, nbtMode, tag, assumeStackPresent, world, x, y, z, s, actor, null);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(ItemStack stack, ItemStackPredicate.NBTMode nbtMode, NBTTagCompound tag, boolean assumeStackPresent, World world, int x, int y, int z, IItemSource s, EntityPlayerMP actor, @Nullable Consumer<IChatComponent> chatter) {
        return StructureUtility.survivalPlaceBlock(stack, nbtMode, tag, assumeStackPresent, world, x, y, z, s, (EntityPlayer)actor, chatter);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(ItemStack stack, ItemStackPredicate.NBTMode nbtMode, NBTTagCompound tag, boolean assumeStackPresent, World world, int x, int y, int z, IItemSource s, EntityPlayer actor, @Nullable Consumer<IChatComponent> chatter) {
        if (stack == null) {
            throw new NullPointerException();
        }
        if (stack.field_77994_a != 1) {
            throw new IllegalArgumentException();
        }
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            throw new IllegalArgumentException();
        }
        if (!StructureLibAPI.isBlockTriviallyReplaceable(world, x, y, z, actor)) {
            return IStructureElement.PlaceResult.REJECT;
        }
        if (!assumeStackPresent && !s.takeOne(stack, true)) {
            if (chatter != null) {
                chatter.accept((IChatComponent)new ChatComponentTranslation("structurelib.autoplace.error.no_item_stack", new Object[]{stack.func_151000_E()}));
            }
            return IStructureElement.PlaceResult.REJECT;
        }
        if (!stack.func_77946_l().func_77943_a(actor, world, x, y, z, ForgeDirection.UP.ordinal(), 0.5f, 0.5f, 0.5f)) {
            return IStructureElement.PlaceResult.REJECT;
        }
        if (!s.takeOne(stack, false)) {
            world.func_147468_f(x, y, z);
        }
        return IStructureElement.PlaceResult.ACCEPT;
    }

    public static <T> IStructureElement<T> isAir() {
        return AIR;
    }

    public static <T> IStructureElement<T> notAir() {
        return NOT_AIR;
    }

    public static <T> IStructureElement<T> error() {
        return ERROR;
    }

    public static <T> IStructureElementNoPlacement<T> ofHint(int dots) {
        final int meta = dots - 1;
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, StructureLibAPI.getBlockHint(), meta);
                return false;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofHintDeferred(final Supplier<IIcon[]> icons) {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, (IIcon[])icons.get());
                return false;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofHintDeferred(final Supplier<IIcon[]> icons, final short[] RGBa) {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticleTinted(world, x, y, z, (IIcon[])icons.get(), RGBa);
                return false;
            }
        };
    }

    public static <T, TIER> IStructureElementCheckOnly<T> ofBlocksTiered(ITierConverter<TIER> tierExtractor, @Nullable TIER notSet, BiConsumer<T, TIER> setter, Function<T, TIER> getter) {
        if (tierExtractor == null) {
            throw new IllegalArgumentException();
        }
        if (setter == null) {
            throw new IllegalArgumentException();
        }
        if (getter == null) {
            throw new IllegalArgumentException();
        }
        return (t, world, x, y, z) -> {
            int meta;
            Block block = world.func_147439_a(x, y, z);
            Object tier = tierExtractor.convert(block, meta = world.func_72805_g(x, y, z));
            if (tier == null) {
                return false;
            }
            Object current = getter.apply(t);
            if (Objects.equals(notSet, current)) {
                if (Objects.equals(notSet, tier)) {
                    if (StructureLib.PANIC_MODE) {
                        throw new AssertionError((Object)("tierExtractor should never return notSet: " + notSet));
                    }
                    StructureLib.LOGGER.error("#########################################");
                    StructureLib.LOGGER.error("#########################################");
                    StructureLib.LOGGER.error("tierExtractor should never return notSet: {}", new Object[]{notSet, new Throwable()});
                    StructureLib.LOGGER.error("#########################################");
                    StructureLib.LOGGER.error("#########################################");
                }
                setter.accept(t, tier);
                return true;
            }
            return Objects.equals(current, tier);
        };
    }

    public static <T, TIER> IStructureElement<T> ofBlocksTiered(final ITierConverter<TIER> tierExtractor, @Nullable List<Pair<Block, Integer>> allKnownTiers, @Nullable TIER notSet, BiConsumer<T, TIER> setter, Function<T, TIER> getter) {
        List<Object> hints;
        List<Object> list = hints = allKnownTiers == null ? Collections.emptyList() : allKnownTiers;
        if (hints.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException();
        }
        final IStructureElementCheckOnly<T> check = StructureUtility.ofBlocksTiered(tierExtractor, notSet, setter, getter);
        return new StructureElement_Bridge<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return check.check(t, world, x, y, z);
            }

            private Pair<Block, Integer> getHint(ItemStack trigger) {
                return (Pair)hints.get(Math.min(Math.max(trigger.field_77994_a, 1), hints.size()) - 1);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                Pair<Block, Integer> hint = this.getHint(trigger);
                if (hint == null) {
                    return false;
                }
                StructureLibAPI.hintParticle(world, x, y, z, (Block)hint.getKey(), (Integer)hint.getValue());
                return true;
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                Pair<Block, Integer> hint = this.getHint(trigger);
                if (hint == null) {
                    return false;
                }
                if (hint.getKey() instanceof ICustomBlockSetting) {
                    ICustomBlockSetting block = (ICustomBlockSetting)hint.getKey();
                    block.setBlock(world, x, y, z, (Integer)hint.getValue());
                } else {
                    world.func_147465_d(x, y, z, (Block)hint.getKey(), ((Integer)hint.getValue()).intValue(), 2);
                }
                return true;
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                Pair<Block, Integer> hint = this.getHint(trigger);
                return IStructureElement.BlocksToPlace.create((Block)hint.getKey(), (int)((Integer)hint.getValue()));
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                int meta;
                Pair<Block, Integer> hint = this.getHint(trigger);
                if (hint == null) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                Block block = world.func_147439_a(x, y, z);
                Object tier = tierExtractor.convert(block, meta = world.func_72805_g(x, y, z));
                if (Objects.equals(tier, tierExtractor.convert((Block)hint.getKey(), (Integer)hint.getValue()))) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock((Block)hint.getKey(), (int)((Integer)hint.getValue()), world, x, y, z, env.getSource(), env.getActor(), env.getChatter());
            }
        };
    }

    public static <T> IStructureElement<T> ofBlockUnlocalizedName(String modid, String unlocalizedName, int meta) {
        return StructureUtility.ofBlockUnlocalizedName(modid, unlocalizedName, meta, false);
    }

    public static <T> IStructureElement<T> ofBlockUnlocalizedName(final String modid, final String registryName, final int meta, final boolean wildcard) {
        if (StringUtils.isBlank((CharSequence)registryName)) {
            throw new IllegalArgumentException();
        }
        if (meta < 0) {
            throw new IllegalArgumentException();
        }
        if (meta > 15) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isBlank((CharSequence)modid)) {
            throw new IllegalArgumentException();
        }
        return new StructureElement_Bridge<T>(){
            private Block block;

            private Block getBlock() {
                if (this.block == null) {
                    this.block = GameRegistry.findBlock((String)modid, (String)registryName);
                }
                return this.block;
            }

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return world.func_147439_a(x, y, z) == this.getBlock() && (wildcard || world.func_72805_g(x, y, z) == meta);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.getBlock() == null) {
                    return StructureUtility.error().spawnHint(t, world, x, y, z, trigger);
                }
                StructureLibAPI.hintParticle(world, x, y, z, this.getBlock(), meta);
                return true;
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.getBlock() == null) {
                    return StructureUtility.error().placeBlock(t, world, x, y, z, trigger);
                }
                world.func_147465_d(x, y, z, this.getBlock(), meta, 2);
                return true;
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.getBlock() == null) {
                    return StructureUtility.error().getBlocksToPlace(t, world, x, y, z, trigger, env);
                }
                return IStructureElement.BlocksToPlace.create(this.getBlock(), meta);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(t, world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                if (this.getBlock() == null) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                return StructureUtility.survivalPlaceBlock(this.getBlock(), meta, world, x, y, z, env.getSource(), env.getActor(), env.getChatter());
            }
        };
    }

    public static <T> IStructureElement<T> ofBlockUnlocalizedName(final String modid, final String unlocalizedName, final int meta, final IStructureElement<T> fallback) {
        if (StringUtils.isBlank((CharSequence)unlocalizedName)) {
            throw new IllegalArgumentException();
        }
        if (meta < 0) {
            throw new IllegalArgumentException();
        }
        if (meta > 15) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isBlank((CharSequence)modid)) {
            throw new IllegalArgumentException();
        }
        if (fallback == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){
            private Block block;
            private boolean initialized;

            private boolean init() {
                if (!this.initialized) {
                    this.block = GameRegistry.findBlock((String)modid, (String)unlocalizedName);
                    this.initialized = true;
                }
                return this.block != null;
            }

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                if (this.init()) {
                    return world.func_147439_a(x, y, z) != this.block && world.func_72805_g(x, y, z) == meta;
                }
                return fallback.check(t, world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.init()) {
                    StructureLibAPI.hintParticle(world, x, y, z, this.block, meta);
                    return true;
                }
                return fallback.spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.init()) {
                    world.func_147465_d(x, y, z, this.block, meta, 2);
                    return true;
                }
                return fallback.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.init()) {
                    return IStructureElement.BlocksToPlace.create(this.block, meta);
                }
                return fallback.getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                if (this.check(t, world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                if (this.init()) {
                    return StructureUtility.survivalPlaceBlock(this.block, meta, world, x, y, z, s, actor, chatter);
                }
                return fallback.survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(t, world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                if (this.init()) {
                    return StructureUtility.survivalPlaceBlock(this.block, meta, world, x, y, z, env.getSource(), env.getActor(), env.getChatter());
                }
                return fallback.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofBlocksFlatHint(final Map<Block, Integer> blocsMap, final Block hintBlock, final int hintMeta) {
        if (blocsMap == null || blocsMap.isEmpty() || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                Block worldBlock = world.func_147439_a(x, y, z);
                return blocsMap.getOrDefault(worldBlock, Integer.MIN_VALUE).intValue() == worldBlock.func_149643_k(world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofBlocksMapHint(final Map<Block, Collection<Integer>> blocsMap, final Block hintBlock, final int hintMeta) {
        if (blocsMap == null || blocsMap.isEmpty() || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        for (Collection<Integer> value : blocsMap.values()) {
            if (!value.isEmpty()) continue;
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                Block worldBlock = world.func_147439_a(x, y, z);
                return ((Collection)blocsMap.getOrDefault(worldBlock, Collections.emptySet())).contains(worldBlock.func_149643_k(world, x, y, z));
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofBlockHint(final Block block, final int meta, final Block hintBlock, final int hintMeta) {
        if (block == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                Block worldBlock = world.func_147439_a(x, y, z);
                return block == worldBlock && meta == worldBlock.func_149643_k(world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofBlockHint(Block block, int meta) {
        return StructureUtility.ofBlockHint(block, meta, block, meta);
    }

    public static <T> IStructureElementNoPlacement<T> ofBlockAdderHint(final IBlockAdder<T> iBlockAdder, final Block hintBlock, final int hintMeta) {
        if (iBlockAdder == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                Block worldBlock = world.func_147439_a(x, y, z);
                return iBlockAdder.apply(t, worldBlock, worldBlock.func_149643_k(world, x, y, z));
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlocksFlat(final Map<Block, Integer> blocsMap, final Block defaultBlock, final int defaultMeta) {
        if (blocsMap == null || blocsMap.isEmpty() || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        if (defaultBlock instanceof ICustomBlockSetting) {
            return new IStructureElement<T>(){
                private IStructureElement.BlocksToPlace blocksToPlace;

                @Override
                public boolean check(T t, World world, int x, int y, int z) {
                    Block worldBlock = world.func_147439_a(x, y, z);
                    return blocsMap.getOrDefault(worldBlock, Integer.MIN_VALUE).intValue() == worldBlock.func_149643_k(world, x, y, z);
                }

                @Override
                public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                    ((ICustomBlockSetting)defaultBlock).setBlock(world, x, y, z, defaultMeta);
                    return true;
                }

                @Override
                public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                    StructureLibAPI.hintParticle(world, x, y, z, defaultBlock, defaultMeta);
                    return true;
                }

                @Override
                @Nullable
                public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                    if (this.blocksToPlace == null) {
                        ImmutableList.Builder blocks = ImmutableList.builder();
                        Predicate<ItemStack> predicate = s -> true;
                        for (Map.Entry e : blocsMap.entrySet()) {
                            Item i = Item.func_150898_a((Block)((Block)e.getKey()));
                            int meta = (Integer)e.getValue();
                            if (i instanceof ISpecialItemBlock) {
                                meta = ((ISpecialItemBlock)i).getItemMetaFromBlockMeta((Block)e.getKey(), meta);
                            }
                            ItemStack stack = new ItemStack(i, 1, meta);
                            blocks.add((Object)stack);
                            predicate = predicate.and(ItemStackPredicate.from(stack));
                        }
                        this.blocksToPlace = new IStructureElement.BlocksToPlace(predicate, (Iterable<ItemStack>)blocks.build());
                    }
                    return this.blocksToPlace;
                }
            };
        }
        return new IStructureElement<T>(){
            private IStructureElement.BlocksToPlace blocksToPlace;

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                Block worldBlock = world.func_147439_a(x, y, z);
                return blocsMap.getOrDefault(worldBlock, Integer.MIN_VALUE).intValue() == worldBlock.func_149643_k(world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, defaultBlock, defaultMeta, 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, defaultBlock, defaultMeta);
                return true;
            }

            @Override
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.blocksToPlace == null) {
                    ImmutableList.Builder blocks = ImmutableList.builder();
                    Predicate<ItemStack> predicate = s -> true;
                    for (Map.Entry e : blocsMap.entrySet()) {
                        Item i = Item.func_150898_a((Block)((Block)e.getKey()));
                        int meta = (Integer)e.getValue();
                        if (i instanceof ISpecialItemBlock) {
                            meta = ((ISpecialItemBlock)i).getItemMetaFromBlockMeta((Block)e.getKey(), meta);
                        }
                        ItemStack stack = new ItemStack(i, 1, meta);
                        blocks.add((Object)stack);
                        predicate = predicate.and(ItemStackPredicate.from(stack));
                    }
                    this.blocksToPlace = new IStructureElement.BlocksToPlace(predicate, (Iterable<ItemStack>)blocks.build());
                }
                return this.blocksToPlace;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlocksMap(final Map<Block, Collection<Integer>> blocsMap, final Block defaultBlock, final int defaultMeta) {
        if (blocsMap == null || blocsMap.isEmpty() || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        for (Collection<Integer> value : blocsMap.values()) {
            if (!value.isEmpty()) continue;
            throw new IllegalArgumentException();
        }
        if (defaultBlock instanceof ICustomBlockSetting) {
            return new IStructureElement<T>(){
                private IStructureElement.BlocksToPlace blocksToPlace;

                @Override
                public boolean check(T t, World world, int x, int y, int z) {
                    Block worldBlock = world.func_147439_a(x, y, z);
                    return ((Collection)blocsMap.getOrDefault(worldBlock, Collections.emptySet())).contains(worldBlock.func_149643_k(world, x, y, z));
                }

                @Override
                public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                    ((ICustomBlockSetting)defaultBlock).setBlock(world, x, y, z, defaultMeta);
                    return true;
                }

                @Override
                public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                    StructureLibAPI.hintParticle(world, x, y, z, defaultBlock, defaultMeta);
                    return true;
                }

                @Override
                public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                    if (this.blocksToPlace == null) {
                        ImmutableList.Builder blocks = ImmutableList.builder();
                        Predicate<ItemStack> predicate = s -> true;
                        for (Map.Entry e : blocsMap.entrySet()) {
                            Item i = Item.func_150898_a((Block)((Block)e.getKey()));
                            Iterator iterator = ((Collection)e.getValue()).iterator();
                            while (iterator.hasNext()) {
                                int meta = (Integer)iterator.next();
                                if (i instanceof ISpecialItemBlock) {
                                    meta = ((ISpecialItemBlock)i).getItemMetaFromBlockMeta((Block)e.getKey(), meta);
                                }
                                ItemStack stack = new ItemStack(i, 1, meta);
                                blocks.add((Object)stack);
                                predicate = predicate.and(ItemStackPredicate.from(stack));
                            }
                        }
                        this.blocksToPlace = new IStructureElement.BlocksToPlace(predicate, (Iterable<ItemStack>)blocks.build());
                    }
                    return this.blocksToPlace;
                }
            };
        }
        return new IStructureElement<T>(){
            private IStructureElement.BlocksToPlace blocksToPlace;

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                Block worldBlock = world.func_147439_a(x, y, z);
                return ((Collection)blocsMap.getOrDefault(worldBlock, Collections.emptySet())).contains(worldBlock.func_149643_k(world, x, y, z));
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, defaultBlock, defaultMeta, 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, defaultBlock, defaultMeta);
                return true;
            }

            @Override
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.blocksToPlace == null) {
                    ImmutableList.Builder blocks = ImmutableList.builder();
                    Predicate<ItemStack> predicate = s -> true;
                    for (Map.Entry e : blocsMap.entrySet()) {
                        Item i = Item.func_150898_a((Block)((Block)e.getKey()));
                        Iterator iterator = ((Collection)e.getValue()).iterator();
                        while (iterator.hasNext()) {
                            int meta = (Integer)iterator.next();
                            if (i instanceof ISpecialItemBlock) {
                                meta = ((ISpecialItemBlock)i).getItemMetaFromBlockMeta((Block)e.getKey(), meta);
                            }
                            ItemStack stack = new ItemStack(i, 1, meta);
                            blocks.add((Object)stack);
                            predicate = predicate.and(ItemStackPredicate.from(stack));
                        }
                    }
                    this.blocksToPlace = new IStructureElement.BlocksToPlace(predicate, (Iterable<ItemStack>)blocks.build());
                }
                return this.blocksToPlace;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlock(final Block block, final int meta, final Block defaultBlock, final int defaultMeta) {
        if (block == null || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        if (block instanceof ICustomBlockSetting) {
            return new IStructureElement<T>(){

                @Override
                public boolean check(T t, World world, int x, int y, int z) {
                    Block worldBlock = world.func_147439_a(x, y, z);
                    return block == worldBlock && meta == worldBlock.func_149643_k(world, x, y, z);
                }

                @Override
                public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                    ((ICustomBlockSetting)defaultBlock).setBlock(world, x, y, z, defaultMeta);
                    return true;
                }

                @Override
                public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                    StructureLibAPI.hintParticle(world, x, y, z, defaultBlock, defaultMeta);
                    return true;
                }

                @Override
                public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                    return IStructureElement.BlocksToPlace.create(block, meta);
                }
            };
        }
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                Block worldBlock = world.func_147439_a(x, y, z);
                return block == worldBlock && meta == worldBlock.func_149643_k(world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, defaultBlock, defaultMeta, 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, defaultBlock, defaultMeta);
                return true;
            }

            @Override
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create(block, meta);
            }
        };
    }

    public static <T> IStructureElement<T> ofBlockAnyMeta(final Block block, final Block defaultBlock, final int defaultMeta) {
        if (block == null || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        if (block instanceof ICustomBlockSetting) {
            return new IStructureElement<T>(){

                @Override
                public boolean check(T t, World world, int x, int y, int z) {
                    return block == world.func_147439_a(x, y, z);
                }

                @Override
                public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                    ((ICustomBlockSetting)defaultBlock).setBlock(world, x, y, z, defaultMeta);
                    return true;
                }

                @Override
                public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                    StructureLibAPI.hintParticle(world, x, y, z, defaultBlock, defaultMeta);
                    return true;
                }

                @Override
                public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                    return IStructureElement.BlocksToPlace.create(defaultBlock, defaultMeta);
                }
            };
        }
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return block == world.func_147439_a(x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, defaultBlock, defaultMeta, 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, defaultBlock, defaultMeta);
                return true;
            }

            @Override
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create(defaultBlock, defaultMeta);
            }
        };
    }

    public static <T> IStructureElement<T> ofBlock(Block block, int meta) {
        return StructureUtility.ofBlock(block, meta, block, meta);
    }

    public static <T> IStructureElement<T> ofBlockAnyMeta(Block block) {
        return StructureUtility.ofBlockAnyMeta(block, block, 0);
    }

    public static <T> IStructureElement<T> ofBlockAnyMeta(Block block, int defaultMeta) {
        return StructureUtility.ofBlockAnyMeta(block, block, defaultMeta);
    }

    public static <T> IStructureElement<T> ofBlockAdder(final IBlockAdder<T> iBlockAdder, final Block defaultBlock, final int defaultMeta) {
        if (iBlockAdder == null || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        if (defaultBlock instanceof ICustomBlockSetting) {
            return new StructureElement_Bridge<T>(){

                @Override
                public boolean check(T t, World world, int x, int y, int z) {
                    Block worldBlock = world.func_147439_a(x, y, z);
                    return iBlockAdder.apply(t, worldBlock, worldBlock.func_149643_k(world, x, y, z));
                }

                @Override
                public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                    ((ICustomBlockSetting)defaultBlock).setBlock(world, x, y, z, defaultMeta);
                    return true;
                }

                @Override
                public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                    StructureLibAPI.hintParticle(world, x, y, z, defaultBlock, defaultMeta);
                    return true;
                }

                @Override
                @Deprecated
                public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                    if (world.func_147439_a(x, y, z) == defaultBlock && world.func_72805_g(x, y, z) == defaultMeta) {
                        return IStructureElement.PlaceResult.SKIP;
                    }
                    return StructureUtility.survivalPlaceBlock(defaultBlock, defaultMeta, world, x, y, z, env.getSource(), env.getActor(), env.getChatter());
                }
            };
        }
        return new StructureElement_Bridge<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                Block worldBlock = world.func_147439_a(x, y, z);
                return iBlockAdder.apply(t, worldBlock, worldBlock.func_149643_k(world, x, y, z));
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, defaultBlock, defaultMeta, 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, defaultBlock, defaultMeta);
                return true;
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (world.func_147439_a(x, y, z) == defaultBlock && world.func_72805_g(x, y, z) == defaultMeta) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock(defaultBlock, defaultMeta, world, x, y, z, env.getSource(), env.getActor(), env.getChatter());
            }
        };
    }

    public static <T> IStructureElement<T> ofBlockAdder(IBlockAdder<T> iBlockAdder, int dots) {
        return StructureUtility.ofBlockAdder(iBlockAdder, StructureLibAPI.getBlockHint(), dots - 1);
    }

    public static <T> IStructureElementNoPlacement<T> ofTileAdder(final ITileAdder<T> iTileAdder, final Block hintBlock, final int hintMeta) {
        if (iTileAdder == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return iTileAdder.apply(t, tileEntity);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <T, E> IStructureElementNoPlacement<T> ofSpecificTileAdder(final BiPredicate<T, E> iTileAdder, final Class<E> tileClass, final Block hintBlock, final int hintMeta) {
        if (iTileAdder == null || hintBlock == null || tileClass == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return tileClass.isInstance(tileEntity) && iTileAdder.test(t, tileClass.cast(tileEntity));
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hintBlock, hintMeta);
                return true;
            }
        };
    }

    public static <B extends IStructureElement<T>, T> IStructureElement<T> onElementPass(final Consumer<T> onCheckPass, final B element) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                boolean check = element.check(t, world, x, y, z);
                if (check) {
                    onCheckPass.accept(t);
                }
                return check;
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return element.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return element.spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return element.getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return element.survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return element.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static <B extends IStructureElement<T>, T> IStructureElement<T> onElementFail(final Consumer<T> onFail, final B element) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                boolean check = element.check(t, world, x, y, z);
                if (!check) {
                    onFail.accept(t);
                }
                return check;
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return element.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return element.spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return element.getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return element.survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return element.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static <T> IStructureElement<T> onlyIf(Predicate<? super T> predicate, IStructureElement<? super T> downstream) {
        return StructureUtility.onlyIf(predicate, downstream, IStructureElement.PlaceResult.SKIP);
    }

    public static <T> IStructureElement<T> onlyIf(final Predicate<? super T> predicate, final IStructureElement<? super T> downstream, final IStructureElement.PlaceResult placeResultWhenDisabled) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return predicate.test(t) && downstream.check(t, world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return predicate.test(t) && downstream.spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return predicate.test(t) && downstream.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (predicate.test(t)) {
                    return downstream.getBlocksToPlace(t, world, x, y, z, trigger, env);
                }
                return IStructureElement.BlocksToPlace.createEmpty();
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                if (predicate.test(t)) {
                    return downstream.survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
                }
                return placeResultWhenDisabled;
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (predicate.test(t)) {
                    return downstream.survivalPlaceBlock(t, world, x, y, z, trigger, env);
                }
                return placeResultWhenDisabled;
            }
        };
    }

    @SafeVarargs
    public static <T> IStructureElementChain<T> ofChain(IStructureElement<T> ... elementChain) {
        if (elementChain == null || elementChain.length == 0) {
            throw new IllegalArgumentException();
        }
        for (IStructureElement<T> iStructureElement : elementChain) {
            if (iStructureElement != null) continue;
            throw new IllegalArgumentException();
        }
        return () -> elementChain;
    }

    public static <T> IStructureElementChain<T> ofChain(List<IStructureElement<T>> elementChain) {
        return StructureUtility.ofChain(elementChain.toArray(new IStructureElement[0]));
    }

    public static <CTX, T extends IWithExtendedContext<CTX>> IStructureElement<T> withContext(final IStructureElement<CTX> elem) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return elem.check(t.getCurrentContext(), world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return elem.spawnHint(t.getCurrentContext(), world, x, y, z, trigger);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return elem.placeBlock(t.getCurrentContext(), world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return elem.getBlocksToPlace(t.getCurrentContext(), world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return elem.survivalPlaceBlock(t.getCurrentContext(), world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return elem.survivalPlaceBlock(t.getCurrentContext(), world, x, y, z, trigger, env);
            }
        };
    }

    public static <T> IStructureElementDeferred<T> lazy(Supplier<IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new LazyStructureElement<Object>(t -> (IStructureElement)to.get());
    }

    public static <T> IStructureElementDeferred<T> lazy(Function<T, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new LazyStructureElement<T>(to);
    }

    public static <T> IStructureElementDeferred<T> defer(final Supplier<IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)to.get()).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.get()).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.get()).spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.get()).getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return ((IStructureElement)to.get()).survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.get()).survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static <T> IStructureElementDeferred<T> defer(final Function<T, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)to.apply(t)).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t)).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t)).spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.apply(t)).getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return ((IStructureElement)to.apply(t)).survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.apply(t)).survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    @Deprecated
    public static <T, K> IStructureElementDeferred<T> defer(Function<T, K> keyExtractor, Map<K, IStructureElement<T>> map) {
        return StructureUtility.partitionBy(keyExtractor, map);
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(Function<T, K> keyExtractor, Map<K, IStructureElement<T>> map) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(map::get));
    }

    @Deprecated
    public static <T, K> IStructureElementDeferred<T> defer(Function<T, K> keyExtractor, Map<K, IStructureElement<T>> map, IStructureElement<T> defaultElem) {
        return StructureUtility.partitionBy(keyExtractor, map, defaultElem);
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(Function<T, K> keyExtractor, Map<K, IStructureElement<T>> map, IStructureElement<T> defaultElem) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(key -> map.getOrDefault(key, defaultElem)));
    }

    @SafeVarargs
    @Deprecated
    public static <T> IStructureElementDeferred<T> defer(Function<T, Integer> keyExtractor, IStructureElement<T> ... array) {
        return StructureUtility.partitionBy(keyExtractor, array);
    }

    @SafeVarargs
    public static <T> IStructureElementDeferred<T> partitionBy(Function<T, Integer> keyExtractor, IStructureElement<T> ... array) {
        if (keyExtractor == null || array == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(i -> array[i]));
    }

    @Deprecated
    public static <T> IStructureElementDeferred<T> defer(Function<T, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.partitionBy(keyExtractor, array);
    }

    public static <T> IStructureElementDeferred<T> partitionBy(Function<T, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.partitionBy(keyExtractor, array.toArray(new IStructureElement[0]));
    }

    public static <T> IStructureElementDeferred<T> defer(final BiFunction<T, ItemStack, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)to.apply(t, null)).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.apply(t, trigger)).getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return ((IStructureElement)to.apply(t, trigger)).survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.apply(t, trigger)).survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    @Deprecated
    public static <T, K> IStructureElementDeferred<T> defer(BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map) {
        return StructureUtility.partitionBy(keyExtractor, map);
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(map::get));
    }

    @Deprecated
    public static <T, K> IStructureElementDeferred<T> defer(BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map, IStructureElement<T> defaultElem) {
        return StructureUtility.partitionBy(keyExtractor, map, defaultElem);
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map, IStructureElement<T> defaultElem) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(key -> map.getOrDefault(key, defaultElem)));
    }

    @SafeVarargs
    public static <T> IStructureElementDeferred<T> defer(BiFunction<T, ItemStack, Integer> keyExtractor, IStructureElement<T> ... array) {
        if (keyExtractor == null || array == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(i -> array[i]));
    }

    public static <T> IStructureElementDeferred<T> defer(BiFunction<T, ItemStack, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.defer(keyExtractor.andThen(array::get));
    }

    public static <T> IStructureElementDeferred<T> defer(final Function<T, IStructureElement<T>> toCheck, final BiFunction<T, ItemStack, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return ((IStructureElement)toCheck.apply(t)).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return ((IStructureElement)to.apply(t, trigger)).survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.apply(t, trigger)).survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    @Deprecated
    public static <T, K> IStructureElementDeferred<T> defer(Function<T, K> keyExtractorCheck, BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map) {
        return StructureUtility.partitionBy(keyExtractorCheck, keyExtractor, map);
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(Function<T, K> keyExtractorCheck, BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractorCheck.andThen(map::get), keyExtractor.andThen(map::get));
    }

    @Deprecated
    public static <T, K> IStructureElementDeferred<T> defer(Function<T, K> keyExtractorCheck, BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map, IStructureElement<T> defaultElem) {
        return StructureUtility.partitionBy(keyExtractorCheck, keyExtractor, map, defaultElem);
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(Function<T, K> keyExtractorCheck, BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map, IStructureElement<T> defaultElem) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractorCheck.andThen(k -> map.getOrDefault(k, defaultElem)), keyExtractor.andThen(k -> map.getOrDefault(k, defaultElem)));
    }

    @SafeVarargs
    @Deprecated
    public static <T> IStructureElementDeferred<T> defer(Function<T, Integer> keyExtractorCheck, BiFunction<T, ItemStack, Integer> keyExtractor, IStructureElement<T> ... array) {
        return StructureUtility.partitionBy(keyExtractorCheck, keyExtractor, array);
    }

    @SafeVarargs
    public static <T> IStructureElementDeferred<T> partitionBy(Function<T, Integer> keyExtractorCheck, BiFunction<T, ItemStack, Integer> keyExtractor, IStructureElement<T> ... array) {
        if (keyExtractor == null || array == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractorCheck.andThen(i -> array[i]), keyExtractor.andThen(i -> array[i]));
    }

    @Deprecated
    public static <T> IStructureElementDeferred<T> defer(Function<T, Integer> keyExtractorCheck, BiFunction<T, ItemStack, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.partitionBy(keyExtractorCheck, keyExtractor, array);
    }

    public static <T> IStructureElementDeferred<T> partitionBy(Function<T, Integer> keyExtractorCheck, BiFunction<T, ItemStack, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.partitionBy(keyExtractorCheck, keyExtractor, array.toArray(new IStructureElement[0]));
    }

    public static <T> IStructureElement<T> withChannel(final String channel, final IStructureElement<T> backing) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return backing.check(t, world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                ItemStack newTrigger = ChannelDataAccessor.withChannel(trigger, channel);
                if (newTrigger == trigger && StructureLib.getCurrentPlayer() != null) {
                    this.warnNoExplicitSubChannel(StructureLib.getCurrentPlayer());
                }
                return backing.spawnHint(t, world, x, y, z, newTrigger);
            }

            private void warnNoExplicitSubChannel(EntityPlayer currentPlayer) {
                StructureLibAPI.addThrottledChat(new ChatThrottleKey.NoExplicitChannel(channel), currentPlayer, (IChatComponent)new ChatComponentTranslation("structurelib.autoplace.warning.no_explicit_channel", new Object[]{channel}), (short)100);
            }

            @Override
            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return backing.placeBlock(t, world, x, y, z, ChannelDataAccessor.withChannel(trigger, channel));
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return backing.getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                ItemStack newTrigger = ChannelDataAccessor.withChannel(trigger, channel);
                if (newTrigger == trigger) {
                    this.warnNoExplicitSubChannel((EntityPlayer)actor);
                }
                return backing.survivalPlaceBlock(t, world, x, y, z, newTrigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                ItemStack newTrigger = ChannelDataAccessor.withChannel(trigger, channel);
                if (newTrigger == trigger) {
                    this.warnNoExplicitSubChannel(env.getActor());
                }
                return backing.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static <T> IStructureNavigate<T> step(int a, int b, int c) {
        return StructureUtility.step(new Vec3Impl(a, b, c));
    }

    public static <T> IStructureNavigate<T> step(Vec3Impl step) {
        if (step == null || step.get0() < 0 || step.get1() < 0 || step.get2() < 0) {
            throw new IllegalArgumentException();
        }
        return STEP.computeIfAbsent(step, vec3 -> {
            if (vec3.get2() > 0) {
                return StructureUtility.stepC(vec3.get0(), vec3.get1(), vec3.get2());
            }
            if (vec3.get1() > 0) {
                return StructureUtility.stepB(vec3.get0(), vec3.get1(), vec3.get2());
            }
            return StructureUtility.stepA(vec3.get0(), vec3.get1(), vec3.get2());
        });
    }

    private static <T> IStructureNavigate<T> stepA(final int a, final int b, final int c) {
        return new IStructureNavigate<T>(){

            @Override
            public int getStepA() {
                return a;
            }

            @Override
            public int getStepB() {
                return b;
            }

            @Override
            public int getStepC() {
                return c;
            }
        };
    }

    private static <T> IStructureNavigate<T> stepB(final int a, final int b, final int c) {
        return new IStructureNavigate<T>(){

            @Override
            public int getStepA() {
                return a;
            }

            @Override
            public int getStepB() {
                return b;
            }

            @Override
            public int getStepC() {
                return c;
            }

            @Override
            public boolean resetA() {
                return true;
            }
        };
    }

    private static <T> IStructureNavigate<T> stepC(final int a, final int b, final int c) {
        return new IStructureNavigate<T>(){

            @Override
            public int getStepA() {
                return a;
            }

            @Override
            public int getStepB() {
                return b;
            }

            @Override
            public int getStepC() {
                return c;
            }

            @Override
            public boolean resetA() {
                return true;
            }

            @Override
            public boolean resetB() {
                return true;
            }
        };
    }

    public static String getPseudoJavaCode(World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, Function<? super TileEntity, String> tileEntityClassifier, int sizeA, int sizeB, int sizeC, boolean transpose) {
        char c;
        TreeMap blocks = new TreeMap(Comparator.comparing(Block::func_149739_a));
        HashSet tiles = new HashSet();
        HashSet specialTiles = new HashSet();
        StructureUtility.iterate(world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, sizeA, sizeB, sizeC, (w, x, y, z) -> {
            TileEntity tileEntity = w.func_147438_o(x, y, z);
            if (tileEntity == null) {
                Block block = w.func_147439_a(x, y, z);
                if (block != null && block != Blocks.field_150350_a) {
                    blocks.compute(block, (b, set) -> {
                        if (set == null) {
                            set = new TreeSet<Integer>();
                        }
                        set.add(block.func_149643_k(world, x, y, z));
                        return set;
                    });
                }
            } else {
                String classification = (String)tileEntityClassifier.apply(tileEntity);
                if (classification == null) {
                    tiles.add(tileEntity.getClass());
                } else {
                    specialTiles.add(classification);
                }
            }
        });
        HashMap<Object, Character> map = new HashMap<Object, Character>();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        builder.append("\n\nStructure:\n").append("\nBlocks:\n");
        for (Map.Entry entry : blocks.entrySet()) {
            Block block = (Block)entry.getKey();
            Set set = (Set)entry.getValue();
            for (Integer meta : set) {
                c = NICE_CHARS.charAt(i++);
                if (i > NICE_CHARS.length()) {
                    return "Too complicated for nice chars";
                }
                map.put(block.func_149739_a() + '\u0000' + meta, Character.valueOf(c));
                builder.append(c).append(" -> ofBlock...(").append(block.func_149739_a()).append(", ").append(meta).append(", ...);\n");
            }
        }
        builder.append("\nTiles:\n");
        for (Object tile : tiles) {
            c = NICE_CHARS.charAt(i++);
            if (i > NICE_CHARS.length()) {
                return "Too complicated for nice chars";
            }
            map.put(((Class)tile).getCanonicalName(), Character.valueOf(c));
            builder.append(c).append(" -> ofTileAdder(").append(tile).append(", ...);\n");
        }
        builder.append("\nSpecial Tiles:\n");
        for (Object tile : specialTiles) {
            c = NICE_CHARS.charAt(i++);
            if (i > NICE_CHARS.length()) {
                return "Too complicated for nice chars";
            }
            map.put(tile, Character.valueOf(c));
            builder.append(c).append(" -> ofSpecialTileAdder(").append((String)tile).append(", ...); // You will probably want to change it to something else\n");
        }
        builder.append("\nOffsets:\n").append(basePositionA).append(' ').append(basePositionB).append(' ').append(basePositionC).append('\n');
        if (transpose) {
            builder.append("\nTransposed Scan:\n").append("new String[][]{\n").append("    {\"");
            StructureUtility.iterate(world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, true, sizeA, sizeB, sizeC, (w, x, y, z) -> {
                TileEntity tileEntity = w.func_147438_o(x, y, z);
                if (tileEntity == null) {
                    Block block = w.func_147439_a(x, y, z);
                    if (block != null && block != Blocks.field_150350_a) {
                        builder.append(map.get(block.func_149739_a() + '\u0000' + block.func_149643_k(world, x, y, z)));
                    } else {
                        builder.append(' ');
                    }
                } else {
                    String classification = (String)tileEntityClassifier.apply(tileEntity);
                    if (classification == null) {
                        classification = tileEntity.getClass().getCanonicalName();
                    }
                    builder.append(map.get(classification));
                }
            }, () -> builder.append("\",\""), () -> {
                builder.setLength(builder.length() - 2);
                builder.append("},\n    {\"");
            });
            builder.setLength(builder.length() - 8);
            builder.append("\n}\n\n");
        } else {
            builder.append("\nNormal Scan:\n").append("new String[][]{{\n").append("    \"");
            StructureUtility.iterate(world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, false, sizeA, sizeB, sizeC, (w, x, y, z) -> {
                TileEntity tileEntity = w.func_147438_o(x, y, z);
                if (tileEntity == null) {
                    Block block = w.func_147439_a(x, y, z);
                    if (block != null && block != Blocks.field_150350_a) {
                        builder.append(map.get(block.func_149739_a() + '\u0000' + block.func_149643_k(world, x, y, z)));
                    } else {
                        builder.append(' ');
                    }
                } else {
                    String classification = (String)tileEntityClassifier.apply(tileEntity);
                    if (classification == null) {
                        classification = tileEntity.getClass().getCanonicalName();
                    }
                    builder.append(map.get(classification));
                }
            }, () -> builder.append("\",\n").append("    \""), () -> {
                builder.setLength(builder.length() - 7);
                builder.append("\n").append("},{\n").append("    \"");
            });
            builder.setLength(builder.length() - 8);
            builder.append("}\n\n");
        }
        return builder.toString().replaceAll("\"\"", "E");
    }

    static <T> boolean iterateV2(IStructureElement<T>[] elements, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, IStructureWalker<T> predicate, String iterateType) {
        basePositionA = -basePositionA;
        basePositionB = -basePositionB;
        basePositionC = -basePositionC;
        int[] abc = new int[]{basePositionA, basePositionB, basePositionC};
        int[] xyz = new int[3];
        for (IStructureElement<T> element : elements) {
            if (element.isNavigating()) {
                abc[0] = (element.resetA() ? basePositionA : abc[0]) + element.getStepA();
                abc[1] = (element.resetB() ? basePositionB : abc[1]) + element.getStepB();
                abc[2] = (element.resetC() ? basePositionC : abc[2]) + element.getStepC();
                continue;
            }
            extendedFacing.getWorldOffset(abc, xyz);
            xyz[0] = xyz[0] + basePositionX;
            xyz[1] = xyz[1] + basePositionY;
            xyz[2] = xyz[2] + basePositionZ;
            if (StructureLibAPI.isDebugEnabled()) {
                StructureLib.LOGGER.info("Multi [{}, {}, {}] {} step @ {} {}", new Object[]{basePositionX, basePositionY, basePositionZ, iterateType, Arrays.toString(xyz), Arrays.toString(abc)});
            }
            if (world.func_72899_e(xyz[0], xyz[1], xyz[2])) {
                if (StructureLibAPI.isInstrumentEnabled()) {
                    StructureEvent.StructureElementVisitedEvent.fireEvent(world, xyz[0], xyz[1], xyz[2], abc[0] - basePositionA, abc[1] - basePositionB, abc[2] - basePositionC, element);
                }
                if (!predicate.visit(element, world, xyz[0], xyz[1], xyz[2], abc[0], abc[1], abc[2])) {
                    if (StructureLibAPI.isDebugEnabled()) {
                        StructureLib.LOGGER.info("Multi [{}, {}, {}] {} stop @ {} {}", new Object[]{basePositionX, basePositionY, basePositionZ, iterateType, Arrays.toString(xyz), Arrays.toString(abc)});
                    }
                    return false;
                }
            } else {
                if (StructureLibAPI.isDebugEnabled()) {
                    StructureLib.LOGGER.info("Multi [{}, {}, {}] {} !blockExists @ {} {}", new Object[]{basePositionX, basePositionY, basePositionZ, iterateType, Arrays.toString(xyz), Arrays.toString(abc)});
                }
                if (!predicate.blockNotLoaded(element, world, xyz[0], xyz[1], xyz[2], abc[0], abc[1], abc[2])) {
                    return false;
                }
            }
            abc[0] = abc[0] + 1;
        }
        return true;
    }

    public static void iterate(World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, int sizeA, int sizeB, int sizeC, IBlockPosConsumer iBlockPosConsumer) {
        sizeA -= basePositionA;
        sizeB -= basePositionB;
        sizeC -= basePositionC;
        int[] abc = new int[3];
        int[] xyz = new int[3];
        abc[2] = -basePositionC;
        while (abc[2] < sizeC) {
            abc[1] = -basePositionB;
            while (abc[1] < sizeB) {
                abc[0] = -basePositionA;
                while (abc[0] < sizeA) {
                    extendedFacing.getWorldOffset(abc, xyz);
                    iBlockPosConsumer.consume(world, xyz[0] + basePositionX, xyz[1] + basePositionY, xyz[2] + basePositionZ);
                    abc[0] = abc[0] + 1;
                }
                abc[1] = abc[1] + 1;
            }
            abc[2] = abc[2] + 1;
        }
    }

    public static void iterate(World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean transpose, int sizeA, int sizeB, int sizeC, IBlockPosConsumer iBlockPosConsumer, Runnable nextB, Runnable nextC) {
        sizeA -= basePositionA;
        sizeB -= basePositionB;
        sizeC -= basePositionC;
        int[] abc = new int[3];
        int[] xyz = new int[3];
        if (transpose) {
            abc[1] = -basePositionB;
            while (abc[1] < sizeB) {
                abc[2] = -basePositionC;
                while (abc[2] < sizeC) {
                    abc[0] = -basePositionA;
                    while (abc[0] < sizeA) {
                        extendedFacing.getWorldOffset(abc, xyz);
                        iBlockPosConsumer.consume(world, xyz[0] + basePositionX, xyz[1] + basePositionY, xyz[2] + basePositionZ);
                        abc[0] = abc[0] + 1;
                    }
                    nextB.run();
                    abc[2] = abc[2] + 1;
                }
                nextC.run();
                abc[1] = abc[1] + 1;
            }
        } else {
            abc[2] = -basePositionC;
            while (abc[2] < sizeC) {
                abc[1] = -basePositionB;
                while (abc[1] < sizeB) {
                    abc[0] = -basePositionA;
                    while (abc[0] < sizeA) {
                        extendedFacing.getWorldOffset(abc, xyz);
                        iBlockPosConsumer.consume(world, xyz[0] + basePositionX, xyz[1] + basePositionY, xyz[2] + basePositionZ);
                        abc[0] = abc[0] + 1;
                    }
                    nextB.run();
                    abc[1] = abc[1] + 1;
                }
                nextC.run();
                abc[2] = abc[2] + 1;
            }
        }
    }

    public static String[][] transpose(String[][] structurePiece) {
        String[][] shape = new String[structurePiece[0].length][structurePiece.length];
        for (int i = 0; i < structurePiece.length; ++i) {
            for (int j = 0; j < structurePiece[i].length; ++j) {
                shape[j][i] = structurePiece[i][j];
            }
        }
        return shape;
    }
}

