/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment.constructable;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public interface IMultiblockInfoContainer<T> {
    public static final HashMap<String, IMultiblockInfoContainer<?>> MULTIBLOCK_MAP = new HashMap();

    public static <T extends TileEntity> void registerTileClass(Class<T> clazz, IMultiblockInfoContainer<?> info) {
        MULTIBLOCK_MAP.put(clazz.getCanonicalName(), info);
    }

    public static <T> IMultiblockInfoContainer<T> get(Class<?> tClass) {
        return MULTIBLOCK_MAP.get(tClass.getCanonicalName());
    }

    public static boolean contains(Class<?> tClass) {
        return MULTIBLOCK_MAP.containsKey(tClass.getCanonicalName());
    }

    public void construct(ItemStack var1, boolean var2, T var3, ExtendedFacing var4);

    default public int survivalConstruct(ItemStack stackSize, int elementBudge, IItemSource source, EntityPlayerMP actorProfile, T tileEntity, ExtendedFacing aSide) {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getDescription(ItemStack var1);

    default public IConstructable toConstructable(final T tileEntity, final ExtendedFacing aSide) {
        return new IConstructable(){

            @Override
            public void construct(ItemStack stackSize, boolean hintsOnly) {
                IMultiblockInfoContainer.this.construct(stackSize, hintsOnly, tileEntity, aSide);
            }

            @Override
            public String[] getStructureDescription(ItemStack stackSize) {
                return IMultiblockInfoContainer.this.getDescription(stackSize);
            }
        };
    }

    public static <T> ISurvivalConstructable toConstructable(final IMultiblockInfoContainer<T> thiz, final T tileEntity, final ExtendedFacing aSide) {
        return new ISurvivalConstructable(){

            @Override
            public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
                return thiz.survivalConstruct(stackSize, elementBudget, source, actor, tileEntity, aSide);
            }

            @Override
            public void construct(ItemStack stackSize, boolean hintsOnly) {
                thiz.construct(stackSize, hintsOnly, tileEntity, aSide);
            }

            @Override
            public String[] getStructureDescription(ItemStack stackSize) {
                return thiz.getDescription(stackSize);
            }
        };
    }
}

