/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment.enumerable;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IntegerAxisSwap;
import com.gtnewhorizon.structurelib.alignment.enumerable.Direction;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public enum ExtendedFacing {
    DOWN_NORMAL_NONE("down normal none"),
    DOWN_NORMAL_HORIZONTAL("down normal horizontal"),
    DOWN_NORMAL_VERTICAL("down normal vertical"),
    DOWN_NORMAL_BOTH("down normal both"),
    DOWN_CLOCKWISE_NONE("down clockwise none"),
    DOWN_CLOCKWISE_HORIZONTAL("down clockwise horizontal"),
    DOWN_CLOCKWISE_VERTICAL("down clockwise vertical"),
    DOWN_CLOCKWISE_BOTH("down clockwise both"),
    DOWN_UPSIDE_DOWN_NONE("down upside down none"),
    DOWN_UPSIDE_DOWN_HORIZONTAL("down upside down horizontal"),
    DOWN_UPSIDE_DOWN_VERTICAL("down upside down vertical"),
    DOWN_UPSIDE_DOWN_BOTH("down upside down both"),
    DOWN_COUNTER_CLOCKWISE_NONE("down counter clockwise none"),
    DOWN_COUNTER_CLOCKWISE_HORIZONTAL("down counter clockwise horizontal"),
    DOWN_COUNTER_CLOCKWISE_VERTICAL("down counter clockwise vertical"),
    DOWN_COUNTER_CLOCKWISE_BOTH("down counter clockwise both"),
    UP_NORMAL_NONE("up normal none"),
    UP_NORMAL_HORIZONTAL("up normal horizontal"),
    UP_NORMAL_VERTICAL("up normal vertical"),
    UP_NORMAL_BOTH("up normal both"),
    UP_CLOCKWISE_NONE("up clockwise none"),
    UP_CLOCKWISE_HORIZONTAL("up clockwise horizontal"),
    UP_CLOCKWISE_VERTICAL("up clockwise vertical"),
    UP_CLOCKWISE_BOTH("up clockwise both"),
    UP_UPSIDE_DOWN_NONE("up upside down none"),
    UP_UPSIDE_DOWN_HORIZONTAL("up upside down horizontal"),
    UP_UPSIDE_DOWN_VERTICAL("up upside down vertical"),
    UP_UPSIDE_DOWN_BOTH("up upside down both"),
    UP_COUNTER_CLOCKWISE_NONE("up counter clockwise none"),
    UP_COUNTER_CLOCKWISE_HORIZONTAL("up counter clockwise horizontal"),
    UP_COUNTER_CLOCKWISE_VERTICAL("up counter clockwise vertical"),
    UP_COUNTER_CLOCKWISE_BOTH("up counter clockwise both"),
    NORTH_NORMAL_NONE("north normal none"),
    NORTH_NORMAL_HORIZONTAL("north normal horizontal"),
    NORTH_NORMAL_VERTICAL("north normal vertical"),
    NORTH_NORMAL_BOTH("north normal both"),
    NORTH_CLOCKWISE_NONE("north clockwise none"),
    NORTH_CLOCKWISE_HORIZONTAL("north clockwise horizontal"),
    NORTH_CLOCKWISE_VERTICAL("north clockwise vertical"),
    NORTH_CLOCKWISE_BOTH("north clockwise both"),
    NORTH_UPSIDE_DOWN_NONE("north upside down none"),
    NORTH_UPSIDE_DOWN_HORIZONTAL("north upside down horizontal"),
    NORTH_UPSIDE_DOWN_VERTICAL("north upside down vertical"),
    NORTH_UPSIDE_DOWN_BOTH("north upside down both"),
    NORTH_COUNTER_CLOCKWISE_NONE("north counter clockwise none"),
    NORTH_COUNTER_CLOCKWISE_HORIZONTAL("north counter clockwise horizontal"),
    NORTH_COUNTER_CLOCKWISE_VERTICAL("north counter clockwise vertical"),
    NORTH_COUNTER_CLOCKWISE_BOTH("north counter clockwise both"),
    SOUTH_NORMAL_NONE("south normal none"),
    SOUTH_NORMAL_HORIZONTAL("south normal horizontal"),
    SOUTH_NORMAL_VERTICAL("south normal vertical"),
    SOUTH_NORMAL_BOTH("south normal both"),
    SOUTH_CLOCKWISE_NONE("south clockwise none"),
    SOUTH_CLOCKWISE_HORIZONTAL("south clockwise horizontal"),
    SOUTH_CLOCKWISE_VERTICAL("south clockwise vertical"),
    SOUTH_CLOCKWISE_BOTH("south clockwise both"),
    SOUTH_UPSIDE_DOWN_NONE("south upside down none"),
    SOUTH_UPSIDE_DOWN_HORIZONTAL("south upside down horizontal"),
    SOUTH_UPSIDE_DOWN_VERTICAL("south upside down vertical"),
    SOUTH_UPSIDE_DOWN_BOTH("south upside down both"),
    SOUTH_COUNTER_CLOCKWISE_NONE("south counter clockwise none"),
    SOUTH_COUNTER_CLOCKWISE_HORIZONTAL("south counter clockwise horizontal"),
    SOUTH_COUNTER_CLOCKWISE_VERTICAL("south counter clockwise vertical"),
    SOUTH_COUNTER_CLOCKWISE_BOTH("south counter clockwise both"),
    WEST_NORMAL_NONE("west normal none"),
    WEST_NORMAL_HORIZONTAL("west normal horizontal"),
    WEST_NORMAL_VERTICAL("west normal vertical"),
    WEST_NORMAL_BOTH("west normal both"),
    WEST_CLOCKWISE_NONE("west clockwise none"),
    WEST_CLOCKWISE_HORIZONTAL("west clockwise horizontal"),
    WEST_CLOCKWISE_VERTICAL("west clockwise vertical"),
    WEST_CLOCKWISE_BOTH("west clockwise both"),
    WEST_UPSIDE_DOWN_NONE("west upside down none"),
    WEST_UPSIDE_DOWN_HORIZONTAL("west upside down horizontal"),
    WEST_UPSIDE_DOWN_VERTICAL("west upside down vertical"),
    WEST_UPSIDE_DOWN_BOTH("west upside down both"),
    WEST_COUNTER_CLOCKWISE_NONE("west counter clockwise none"),
    WEST_COUNTER_CLOCKWISE_HORIZONTAL("west counter clockwise horizontal"),
    WEST_COUNTER_CLOCKWISE_VERTICAL("west counter clockwise vertical"),
    WEST_COUNTER_CLOCKWISE_BOTH("west counter clockwise both"),
    EAST_NORMAL_NONE("east normal none"),
    EAST_NORMAL_HORIZONTAL("east normal horizontal"),
    EAST_NORMAL_VERTICAL("east normal vertical"),
    EAST_NORMAL_BOTH("east normal both"),
    EAST_CLOCKWISE_NONE("east clockwise none"),
    EAST_CLOCKWISE_HORIZONTAL("east clockwise horizontal"),
    EAST_CLOCKWISE_VERTICAL("east clockwise vertical"),
    EAST_CLOCKWISE_BOTH("east clockwise both"),
    EAST_UPSIDE_DOWN_NONE("east upside down none"),
    EAST_UPSIDE_DOWN_HORIZONTAL("east upside down horizontal"),
    EAST_UPSIDE_DOWN_VERTICAL("east upside down vertical"),
    EAST_UPSIDE_DOWN_BOTH("east upside down both"),
    EAST_COUNTER_CLOCKWISE_NONE("east counter clockwise none"),
    EAST_COUNTER_CLOCKWISE_HORIZONTAL("east counter clockwise horizontal"),
    EAST_COUNTER_CLOCKWISE_VERTICAL("east counter clockwise vertical"),
    EAST_COUNTER_CLOCKWISE_BOTH("east counter clockwise both");

    public static final ExtendedFacing DEFAULT;
    public static final ExtendedFacing[] VALUES;
    public static final Map<ForgeDirection, List<ExtendedFacing>> FOR_FACING;
    public static final int STATES_COUNT;
    private static final Map<String, ExtendedFacing> NAME_LOOKUP;
    private static final EnumMap<ForgeDirection, ImmutableSet<ExtendedFacing>> LOOKUP_BY_DIRECTION;
    private static final EnumMap<Rotation, ImmutableSet<ExtendedFacing>> LOOKUP_BY_ROTATION;
    private static final EnumMap<Flip, ImmutableSet<ExtendedFacing>> LOOKUP_BY_FLIP;
    private final ForgeDirection direction;
    private final ForgeDirection a;
    private final ForgeDirection b;
    private final ForgeDirection c;
    private final Rotation rotation;
    private final Flip flip;
    private final String name;
    private final IntegerAxisSwap integerAxisSwap;

    private ExtendedFacing(String name) {
        ForgeDirection c;
        ForgeDirection b;
        ForgeDirection a;
        this.name = name;
        this.direction = Direction.VALUES[this.ordinal() / (IAlignment.ROTATIONS_COUNT * IAlignment.FLIPS_COUNT)].getForgeDirection();
        this.rotation = Rotation.VALUES[this.ordinal() / IAlignment.FLIPS_COUNT - this.direction.ordinal() * IAlignment.ROTATIONS_COUNT];
        this.flip = Flip.VALUES[this.ordinal() % IAlignment.FLIPS_COUNT];
        switch (this.direction) {
            case DOWN: {
                a = ForgeDirection.WEST;
                b = ForgeDirection.SOUTH;
                c = ForgeDirection.UP;
                break;
            }
            case UP: {
                a = ForgeDirection.EAST;
                b = ForgeDirection.SOUTH;
                c = ForgeDirection.DOWN;
                break;
            }
            case NORTH: {
                a = ForgeDirection.WEST;
                b = ForgeDirection.DOWN;
                c = ForgeDirection.SOUTH;
                break;
            }
            case SOUTH: {
                a = ForgeDirection.EAST;
                b = ForgeDirection.DOWN;
                c = ForgeDirection.NORTH;
                break;
            }
            case WEST: {
                a = ForgeDirection.SOUTH;
                b = ForgeDirection.DOWN;
                c = ForgeDirection.EAST;
                break;
            }
            case EAST: {
                a = ForgeDirection.NORTH;
                b = ForgeDirection.DOWN;
                c = ForgeDirection.WEST;
                break;
            }
            default: {
                throw new RuntimeException("Is impossible...");
            }
        }
        switch (this.flip) {
            case HORIZONTAL: {
                a = a.getOpposite();
                break;
            }
            case BOTH: {
                a = a.getOpposite();
            }
            case VERTICAL: {
                b = b.getOpposite();
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new RuntimeException("Even more impossible...");
            }
        }
        switch (this.rotation) {
            case CLOCKWISE: {
                ForgeDirection _a = a;
                a = b;
                b = _a.getOpposite();
                break;
            }
            case UPSIDE_DOWN: {
                a = a.getOpposite();
                b = b.getOpposite();
                break;
            }
            case COUNTER_CLOCKWISE: {
                ForgeDirection _a = a;
                a = b.getOpposite();
                b = _a;
                break;
            }
            case NORMAL: {
                break;
            }
            default: {
                throw new RuntimeException("More impossible...");
            }
        }
        this.a = a;
        this.b = b;
        this.c = c;
        this.integerAxisSwap = new IntegerAxisSwap(a, b, c);
    }

    public static ExtendedFacing of(ForgeDirection direction, Rotation rotation, Flip flip) {
        if (direction == ForgeDirection.UNKNOWN) {
            return VALUES[IAlignment.getAlignmentIndex(ForgeDirection.NORTH, rotation, flip)];
        }
        return VALUES[IAlignment.getAlignmentIndex(direction, rotation, flip)];
    }

    public static ExtendedFacing of(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return DEFAULT;
        }
        return VALUES[IAlignment.getAlignmentIndex(direction, Rotation.NORMAL, Flip.NONE)];
    }

    public static ImmutableSet<ExtendedFacing> getAllWith(ForgeDirection direction) {
        return LOOKUP_BY_DIRECTION.get(direction);
    }

    public static ImmutableSet<ExtendedFacing> getAllWith(Rotation rotation) {
        return LOOKUP_BY_ROTATION.get((Object)rotation);
    }

    public static ImmutableSet<ExtendedFacing> getAllWith(Flip flip) {
        return LOOKUP_BY_FLIP.get((Object)flip);
    }

    public ExtendedFacing with(ForgeDirection direction) {
        return ExtendedFacing.of(direction, this.rotation, this.flip);
    }

    public ExtendedFacing with(Rotation rotation) {
        return ExtendedFacing.of(this.direction, rotation, this.flip);
    }

    public ExtendedFacing with(Flip flip) {
        return ExtendedFacing.of(this.direction, this.rotation, flip);
    }

    public ExtendedFacing getOppositeDirection() {
        return ExtendedFacing.of(this.direction.getOpposite(), this.rotation, this.flip);
    }

    public ExtendedFacing getOppositeRotation() {
        return ExtendedFacing.of(this.direction, this.rotation.getOpposite(), this.flip);
    }

    public ExtendedFacing getOppositeFlip() {
        return ExtendedFacing.of(this.direction, this.rotation, this.flip.getOpposite());
    }

    public ExtendedFacing getDuplicate() {
        return ExtendedFacing.of(this.direction, this.rotation.getOpposite(), this.flip.getOpposite());
    }

    public int getIndex() {
        return this.ordinal();
    }

    public String getName2() {
        return this.name;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)("structurelib.facing." + this.getIndex()));
    }

    public static ExtendedFacing byName(String name) {
        return name == null ? null : NAME_LOOKUP.get(name.toLowerCase(Locale.ROOT));
    }

    public static ExtendedFacing byIndex(int index) {
        return VALUES[Math.abs(index % VALUES.length)];
    }

    public static ExtendedFacing random(Random rand) {
        return VALUES[rand.nextInt(VALUES.length)];
    }

    public ForgeDirection getDirection() {
        return this.direction;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Flip getFlip() {
        return this.flip;
    }

    public Vec3 getWorldOffset(Vec3 abcOffset) {
        return this.integerAxisSwap.inverseTranslate(abcOffset);
    }

    public Vec3Impl getWorldOffset(Vec3Impl abcOffset) {
        return this.integerAxisSwap.inverseTranslate(abcOffset);
    }

    public void getWorldOffset(int[] point, int[] out) {
        this.integerAxisSwap.inverseTranslate(point, out);
    }

    public void getWorldOffset(double[] point, double[] out) {
        this.integerAxisSwap.inverseTranslate(point, out);
    }

    public Vec3 getOffsetABC(Vec3 xyzOffset) {
        return this.integerAxisSwap.translate(xyzOffset);
    }

    public Vec3Impl getOffsetABC(Vec3Impl xyzOffset) {
        return this.integerAxisSwap.translate(xyzOffset);
    }

    public void getOffsetABC(int[] point, int[] out) {
        this.integerAxisSwap.translate(point, out);
    }

    public void getOffsetABC(double[] point, double[] out) {
        this.integerAxisSwap.translate(point, out);
    }

    public IntegerAxisSwap getIntegerAxisSwap() {
        return this.integerAxisSwap;
    }

    public ForgeDirection getRelativeLeftInWorld() {
        return this.a;
    }

    public ForgeDirection getRelativeRightInWorld() {
        return this.a.getOpposite();
    }

    public ForgeDirection getRelativeDownInWorld() {
        return this.b;
    }

    public ForgeDirection getRelativeUpInWorld() {
        return this.b.getOpposite();
    }

    public ForgeDirection getRelativeBackInWorld() {
        return this.c;
    }

    public ForgeDirection getRelativeForwardInWorld() {
        return this.c.getOpposite();
    }

    static {
        DEFAULT = NORTH_NORMAL_NONE;
        VALUES = ExtendedFacing.values();
        FOR_FACING = new HashMap<ForgeDirection, List<ExtendedFacing>>();
        STATES_COUNT = VALUES.length;
        Arrays.stream(ExtendedFacing.values()).forEach(extendedFacing -> FOR_FACING.compute(extendedFacing.direction, (forgeDirection, extendedFacings) -> {
            if (extendedFacings == null) {
                extendedFacings = new ArrayList<ExtendedFacing>();
            }
            extendedFacings.add(extendedFacing);
            return extendedFacings;
        }));
        NAME_LOOKUP = Arrays.stream(VALUES).collect(Collectors.toMap(ExtendedFacing::getName2, extendedFacing -> extendedFacing));
        LOOKUP_BY_DIRECTION = Arrays.stream(VALUES).collect(Collectors.groupingBy(ExtendedFacing::getDirection, () -> new EnumMap(ForgeDirection.class), Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf)));
        LOOKUP_BY_ROTATION = Arrays.stream(VALUES).collect(Collectors.groupingBy(ExtendedFacing::getRotation, () -> new EnumMap(Rotation.class), Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf)));
        LOOKUP_BY_FLIP = Arrays.stream(VALUES).collect(Collectors.groupingBy(ExtendedFacing::getFlip, () -> new EnumMap(Flip.class), Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf)));
    }
}

