/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import com.gtnewhorizon.structurelib.ConfigurationVersion;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public enum ConfigurationHandler {
    INSTANCE;

    private Configuration config;
    private int maxCoexistingHologram;
    private boolean removeCollidingHologram;

    private ConfigurationHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    void init(File f) {
        this.config = new Configuration(f, ConfigurationVersion.latest().getVersionMarker());
        ConfigurationVersion.migrateToLatest(this.config);
        this.loadConfig();
        this.setLanguageKeys();
    }

    private void setLanguageKeys() {
        for (String categoryName : this.config.getCategoryNames()) {
            ConfigCategory category = this.config.getCategory(categoryName);
            category.setLanguageKey("structurelib.config." + categoryName);
            for (Map.Entry entry : category.entrySet()) {
                ((Property)entry.getValue()).setLanguageKey(String.format("%s.%s", category.getLanguagekey(), entry.getKey()));
            }
        }
    }

    private void loadConfig() {
        this.maxCoexistingHologram = this.config.getInt("maxCoexisting", "client.hologram", 1, 1, 100, "An attempt will be made to prune old holograms when a new hologram is about to be projected");
        this.removeCollidingHologram = this.config.getBoolean("removeColliding", "client.hologram", true, "An attempt will be made to remove an existing hologram if it collides with a new hologram.");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.PostConfigChangedEvent e) {
        if (e.modID.equals("structurelib")) {
            this.loadConfig();
        }
    }

    public int getMaxCoexistingHologram() {
        return this.maxCoexistingHologram;
    }

    public boolean isRemoveCollidingHologram() {
        return this.removeCollidingHologram;
    }

    Configuration getConfig() {
        return this.config;
    }
}

