/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.proxy;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.gtnewhorizon.structurelib.ConfigurationHandler;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.entity.fx.EntityFXBlockHint;
import com.gtnewhorizon.structurelib.entity.fx.WeightlessParticleFX;
import com.gtnewhorizon.structurelib.proxy.CommonProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class ClientProxy
extends CommonProxy {
    private static final BiMap<EntityFXBlockHint, HintParticleInfo> allHints = HashBiMap.create();
    private static final List<List<EntityFXBlockHint>> hintOwners = new ArrayList<List<EntityFXBlockHint>>();
    private static List<EntityFXBlockHint> currentHints;

    @Override
    public void hintParticleTinted(World w, int x, int y, int z, IIcon[] icons, short[] RGBa) {
        EntityFXBlockHint hint = new EntityFXBlockHint(w, x, y, z, icons).withColorTint(RGBa);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)hint);
        this.ensureHinting();
        if (ConfigurationHandler.INSTANCE.isRemoveCollidingHologram()) {
            List owner;
            HintParticleInfo info = new HintParticleInfo(x, y, z, currentHints);
            EntityFXBlockHint dupe = (EntityFXBlockHint)((Object)allHints.inverse().get((Object)info));
            if (dupe != null && (owner = ((HintParticleInfo)allHints.get((Object)dupe)).owner) != currentHints) {
                hintOwners.remove(owner);
                owner.forEach(EntityFXBlockHint::func_70106_y);
                owner.clear();
            }
            allHints.forcePut((Object)hint, (Object)info);
        }
        currentHints.add(hint);
        WeightlessParticleFX particle = new WeightlessParticleFX(w, (float)x + StructureLib.RANDOM.nextFloat() * 0.5f, (float)y + StructureLib.RANDOM.nextFloat() * 0.5f, (float)z + StructureLib.RANDOM.nextFloat() * 0.5f, 0.0, 0.0, 0.0);
        particle.func_70538_b(0.0f, 0.6f * StructureLib.RANDOM.nextFloat(), 0.8f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
    }

    @Override
    public void hintParticleTinted(World w, int x, int y, int z, Block block, int meta, short[] RGBa) {
        this.hintParticleTinted(w, x, y, z, ClientProxy.createIIconFromBlock(block, meta), RGBa);
    }

    @Override
    public void hintParticle(World w, int x, int y, int z, IIcon[] icons) {
        this.hintParticleTinted(w, x, y, z, icons, new short[]{255, 255, 255, 0});
    }

    @Override
    public void hintParticle(World w, int x, int y, int z, Block block, int meta) {
        this.hintParticleTinted(w, x, y, z, ClientProxy.createIIconFromBlock(block, meta), new short[]{255, 255, 255, 0});
    }

    private static IIcon[] createIIconFromBlock(Block block, int meta) {
        IIcon[] ret = new IIcon[6];
        for (int i = 0; i < 6; ++i) {
            ret[i] = block.func_149691_a(i, meta);
        }
        return ret;
    }

    @Override
    public void addClientSideChatMessages(String ... messages) {
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        for (String s : messages) {
            chat.func_146227_a((IChatComponent)new ChatComponentText(s));
        }
    }

    @Override
    public EntityPlayer getCurrentPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isCurrentPlayer(EntityPlayer player) {
        return player == Minecraft.func_71410_x().field_71439_g;
    }

    public static void onHintDead(EntityFXBlockHint fx) {
        if (ConfigurationHandler.INSTANCE.isRemoveCollidingHologram()) {
            allHints.remove((Object)fx);
        }
        Iterator<List<EntityFXBlockHint>> iterator = hintOwners.iterator();
        while (iterator.hasNext()) {
            List<EntityFXBlockHint> list = iterator.next();
            if (!list.remove((Object)fx)) continue;
            if (!list.isEmpty()) break;
            iterator.remove();
            break;
        }
    }

    @Override
    public void startHinting(World w) {
        if (!w.field_72995_K) {
            return;
        }
        if (currentHints != null) {
            hintOwners.add(currentHints);
        }
        currentHints = new LinkedList<EntityFXBlockHint>();
    }

    private void ensureHinting() {
        if (currentHints == null) {
            currentHints = new LinkedList<EntityFXBlockHint>();
        }
    }

    @Override
    public void endHinting(World w) {
        if (!w.field_72995_K) {
            return;
        }
        while (!hintOwners.isEmpty() && hintOwners.size() >= ConfigurationHandler.INSTANCE.getMaxCoexistingHologram()) {
            List<EntityFXBlockHint> list = hintOwners.remove(0);
            list.forEach(EntityFXBlockHint::func_70106_y);
            list.clear();
        }
        if (!currentHints.isEmpty()) {
            hintOwners.add(currentHints);
        }
        currentHints = null;
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
    }

    public static class ForgeEventHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load e) {
            if (e.world.field_72995_K) {
                allHints.clear();
                hintOwners.clear();
            }
        }
    }

    private static class HintParticleInfo {
        private final int x;
        private final int y;
        private final int z;
        private final List<EntityFXBlockHint> owner;

        public HintParticleInfo(int x, int y, int z, List<EntityFXBlockHint> owner) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.owner = owner;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HintParticleInfo that = (HintParticleInfo)o;
            if (this.x != that.x) {
                return false;
            }
            if (this.y != that.y) {
                return false;
            }
            return this.z == that.z;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }
    }
}

