/*
 * Decompiled with CFR 0.152.
 */
package net.glease.structurecompat;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.gtnewhorizon.structurelib.util.InventoryUtility;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

abstract class MEInventoryStackExtractor
implements InventoryUtility.ItemStackExtractor {
    MEInventoryStackExtractor() {
    }

    private static int extractFromMEInventory(IEnergySource source, IAEItemStack toExtract, boolean simulate, EntityPlayerMP player, IMEInventoryHandler<IAEItemStack> inv) {
        PlayerSource actionSource = new PlayerSource((EntityPlayer)player, null);
        IAEItemStack extracted = simulate ? (IAEItemStack)inv.extractItems((IAEStack)toExtract, Actionable.SIMULATE, (BaseActionSource)actionSource) : AEApi.instance().storage().poweredExtraction(source, inv, toExtract, (BaseActionSource)actionSource);
        return Math.toIntExact(extracted == null ? 0L : extracted.getStackSize());
    }

    protected abstract Pair<IEnergySource, IMEInventoryHandler<IAEItemStack>> fromItem(ItemStack var1, EntityPlayerMP var2);

    public boolean isAPIImplemented(InventoryUtility.ItemStackExtractor.APIType type) {
        return type == InventoryUtility.ItemStackExtractor.APIType.EXTRACT_ONE_STACK || type == InventoryUtility.ItemStackExtractor.APIType.MAIN;
    }

    public int takeFromStack(Predicate<ItemStack> predicate, boolean simulate, int count, InventoryUtility.ItemStackCounter store, ItemStack source, ItemStack filter, EntityPlayerMP player) {
        if (source == null || source.field_77994_a <= 0) {
            return 0;
        }
        Pair<IEnergySource, IMEInventoryHandler<IAEItemStack>> pair = this.fromItem(source, player);
        if (pair == null) {
            return 0;
        }
        IEnergySource energy = (IEnergySource)pair.getLeft();
        IMEInventoryHandler cellInventory = (IMEInventoryHandler)pair.getRight();
        IItemList items = cellInventory.getAvailableItems(AEApi.instance().storage().createPrimitiveItemList());
        count = Math.min(count, (int)energy.extractAEPower((double)count, Actionable.SIMULATE, PowerMultiplier.ONE));
        int found = 0;
        for (IAEItemStack stackAE : items) {
            IAEItemStack toExtract;
            int extracted;
            ItemStack stack = stackAE.getItemStack();
            if (!predicate.test(stack) || (extracted = MEInventoryStackExtractor.extractFromMEInventory(energy, toExtract = (IAEItemStack)stackAE.copy().setStackSize((long)(Math.min(count, found + stack.field_77994_a) - found)), simulate, player, (IMEInventoryHandler<IAEItemStack>)cellInventory)) == 0) continue;
            store.add(stack, extracted);
            if ((found += extracted) < count) continue;
            return found;
        }
        return found;
    }

    public int getItem(ItemStack source, ItemStack toExtract, boolean simulate, EntityPlayerMP player) {
        if (source == null || source.field_77994_a <= 0) {
            return 0;
        }
        Pair<IEnergySource, IMEInventoryHandler<IAEItemStack>> pair = this.fromItem(source, player);
        if (pair == null) {
            return 0;
        }
        return MEInventoryStackExtractor.extractFromMEInventory((IEnergySource)pair.getLeft(), AEApi.instance().storage().createItemStack(toExtract), simulate, player, (IMEInventoryHandler<IAEItemStack>)((IMEInventoryHandler)pair.getRight()));
    }
}

