/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config.settings;

import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.config.IEnabler;
import dev.rndmorris.salisarcana.config.settings.Setting;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;

public class CommandSettings
extends Setting {
    public final Set<String> aliases = new HashSet<String>();
    @Nonnull
    public final String name;
    private final Map<String, ChildPermission> childPermissions = new TreeMap<String, ChildPermission>();
    @Nullable
    private Supplier<ArcanaCommandBase<?>> commandGetter;
    @Nonnull
    private String description = "";
    private byte permissionLevel = (byte)4;

    public CommandSettings(@Nonnull String name, IEnabler dependency) {
        super(dependency);
        this.name = name;
        this.setCategory(name.replace('-', '_'));
    }

    public CommandSettings addAlias(String alias) {
        this.aliases.add(alias);
        return this;
    }

    public CommandSettings addChildPermissionLevel(String configKey, int level, String description) {
        ChildPermission permission = new ChildPermission();
        permission.permissionLevel = (byte)level;
        permission.description = description;
        this.childPermissions.put(configKey, permission);
        return this;
    }

    public CommandSettings addDefaultAlias() {
        this.aliases.add(this.name);
        return this;
    }

    @Nullable
    public ArcanaCommandBase<?> getCommand() {
        return this.commandGetter != null ? this.commandGetter.get() : null;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getFullName() {
        return String.format("%s-%s", "salisarcana", this.name);
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public void setCommandGetter(@Nullable Supplier<ArcanaCommandBase<?>> commandGetter) {
        this.commandGetter = commandGetter;
    }

    public CommandSettings setDescription(@Nonnull String description) {
        this.description = description;
        return this;
    }

    public CommandSettings setPermissionLevel(int permissionLevel) {
        this.permissionLevel = (byte)permissionLevel;
        return this;
    }

    @Override
    public void loadFromConfiguration(Configuration configuration) {
        configuration.setCategoryComment(this.getCategory(), String.format("/%s | %s", this.getFullName(), this.getDescription()));
        this.enabled = configuration.getBoolean("commandEnabled", this.getCategory(), this.enabled, "Enable or disable the command.");
        String[] configAliases = configuration.getStringList("aliases", this.getCategory(), this.aliases.toArray(new String[0]), "Secondary names that refer to this command.");
        this.aliases.clear();
        Collections.addAll(this.aliases, configAliases);
        this.permissionLevel = (byte)configuration.getInt("permissionLevel", this.getCategory(), (int)this.permissionLevel, 0, 4, "The permission level required to execute the command.");
        for (String childConfig : this.childPermissions.keySet()) {
            ChildPermission childPerm = this.childPermissions.get(childConfig);
            int configLevel = configuration.getInt(childConfig, this.getCategory(), (int)childPerm.permissionLevel, 0, 4, childPerm.description);
            childPerm.permissionLevel = (byte)configLevel;
        }
    }

    public byte getChildPermissionLevel(String configName) {
        ChildPermission childPerm = this.childPermissions.get(configName);
        if (childPerm == null) {
            return 127;
        }
        return childPerm.permissionLevel;
    }

    private static class ChildPermission {
        public String description;
        public byte permissionLevel;

        private ChildPermission() {
        }
    }
}

