/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import dev.rndmorris.salisarcana.lib.WandHelper;
import java.text.NumberFormat;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.input.Keyboard;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.wands.StaffRod;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.config.ConfigItems;

public class WandPartTooltipEventHandler {
    private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
    private static final Aspect[] PRIMALS = new Aspect[]{Aspect.AIR, Aspect.EARTH, Aspect.FIRE, Aspect.WATER, Aspect.ORDER, Aspect.ENTROPY};

    @SubscribeEvent
    public void renderTooltip(ItemTooltipEvent event) {
        boolean expandText = Keyboard.isKeyDown((int)29);
        WandCap wandCap = WandHelper.getWandCapFromItem(event.itemStack);
        WandRod wandRod = WandHelper.getWandRodFromItem(event.itemStack);
        if (wandCap != null && ResearchCategories.getResearch((String)wandCap.getResearch()) == null) {
            return;
        }
        if (wandRod != null && ResearchCategories.getResearch((String)wandRod.getResearch()) == null) {
            return;
        }
        if (!(expandText || wandCap == null && wandRod == null)) {
            event.toolTip.add(StatCollector.func_74838_a((String)"salisarcana:wand_part.show_details"));
            return;
        }
        if (wandCap != null) {
            float baseCost = wandCap.getBaseCostModifier();
            float specialCost = wandCap.getSpecialCostModifier();
            List specialAspects = wandCap.getSpecialCostModifierAspects();
            String baseCostString = (baseCost > 1.0f ? "\u00a74" : "\u00a72") + PERCENT_FORMAT.format(1.0f - baseCost);
            if (specialCost == 0.0f || specialAspects == null || specialAspects.isEmpty()) {
                event.toolTip.add(StatCollector.func_74837_a((String)"salisarcana:wand_cap.vis_discount.generic", (Object[])new Object[]{baseCostString}));
            } else {
                String specialCostString = (specialCost > 1.0f ? "\u00a74" : "\u00a72") + PERCENT_FORMAT.format(1.0f - specialCost);
                StringJoiner specials = new StringJoiner(", ");
                StringJoiner normals = new StringJoiner(", ");
                for (Aspect primal : PRIMALS) {
                    String primalName = "\u00a7" + primal.getChatcolor() + primal.getName();
                    if (specialAspects.contains(primal)) {
                        specials.add(primalName);
                        continue;
                    }
                    normals.add(primalName);
                }
                event.toolTip.add(StatCollector.func_74837_a((String)"salisarcana:wand_cap.vis_discount.aspect", (Object[])new Object[]{specials.toString(), specialCostString}));
                event.toolTip.add(StatCollector.func_74837_a((String)"salisarcana:wand_cap.vis_discount.aspect", (Object[])new Object[]{normals.toString(), baseCostString}));
            }
            event.toolTip.add(StatCollector.func_74837_a((String)"salisarcana:wand_cap.price_mult", (Object[])new Object[]{wandCap.getCraftCost()}));
            WandPartTooltipEventHandler.addMultilineTranslation(event.toolTip, "salisarcana:wand_cap.special." + wandCap.getTag());
            if (wandCap == ConfigItems.WAND_CAP_IRON) {
                event.toolTip.add(StatCollector.func_74838_a((String)"salisarcana:wand_part.cannot_preserve_node"));
            }
        } else if (wandRod != null) {
            StaffRod staff;
            event.toolTip.add(StatCollector.func_74837_a((String)"salisarcana:wand_rod.vis_capacity", (Object[])new Object[]{wandRod.getCapacity()}));
            event.toolTip.add(StatCollector.func_74837_a((String)"salisarcana:wand_rod.base_price", (Object[])new Object[]{wandRod.getCraftCost()}));
            if (wandRod instanceof StaffRod && (staff = (StaffRod)wandRod).hasRunes()) {
                event.toolTip.add(StatCollector.func_74838_a((String)"salisarcana:wand_rod.runes"));
            }
            WandPartTooltipEventHandler.addMultilineTranslation(event.toolTip, "salisarcana:wand_rod.special." + wandRod.getTag());
            if (wandRod == ConfigItems.WAND_ROD_WOOD) {
                event.toolTip.add(StatCollector.func_74838_a((String)"salisarcana:wand_part.cannot_preserve_node"));
            }
        }
    }

    private static void addMultilineTranslation(List<String> tooltip, String langKey) {
        String translation = StatCollector.func_74838_a((String)langKey);
        if (translation != langKey) {
            tooltip.add(translation);
            return;
        }
        int keyNum = 1;
        String line;
        String langKeyLine;
        while ((langKeyLine = langKey + "." + keyNum) != (line = StatCollector.func_74838_a((String)langKeyLine))) {
            tooltip.add(line);
            ++keyNum;
        }
        return;
    }
}

