/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config.settings;

import dev.rndmorris.salisarcana.config.IEnabler;
import dev.rndmorris.salisarcana.config.settings.Setting;
import dev.rndmorris.salisarcana.core.SalisArcanaCore;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;

public class EnumSetting<E extends Enum<E>>
extends Setting {
    protected final Class<E> enumClass;
    protected final String name;
    protected final String comment;
    protected E value;

    public EnumSetting(IEnabler dependency, String name, String comment, @Nonnull E defaultValue) {
        super(dependency);
        this.name = name;
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
        this.value = defaultValue;
        StringBuilder sb = new StringBuilder();
        Iterator $vals = Arrays.stream((Enum[])this.enumClass.getEnumConstants()).iterator();
        while ($vals.hasNext()) {
            sb.append(((Enum)$vals.next()).toString());
            if (!$vals.hasNext()) continue;
            sb.append(", ");
        }
        this.comment = comment + " Valid values: [" + sb + "]";
    }

    @Override
    public void loadFromConfiguration(Configuration configuration) {
        CharSequence[] validValues = (String[])Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::toString).toArray(String[]::new);
        String valueString = configuration.getString(this.name, this.getCategory(), ((Enum)this.value).toString(), this.comment, (String[])validValues);
        try {
            this.value = Enum.valueOf(this.enumClass, valueString);
        }
        catch (IllegalArgumentException e) {
            SalisArcanaCore.LOG.error("Invalid enum value for config \"{}\": {}. Value must be one of: {}", new Object[]{this.name, valueString, String.join((CharSequence)", ", validValues)});
        }
    }
}

