/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config;

import dev.rndmorris.salisarcana.config.ConfigGroup;
import dev.rndmorris.salisarcana.config.group.ConfigBugfixes;
import dev.rndmorris.salisarcana.config.group.ConfigCommands;
import dev.rndmorris.salisarcana.config.group.ConfigFeatures;
import dev.rndmorris.salisarcana.config.group.ConfigModCompat;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class SalisConfig {
    static final List<ConfigGroup> groups = new ArrayList<ConfigGroup>();
    public static final ConfigBugfixes bugfixes = new ConfigBugfixes();
    public static final ConfigCommands commands = new ConfigCommands();
    public static final ConfigFeatures features = new ConfigFeatures();
    public static final ConfigModCompat modCompat = new ConfigModCompat();
    public static boolean enableVersionChecking;

    public static void synchronizeConfiguration() {
        String rootConfigFile = Paths.get("config", "salisarcana.cfg").toString();
        Configuration rootConfig = new Configuration(new File(rootConfigFile));
        enableVersionChecking = rootConfig.getBoolean("enableversionChecking", "general", true, "Check for new versions of Salis Arcana on startup");
        for (ConfigGroup group : groups) {
            String toggleName = String.format("Enable %s group", group.getGroupName());
            boolean enabled = rootConfig.getBoolean(toggleName, "modules", group.isEnabled(), group.getGroupComment());
            group.setEnabled(enabled);
            if (!enabled) continue;
            Configuration groupConfig = SalisConfig.getGroupConfig(group);
            group.loadFromConfig(groupConfig);
            if (!groupConfig.hasChanged()) continue;
            groupConfig.save();
        }
        if (rootConfig.hasChanged()) {
            rootConfig.save();
        }
    }

    private static Configuration getGroupConfig(ConfigGroup group) {
        String path = Paths.get("config", "salisarcana", group.getGroupName() + ".cfg").toString();
        return new Configuration(new File(path));
    }
}

