/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.segment.ISegment;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Random;

public abstract class SegmentBase
implements ISegment {
    @Override
    public void generate(IWorldEditor editor, Random rand, IDungeonLevel level, Cardinal dir, ITheme theme, Coord pos) {
        if (level.hasNearbyNode(new Coord(pos))) {
            return;
        }
        if (this.isValidWall(editor, dir, new Coord(pos))) {
            this.genWall(editor, rand, level, dir, theme, new Coord(pos));
        }
    }

    protected abstract void genWall(IWorldEditor var1, Random var2, IDungeonLevel var3, Cardinal var4, ITheme var5, Coord var6);

    protected boolean isValidWall(IWorldEditor editor, Cardinal wallDirection, Coord pos) {
        switch (wallDirection) {
            case NORTH: {
                if (editor.isAirBlock(new Coord(-1, 1, 2).add(pos))) {
                    return false;
                }
                if (!editor.isAirBlock(new Coord(1, 1, 2).add(pos))) break;
                return false;
            }
            case SOUTH: {
                if (editor.isAirBlock(new Coord(-1, 1, 2).add(pos))) {
                    return false;
                }
                if (!editor.isAirBlock(new Coord(1, 1, 2).add(pos))) break;
                return false;
            }
            case EAST: {
                if (editor.isAirBlock(new Coord(2, 1, -1).add(pos))) {
                    return false;
                }
                if (!editor.isAirBlock(new Coord(2, 1, 1).add(pos))) break;
                return false;
            }
            case WEST: {
                if (editor.isAirBlock(new Coord(-2, 1, -1).add(pos))) {
                    return false;
                }
                if (!editor.isAirBlock(new Coord(-2, 1, 1).add(pos))) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

