/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.postea.utility;

import akka.japi.Pair;
import com.gtnewhorizons.neid.mixins.interfaces.IExtendedBlockStorageMixin;
import com.gtnewhorizons.postea.api.BlockReplacementManager;
import com.gtnewhorizons.postea.api.TileEntityReplacementManager;
import com.gtnewhorizons.postea.utility.BlockConversionInfo;
import com.gtnewhorizons.postea.utility.BlockInfo;
import com.gtnewhorizons.postea.utility.PosteaUtilities;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class ChunkFixerUtility {
    public static final int POSTEA_UPDATE_CODE = PosteaUtilities.getModListHash();
    private static final int AIR_ID = 0;
    private static final HashMap<Block, String> loadedBlocks = new HashMap();

    public static void transformNormalBlocks(Chunk chunk, ExtendedBlockStorage ebs, World world) {
        int chunkXPos = chunk.field_76635_g * 16;
        int chunkZPos = chunk.field_76647_h * 16;
        int sectionY = ebs.func_76662_d();
        IExtendedBlockStorageMixin ebsMixin = (IExtendedBlockStorageMixin)ebs;
        short[] blockArray = ebsMixin.getBlock16BArray();
        short[] metadataArray = ebsMixin.getBlock16BMetaArray();
        for (int index = 0; index < blockArray.length; ++index) {
            int blockId = blockArray[index];
            short metadata = metadataArray[index];
            if (blockId == 0 || BlockReplacementManager.blockNotConvertible(blockId)) continue;
            Block block = Block.func_149729_e((int)blockId);
            String blockName = loadedBlocks.computeIfAbsent(block, b -> GameRegistry.findUniqueIdentifierFor((Block)b).toString());
            BlockConversionInfo blockConversionInfo = new BlockConversionInfo();
            blockConversionInfo.blockName = blockName;
            blockConversionInfo.blockID = blockId;
            blockConversionInfo.metadata = (byte)metadata;
            blockConversionInfo.world = world;
            int x = index % 16;
            int y = index / 256 + sectionY;
            int z = index / 16 % 16;
            blockConversionInfo.x = x + chunkXPos + 1;
            blockConversionInfo.y = y;
            blockConversionInfo.z = z + chunkZPos + 1;
            BlockConversionInfo output = BlockReplacementManager.getBlockReplacement(blockConversionInfo, world);
            if (output == null) continue;
            blockArray[index] = (short)output.blockID;
            metadataArray[index] = (short)output.metadata;
        }
    }

    public static void transformTileEntities(NBTTagCompound levelCompoundTag, Chunk chunk, World world) {
        Pair<List<ConversionInfo>, NBTTagList> output = ChunkFixerUtility.adjustTileEntities(levelCompoundTag.func_150295_c("TileEntities", 10), world);
        List conversionInfoList = (List)output.first();
        NBTTagList tileEntities = (NBTTagList)output.second();
        if (tileEntities.func_74745_c() > 0) {
            levelCompoundTag.func_74782_a("TileEntities", (NBTBase)tileEntities);
        }
        for (ExtendedBlockStorage ebs : chunk.func_76587_i()) {
            ChunkFixerUtility.processSection(ebs, conversionInfoList);
        }
    }

    private static void processSection(ExtendedBlockStorage ebs, List<ConversionInfo> conversionInfoList) {
        if (ebs instanceof IExtendedBlockStorageMixin) {
            IExtendedBlockStorageMixin ebsMixin = (IExtendedBlockStorageMixin)ebs;
            int sectionY = ebs.func_76662_d();
            List filteredList = conversionInfoList.stream().filter(info -> info.y >= sectionY && info.y < sectionY + 16).collect(Collectors.toList());
            for (ConversionInfo info2 : filteredList) {
                int localX = info2.x & 0xF;
                int localY = info2.y & 0xF;
                int localZ = info2.z & 0xF;
                ebs.func_150818_a(localX, localY, localZ, info2.blockInfo.block);
                ebs.func_76654_b(localX, localY, localZ, info2.blockInfo.metadata);
            }
        }
    }

    private static Pair<List<ConversionInfo>, NBTTagList> adjustTileEntities(NBTTagList tileEntities, World world) {
        ArrayList<ConversionInfo> conversionInfo = new ArrayList<ConversionInfo>();
        NBTTagList tileEntitiesCopy = new NBTTagList();
        for (int i = 0; i < tileEntities.func_74745_c(); ++i) {
            NBTTagCompound tileEntity = tileEntities.func_150305_b(i);
            String tileEntityId = tileEntity.func_74779_i("id");
            BiFunction<NBTTagCompound, World, BlockInfo> transformationFunction = TileEntityReplacementManager.getTileEntityToNormalBlockTransformerFunction(tileEntityId);
            if (transformationFunction != null) {
                int x = tileEntity.func_74762_e("x");
                int y = tileEntity.func_74762_e("y");
                int z = tileEntity.func_74762_e("z");
                BlockInfo blockInfo = transformationFunction.apply(tileEntity, world);
                if (blockInfo == null) {
                    tileEntitiesCopy.func_74742_a((NBTBase)tileEntity);
                    continue;
                }
                if (blockInfo.tileTransformer != null) {
                    tileEntitiesCopy.func_74742_a((NBTBase)blockInfo.tileTransformer.apply(tileEntity));
                }
                conversionInfo.add(new ConversionInfo(x, y, z, blockInfo));
                continue;
            }
            tileEntitiesCopy.func_74742_a((NBTBase)tileEntity);
        }
        return new Pair(conversionInfo, (Object)tileEntitiesCopy);
    }

    private static class ConversionInfo {
        public final int x;
        public final int y;
        public final int z;
        public final BlockInfo blockInfo;

        public ConversionInfo(int x, int y, int z, BlockInfo blockInfo) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.blockInfo = blockInfo;
        }
    }
}

