/*
 * Decompiled with CFR 0.152.
 */
package xyz.kubasz.personalspace.world;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import xyz.kubasz.personalspace.Config;
import xyz.kubasz.personalspace.PersonalSpaceMod;
import xyz.kubasz.personalspace.world.PersonalWorldProvider;

public class PersonalChunkProvider
implements IChunkProvider {
    private PersonalWorldProvider world;
    private long seed;
    private Random random;
    private WorldGenTrees treeGen = new WorldGenTrees(false, 4, 0, 0, false);
    private String savedBiomeName = null;
    private int savedBiomeId = -1;

    public PersonalChunkProvider(PersonalWorldProvider world, long seed) {
        this.world = world;
        this.seed = seed;
        this.random = new Random(seed);
        if (Config.debugLogging) {
            PersonalSpaceMod.LOG.info("PersonalChunkProvider created for world {}", new Object[]{world.field_76574_g, new Throwable()});
        }
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        Chunk chunk = new Chunk(this.world.field_76579_a, chunkX, chunkZ);
        chunk.field_76643_l = true;
        List<FlatLayerInfo> layers = this.world.getConfig().getLayers();
        int y = 0;
        int worldHeight = this.world.getHeight();
        for (FlatLayerInfo info : layers) {
            Block block = info.func_151536_b();
            if (block == null || block == Blocks.field_150350_a) {
                y += info.func_82657_a();
                continue;
            }
            while (y < info.func_82656_d() + info.func_82657_a() && y < worldHeight) {
                int yChunk = y >> 4;
                ExtendedBlockStorage ebs = chunk.func_76587_i()[yChunk];
                if (ebs == null) {
                    chunk.func_76587_i()[yChunk] = ebs = new ExtendedBlockStorage(y & 0xFFFFFFF0, true);
                }
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        ebs.func_150818_a(x, y & 0xF, z, block);
                    }
                }
                ++y;
            }
            if (y < worldHeight) continue;
            break;
        }
        if (chunkX == 0 && chunkZ == 0) {
            int platformLevel = this.world.func_76557_i();
            int yChunk = platformLevel >> 4;
            ExtendedBlockStorage ebs = chunk.func_76587_i()[yChunk];
            if (ebs == null) {
                chunk.func_76587_i()[yChunk] = ebs = new ExtendedBlockStorage(platformLevel & 0xFFFFFFF0, true);
            }
            for (int z = 4; z < 13; ++z) {
                for (int x = 4; x < 13; ++x) {
                    ebs.func_150818_a(x, platformLevel & 0xF, z, (Block)Blocks.field_150334_T);
                }
            }
        }
        if (this.savedBiomeId < 0 || !Objects.equals(this.savedBiomeName, this.world.getConfig().getBiomeId())) {
            this.savedBiomeName = this.world.getConfig().getBiomeId();
            this.savedBiomeId = this.world.getConfig().getRawBiomeId();
        }
        Arrays.fill(chunk.func_76605_m(), (byte)this.savedBiomeId);
        chunk.func_76603_b();
        return chunk;
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public void func_73153_a(IChunkProvider provider, int chunkX, int chunkZ) {
        BiomeGenBase biome = this.world.field_76579_a.func_72807_a(chunkX * 16 + 16, chunkZ * 16 + 16);
        this.random.setSeed(this.seed);
        long i1 = this.random.nextLong() / 2L * 2L + 1L;
        long j1 = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.seed);
        if (this.world.getConfig().isGeneratingVegetation()) {
            biome.func_76728_a(this.world.field_76579_a, this.random, chunkX * 16, chunkZ * 16);
        }
        if (this.world.getConfig().isGeneratingTrees() && TerrainGen.decorate((World)this.world.field_76579_a, (Random)this.random, (int)(chunkX * 16), (int)(chunkZ * 16), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            int x = chunkX * 16 + this.random.nextInt(16) + 8;
            int z = chunkZ * 16 + this.random.nextInt(16) + 8;
            int y = this.world.field_76579_a.func_72976_f(x, z);
            WorldGenAbstractTree worldgenabstracttree = BiomeGenBase.field_76772_c.func_150567_a(this.random);
            worldgenabstracttree.func_76487_a(1.0, 1.0, 1.0);
            if (worldgenabstracttree.func_76484_a(this.world.field_76579_a, this.random, x, y, z)) {
                worldgenabstracttree.func_150524_b(this.world.field_76579_a, this.random, x, y, z);
            }
        }
    }

    public boolean func_73151_a(boolean saveAllChunks, IProgressUpdate progress) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "PersonalWorldSource";
    }

    public List<BiomeGenBase.SpawnListEntry> func_73155_a(EnumCreatureType type, int x, int y, int z) {
        return Collections.emptyList();
    }

    public ChunkPosition func_147416_a(World world, String structureType, int x, int y, int z) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int x, int z) {
    }

    public void func_104112_b() {
    }
}

