/*
 * Decompiled with CFR 0.152.
 */
package xyz.kubasz.personalspace.gui;

import java.awt.Rectangle;
import java.util.function.DoubleConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;
import xyz.kubasz.personalspace.gui.Icons;
import xyz.kubasz.personalspace.gui.Widget;

public class WSlider
extends Widget {
    @Nonnull
    String text = "";
    public boolean dropShadow = true;
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    public int color = 0xFFFFFF;
    public Icons buttonIcon = null;
    public double minValue = 0.0;
    public double maxValue = 1.0;
    public double rawValue = 0.5;
    public double step = 0.1;
    public DoubleConsumer onChange = null;

    public WSlider() {
    }

    public WSlider(Rectangle position, String text, double min, double max, double val, double step, boolean dropShadow, int color, Icons buttonIcon, DoubleConsumer onChange) {
        this.position = position;
        this.dropShadow = dropShadow;
        this.color = color;
        this.onChange = onChange;
        this.buttonIcon = buttonIcon;
        this.minValue = min;
        this.maxValue = max;
        this.rawValue = val;
        this.step = step;
        this.setText(text);
    }

    public double getValue() {
        return this.step > 1.0E-6 ? (double)Math.round(this.rawValue / this.step) * this.step : this.rawValue;
    }

    public int getValueInt() {
        return (int)this.getValue();
    }

    public double value01() {
        return MathHelper.func_151237_a((double)((this.rawValue - this.minValue) / Math.max(this.maxValue - this.minValue, 1.0E-6)), (double)0.0, (double)1.0);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
    }

    @Override
    protected void drawImpl(int mouseX, int mouseY, float partialTicks) {
        String text;
        Icons icon;
        Icons.bindTexture();
        Icons icons = icon = this.enabled ? Icons.BUTTON_NORMAL : Icons.BUTTON_OFF;
        if (this.enabled && this.testPoint(mouseX, mouseY)) {
            icon = Icons.BUTTON_HIGHLIGHT;
        }
        Icons.BUTTON_OFF.draw9Patch(0, 0, this.position.width, this.position.height);
        icon.draw9Patch((int)(this.value01() * (double)(this.position.width - 15)), 0, 15, this.position.height);
        int textSpace = this.position.width - 6;
        if (this.buttonIcon != null) {
            textSpace -= this.buttonIcon.w;
            this.buttonIcon.drawAt(4, this.position.height / 2 - this.buttonIcon.h / 2 - 1);
        }
        if (!(text = this.text).isEmpty()) {
            if (text.contains("%")) {
                text = String.format(text, this.rawValue);
            }
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            String drawText = fr.func_78269_a(text, textSpace - 6);
            int textW = fr.func_78256_a(drawText);
            fr.func_85187_a(drawText, this.position.width - textSpace / 2 - textW / 2, this.position.height / 2 - fr.field_78288_b / 2, this.color, this.dropShadow);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    protected boolean mouseClickedImpl(int x, int y, int button) {
        this.clickSound();
        return this.mouseMovedOrUpImpl(x, y, button);
    }

    @Override
    protected boolean mouseMovedOrUpImpl(int x, int y, int button) {
        double newVal01 = MathHelper.func_151237_a((double)((double)(x - this.position.x - 3) / (double)(this.position.width - 6)), (double)0.0, (double)1.0);
        double newVal = this.minValue + newVal01 * (this.maxValue - this.minValue);
        double oldVal = this.rawValue;
        this.rawValue = newVal;
        this.rawValue = this.getValue();
        if (Math.abs(newVal - oldVal) > 1.0E-6 && this.onChange != null) {
            this.onChange.accept(this.rawValue);
        }
        return true;
    }

    @Override
    protected boolean mouseClickMoveImpl(int x, int y, int lastBtn, long timeDragged) {
        return this.dragged ? this.mouseMovedOrUpImpl(x, y, lastBtn) : false;
    }
}

