/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.personalspace;

import appeng.api.AEApi;
import appeng.api.IAppEngApi;
import appeng.api.features.IWorldGen;
import codechicken.lib.packet.PacketCustom;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkHandshakeEstablished;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.eigenraven.personalspace.CommonProxy;
import me.eigenraven.personalspace.PersonalSpaceCommand;
import me.eigenraven.personalspace.block.PortalBlock;
import me.eigenraven.personalspace.block.PortalEntityItem;
import me.eigenraven.personalspace.block.PortalItem;
import me.eigenraven.personalspace.block.PortalTileEntity;
import me.eigenraven.personalspace.net.Packets;
import me.eigenraven.personalspace.world.DimensionConfig;
import me.eigenraven.personalspace.world.PersonalWorldProvider;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="personalspace", version="1.0.24", name="PersonalSpace", acceptedMinecraftVersions="[1.7.10]", dependencies="after:utilityworlds;after:appliedenergistics2-core;after:GalaxySpace;after:Thaumcraft")
public class PersonalSpaceMod {
    public static final String DIM_METADATA_FILE = "personalspace_metadata.cfg";
    @Mod.Instance
    public static PersonalSpaceMod INSTANCE;
    public static Logger LOG;
    @SidedProxy(clientSide="me.eigenraven.personalspace.ClientProxy", serverSide="me.eigenraven.personalspace.CommonProxy")
    public static CommonProxy proxy;
    public static PortalBlock BLOCK_PORTAL;
    public static PortalBlock BP_MIGRATION_2;
    public static PortalBlock BP_MIGRATION_3;
    public static PortalBlock BP_MIGRATION_4;
    public static final String CHANNEL = "personalspace";
    public static List<String> clientAllowedBlocks;
    public static List<String> clientAllowedBiomes;
    private static final String NATURA_MODID = "Natura";
    private static final String NATURA_IMC = "set-worldgen-overrides";
    private static final String NATURA_IMC_DIMS = "dimensions";
    private static final String NATURA_IMC_SETS = "settings";
    private static final int NATURA_DIM_WORLDGEN_CROP_BIT = 1;
    private static final int NATURA_DIM_WORLDGEN_CLOUD_BIT = 2;
    private static final int NATURA_DIM_WORLDGEN_TREE_BIT = 4;
    private static final String THAUMCRAFT_MODID = "Thaumcraft";
    private static Field thaumcraftDimensionBlacklist;
    private static boolean thermosLogged;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"utilityworlds")) {
            throw new RuntimeException("Personal space mod cannot be loaded in the same instance with utilityworlds mod, because it replaces its functionality");
        }
        if (event.getSide().isClient()) {
            PacketCustom.assignHandler((Object)CHANNEL, (PacketCustom.ICustomPacketHandler)((PacketCustom.IClientPacketHandler)Packets.INSTANCE::handleClientPacket));
        }
        PacketCustom.assignHandler((Object)CHANNEL, (PacketCustom.ICustomPacketHandler)((PacketCustom.IServerPacketHandler)Packets.INSTANCE::handleServerPacket));
        NetworkRegistry.INSTANCE.newEventDrivenChannel("personalspace_event").register((Object)this);
        proxy.preInit(event);
        BLOCK_PORTAL = new PortalBlock(false);
        BP_MIGRATION_2 = new PortalBlock(true);
        BP_MIGRATION_3 = new PortalBlock(true);
        BP_MIGRATION_4 = new PortalBlock(true);
        GameRegistry.registerBlock((Block)BLOCK_PORTAL, PortalItem.class, (String)"personalPortal");
        GameRegistry.registerBlock((Block)BP_MIGRATION_2, PortalItem.class, (String)"personalPortal_migration2");
        GameRegistry.registerBlock((Block)BP_MIGRATION_3, PortalItem.class, (String)"personalPortal_migration3");
        GameRegistry.registerBlock((Block)BP_MIGRATION_4, PortalItem.class, (String)"personalPortal_migration4");
        GameRegistry.registerTileEntityWithAlternatives(PortalTileEntity.class, (String)"personalspace:personalPortal", (String[])new String[]{"uw_portal_te"});
        EntityRegistry.registerModEntity(PortalEntityItem.class, (String)"PortalItem", (int)1, (Object)this, (int)64, (int)20, (boolean)true);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        if (Loader.isModLoaded((String)"appliedenergistics2-core")) {
            this.removeAe2Meteors();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Optional.Method(modid="appliedenergistics2-core")
    private void removeAe2Meteors() {
        IAppEngApi aeApi = AEApi.instance();
        if (aeApi == null) {
            return;
        }
        aeApi.registries().worldgen().disableWorldGenForProviderID(IWorldGen.WorldGenType.Meteorites, PersonalWorldProvider.class);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        proxy.serverAboutToStart(event);
        this.loadDimensionConfigs();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        proxy.serverStarting(event);
        event.registerServerCommand((ICommand)new PersonalSpaceCommand());
    }

    void loadDimensionConfigs() {
        try {
            this.deregisterDimensions(false);
            File saveDir = DimensionManager.getCurrentSaveRootDirectory();
            if (saveDir == null || !saveDir.isDirectory()) {
                return;
            }
            LOG.info("Searching for PS worlds at {}", new Object[]{saveDir.getPath()});
            for (File dir : Objects.requireNonNull(saveDir.listFiles())) {
                if (!dir.isDirectory()) continue;
                File dimConfig = new File(dir, DIM_METADATA_FILE);
                if (dimConfig.exists() && dimConfig.isFile()) {
                    try {
                        DimensionConfig dimCfg = new DimensionConfig();
                        int dimId = dimCfg.syncWithFile(dimConfig, false, 0);
                        dimCfg.setSaveDirOverride(dir.getName());
                        dimCfg.registerWithDimensionManager(dimId, false);
                        LOG.info("Loaded PersonalSpace world {} (at {})", new Object[]{dimId, dir.getName()});
                    }
                    catch (Exception e) {
                        LOG.error("Couldn't load personal dimension data from " + dimConfig.getPath(), (Throwable)e);
                    }
                    continue;
                }
                MutablePair<DimensionConfig, Integer> dc = DimensionConfig.fromUtilityWorldsWorld(dir.getName());
                if (dc == null) continue;
                ((DimensionConfig)dc.getLeft()).registerWithDimensionManager((Integer)dc.getRight(), false);
                this.saveConfig((Integer)dc.getRight(), (DimensionConfig)dc.getLeft());
                LOG.info("Migrated world {} (at {}) from utilityworlds", new Object[]{dc.getRight(), dir.getName()});
            }
            this.bulkDimSettingsUpdate();
        }
        catch (Exception e) {
            LOG.error("Caught error while loading and registering personal space dimensions", (Throwable)e);
        }
    }

    private void saveConfig(int dimId, DimensionConfig config) throws IOException {
        File saveDir = DimensionManager.getCurrentSaveRootDirectory();
        if (saveDir == null || !saveDir.isDirectory()) {
            return;
        }
        if (!((saveDir = new File(saveDir, config.getSaveDir(dimId))).exists() && saveDir.isDirectory() || saveDir.mkdirs())) {
            throw new IOException("Couldn't create save directory for personal dimension " + config.getSaveDir(dimId));
        }
        File dataFile = new File(saveDir, DIM_METADATA_FILE);
        config.syncWithFile(dataFile, true, dimId);
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        try {
            WorldProvider worldProvider = event.world.field_73011_w;
            if (!(worldProvider instanceof PersonalWorldProvider)) {
                return;
            }
            PersonalWorldProvider provider = (PersonalWorldProvider)worldProvider;
            DimensionConfig config = provider.getConfig();
            if (config == null || !config.needsSaving()) {
                return;
            }
            this.saveConfig(provider.field_76574_g, config);
        }
        catch (Exception e) {
            LOG.fatal("Couldn't save personal dimension data for " + event.world.field_73011_w.func_80007_l(), (Throwable)e);
        }
    }

    private static int naturaConfigForDim(DimensionConfig config) {
        int gen = 0;
        if (config.isGeneratingVegetation()) {
            gen |= 1;
            gen |= 2;
        }
        if (config.isGeneratingTrees()) {
            gen |= 4;
        }
        return gen;
    }

    private static HashMap<Integer, Integer> getThaumcraftDimensionBlacklist() {
        if (Loader.isModLoaded((String)THAUMCRAFT_MODID)) {
            try {
                if (thaumcraftDimensionBlacklist == null) {
                    Class<?> klass = Class.forName("thaumcraft.common.lib.world.ThaumcraftWorldGenerator");
                    thaumcraftDimensionBlacklist = klass.getField("dimensionBlacklist");
                }
                return (HashMap)thaumcraftDimensionBlacklist.get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private void bulkDimSettingsUpdate() {
        TIntArrayList dimIds = new TIntArrayList();
        TIntArrayList dimNaturaGens = new TIntArrayList();
        HashMap<Integer, Integer> tcBlacklist = PersonalSpaceMod.getThaumcraftDimensionBlacklist();
        CommonProxy.getDimensionConfigObjects(false).forEachEntry((dimId, config) -> {
            if (config == null) {
                return true;
            }
            dimIds.add(dimId);
            dimNaturaGens.add(PersonalSpaceMod.naturaConfigForDim(config));
            if (tcBlacklist != null) {
                if (config.isGeneratingTrees()) {
                    tcBlacklist.remove(dimId);
                } else {
                    tcBlacklist.put(dimId, 0);
                }
            }
            return true;
        });
        if (Loader.isModLoaded((String)NATURA_MODID) && !dimIds.isEmpty()) {
            NBTTagCompound naturaImc = new NBTTagCompound();
            naturaImc.func_74783_a(NATURA_IMC_DIMS, dimIds.toArray());
            naturaImc.func_74783_a(NATURA_IMC_SETS, dimNaturaGens.toArray());
            FMLInterModComms.sendRuntimeMessage((Object)this, (String)NATURA_MODID, (String)NATURA_IMC, (NBTTagCompound)naturaImc);
        }
    }

    public void onDimSettingsChangeServer(int dimId) {
        DimensionConfig config = DimensionConfig.getForDimension(dimId, false);
        if (config == null) {
            return;
        }
        HashMap<Integer, Integer> tcBlacklist = PersonalSpaceMod.getThaumcraftDimensionBlacklist();
        if (tcBlacklist != null) {
            if (config.isGeneratingTrees()) {
                tcBlacklist.remove(dimId);
            } else {
                tcBlacklist.put(dimId, 0);
            }
        }
        if (Loader.isModLoaded((String)NATURA_MODID)) {
            NBTTagCompound naturaImc = new NBTTagCompound();
            naturaImc.func_74783_a(NATURA_IMC_DIMS, new int[]{dimId});
            naturaImc.func_74783_a(NATURA_IMC_SETS, new int[]{PersonalSpaceMod.naturaConfigForDim(config)});
            FMLInterModComms.sendRuntimeMessage((Object)this, (String)NATURA_MODID, (String)NATURA_IMC, (NBTTagCompound)naturaImc);
        }
    }

    public static boolean isInThermos() {
        try {
            Class.forName("thermos.ThermosRemapper");
            if (!thermosLogged) {
                thermosLogged = true;
                LOG.warn("Thermos detected, applying workarounds");
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            if (!thermosLogged) {
                thermosLogged = true;
                LOG.info("Thermos not detected");
            }
            return false;
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        proxy.serverStarted(event);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        proxy.serverStopping(event);
        TIntObjectHashMap<DimensionConfig> configs = CommonProxy.getDimensionConfigObjects(false);
        configs.forEachEntry((dimId, dimCfg) -> {
            if (dimCfg == null || !dimCfg.needsSaving()) {
                return true;
            }
            try {
                this.saveConfig(dimId, (DimensionConfig)dimCfg);
            }
            catch (IOException e) {
                LOG.error("Couldn't save dimension " + dimId, (Throwable)e);
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterDimensions(boolean isClient) {
        TIntObjectHashMap<DimensionConfig> tIntObjectHashMap = CommonProxy.getDimensionConfigObjects(isClient);
        synchronized (tIntObjectHashMap) {
            CommonProxy.getDimensionConfigObjects(isClient).forEachEntry((dimId, dimCfg) -> {
                if (DimensionManager.isDimensionRegistered((int)dimId)) {
                    FMLLog.info((String)"Deregistering PersonalSpace dimension %d", (Object[])new Object[]{dimId});
                    DimensionManager.unregisterDimension((int)dimId);
                    if (DimensionManager.unregisterProviderType((int)dimId).length > 0) {
                        FMLLog.severe((String)"PersonalSpace dimension id %d has other dimension ids registered for the same provider", (Object[])new Object[]{dimId});
                    }
                }
                return true;
            });
            CommonProxy.getDimensionConfigObjects(isClient).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        proxy.serverStopped(event);
        this.deregisterDimensions(false);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.deregisterDimensions(true);
            TIntObjectHashMap<DimensionConfig> tIntObjectHashMap = CommonProxy.getDimensionConfigObjects(true);
            synchronized (tIntObjectHashMap) {
                CommonProxy.getDimensionConfigObjects(true).clear();
            }
        }
    }

    @SubscribeEvent
    public void netEventHandler(FMLNetworkEvent.CustomNetworkEvent event) {
        Object object = event.wrappedEvent;
        if (object instanceof NetworkHandshakeEstablished) {
            NetworkHandshakeEstablished hs = (NetworkHandshakeEstablished)object;
            INetHandler iNetHandler = hs.netHandler;
            if (iNetHandler instanceof NetHandlerPlayServer) {
                NetHandlerPlayServer netHandler = (NetHandlerPlayServer)iNetHandler;
                PacketCustom pkt = Packets.INSTANCE.sendWorldList();
                netHandler.func_147359_a((Packet)pkt.toPacket());
            }
        }
    }

    @SubscribeEvent
    public void clientDisconnectionHandler(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.deregisterDimensions(true);
        this.deregisterDimensions(false);
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            if (mapping.type == GameRegistry.Type.BLOCK) {
                switch (mapping.name) {
                    case "utilityworlds:uw_portal_mining": {
                        mapping.remap(GameRegistry.findBlock((String)CHANNEL, (String)"personalPortal"));
                        break;
                    }
                    case "utilityworlds:uw_portal_void": {
                        mapping.remap(GameRegistry.findBlock((String)CHANNEL, (String)"personalPortal_migration2"));
                        break;
                    }
                    case "utilityworlds:uw_portal_garden": {
                        mapping.remap(GameRegistry.findBlock((String)CHANNEL, (String)"personalPortal_migration3"));
                        break;
                    }
                    case "utilityworlds:uw_portal_return": {
                        mapping.remap(GameRegistry.findBlock((String)CHANNEL, (String)"personalPortal_migration4"));
                        break;
                    }
                }
                continue;
            }
            if (mapping.type != GameRegistry.Type.ITEM) continue;
            switch (mapping.name) {
                case "utilityworlds:uw_portal_mining": {
                    mapping.remap(GameRegistry.findItem((String)CHANNEL, (String)"personalPortal"));
                    break;
                }
                case "utilityworlds:uw_portal_void": {
                    mapping.remap(GameRegistry.findItem((String)CHANNEL, (String)"personalPortal_migration2"));
                    break;
                }
                case "utilityworlds:uw_portal_garden": {
                    mapping.remap(GameRegistry.findItem((String)CHANNEL, (String)"personalPortal_migration3"));
                    break;
                }
                case "utilityworlds:uw_portal_return": {
                    mapping.remap(GameRegistry.findItem((String)CHANNEL, (String)"personalPortal_migration4"));
                    break;
                }
            }
        }
    }

    public static void debug(String message) {
        LOG.debug(message);
    }

    public static void info(String message) {
        LOG.info(message);
    }

    public static void warn(String message) {
        LOG.warn(message);
    }

    public static void error(String message) {
        LOG.error(message);
    }

    static {
        LOG = LogManager.getLogger((String)CHANNEL);
        clientAllowedBlocks = Lists.newArrayList();
        clientAllowedBiomes = Lists.newArrayList();
        thaumcraftDimensionBlacklist = null;
        thermosLogged = false;
    }
}

