/*
 * Decompiled with CFR 0.152.
 */
package locusway.overloadedarmorbar.overlay;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import locusway.overloadedarmorbar.ConfigurationHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import org.lwjgl.opengl.GL11;

public class ArmorBarRenderer
extends Gui {
    private static final int UNKNOWN_ARMOR_VALUE = -1;
    private static final int ARMOR_ICON_SIZE = 9;
    private static final int ARMOR_FIRST_HALF_WIDTH = 5;
    private static final int ARMOR_SECOND_HALF_WIDTH = 4;
    private static final ArmorIcon[] armorIcons = new ArmorIcon[10];
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static int previousArmorValue = -1;

    public static void forceUpdate() {
        previousArmorValue = -1;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ARMOR) {
            return;
        }
        ArmorBarRenderer.mc.field_71424_I.func_76320_a("armor");
        GL11.glEnable((int)3042);
        int currentArmorValue = ForgeHooks.getTotalArmorValue((EntityPlayer)ArmorBarRenderer.mc.field_71439_g);
        int left = event.resolution.func_78326_a() / 2 - 91;
        int top = event.resolution.func_78328_b() - GuiIngameForge.left_height;
        if (currentArmorValue != previousArmorValue) {
            ArmorBarRenderer.updateArmorIcons(currentArmorValue);
            previousArmorValue = currentArmorValue;
        }
        int colorState = 0xFFFFFF;
        block5: for (int i = 0; i < armorIcons.length; ++i) {
            ArmorIcon icon = armorIcons[i];
            int xPosition = left + i * 8;
            switch (icon.iconType) {
                case EMPTY: {
                    colorState = ArmorBarRenderer.setColor(icon.mainColor, colorState);
                    this.func_73729_b(xPosition, top, 16, 9, 9, 9);
                    continue block5;
                }
                case FULL: {
                    colorState = ArmorBarRenderer.setColor(icon.mainColor, colorState);
                    this.func_73729_b(xPosition, top, 34, 9, 9, 9);
                    continue block5;
                }
                case HALF: {
                    colorState = ArmorBarRenderer.setColor(icon.mainColor, colorState);
                    this.func_73729_b(xPosition, top, 25, 9, 5, 9);
                    colorState = ArmorBarRenderer.setColor(icon.secondaryColor, colorState);
                    int textureX = currentArmorValue > 20 ? 39 : 30;
                    this.func_73729_b(xPosition + 5, top, textureX, 9, 4, 9);
                    continue block5;
                }
            }
        }
        if (colorState != 0xFFFFFF) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GuiIngameForge.left_height += 10;
        GL11.glDisable((int)3042);
        ArmorBarRenderer.mc.field_71424_I.func_76319_b();
        event.setCanceled(true);
    }

    private static int setColor(int color, int colorState) {
        if (colorState == color) {
            return colorState;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        return color;
    }

    private static void updateArmorIcons(int armorPoints) {
        int scale = armorPoints / 20;
        int counter = armorPoints - scale * 20;
        if (scale > 0 && counter == 0) {
            --scale;
            counter = 20;
        }
        for (int i = 0; i < armorIcons.length; ++i) {
            if (armorIcons[i] == null) {
                ArmorBarRenderer.armorIcons[i] = new ArmorIcon();
            }
            armorIcons[i].updateColors(scale, counter);
            if (counter >= 2) {
                ArmorBarRenderer.armorIcons[i].iconType = ArmorIcon.Type.FULL;
                counter -= 2;
                continue;
            }
            if (counter == 1) {
                ArmorBarRenderer.armorIcons[i].iconType = ArmorIcon.Type.HALF;
                --counter;
                continue;
            }
            ArmorBarRenderer.armorIcons[i].iconType = armorPoints > 20 ? ArmorIcon.Type.FULL : (ConfigurationHandler.showEmptyArmorIcons && armorPoints > 0 || ConfigurationHandler.alwaysShowArmorBar ? ArmorIcon.Type.EMPTY : ArmorIcon.Type.NONE);
        }
    }

    static class ArmorIcon {
        public Type iconType;
        public int mainColor = 0xFFFFFF;
        public int secondaryColor = 0xFFFFFF;

        ArmorIcon() {
        }

        public void updateColors(int scale, int armorValue) {
            int currentScale = scale;
            int previousScale = scale - 1;
            int arrayLength = ConfigurationHandler.colorValuesI.length;
            currentScale = Math.min(arrayLength - 1, currentScale);
            previousScale = Math.min(arrayLength - 1, previousScale);
            previousScale = Math.max(0, previousScale);
            if (armorValue >= 1) {
                this.mainColor = ConfigurationHandler.colorValuesI[currentScale];
            }
            if (armorValue == 1) {
                this.secondaryColor = ConfigurationHandler.colorValuesI[previousScale];
            }
            if (armorValue == 0) {
                this.mainColor = ConfigurationHandler.colorValuesI[previousScale];
            }
        }

        public static enum Type {
            EMPTY,
            FULL,
            HALF,
            NONE;

        }
    }
}

