/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.tileentity;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.common.entity.Drone;
import li.cil.oc.common.inventory.Inventory;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.items.ItemRFIDCard;
import pcl.opensecurity.tileentity.TileEntityMachineBase;

public class TileEntityRFIDReader
extends TileEntityMachineBase
implements Environment {
    public String data;
    public UUID uuid;
    protected ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(TileEntityRFIDReader.getComponentName()).withConnector(32.0).create();

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    private static String getComponentName() {
        return "os_rfidreader";
    }

    public void onConnect(Node arg0) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message arg0) {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
    }

    private HashMap<String, Object> info(Entity entity, String data, String uuid, boolean locked) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        double rangeToEntity = entity.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        String name = entity instanceof EntityPlayerMP ? ((EntityPlayer)entity).getDisplayName() : entity.func_70005_c_();
        this.node.sendToReachable("computer.signal", new Object[]{"rfidData", name, rangeToEntity, data, uuid});
        value.put("name", name);
        value.put("range", rangeToEntity);
        value.put("data", data);
        value.put("uuid", uuid);
        value.put("locked", locked);
        return value;
    }

    public HashMap<Integer, HashMap<String, Object>> scan(int range) {
        boolean found = false;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, block, 20);
        HashMap<Integer, HashMap<String, Object>> output = new HashMap<Integer, HashMap<String, Object>>();
        int index = 1;
        List e = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + range), (double)(this.field_145848_d + range), (double)(this.field_145849_e + range)));
        if (!e.isEmpty()) {
            for (int i = 0; i <= e.size() - 1; ++i) {
                NBTTagCompound tag;
                String localUUID;
                ItemStack st;
                int k;
                int size;
                EntityPlayer em;
                Entity entity = (Entity)e.get(i);
                if (entity instanceof EntityPlayerMP) {
                    found = true;
                    em = (EntityPlayer)entity;
                    ItemStack[] playerInventory = em.field_71071_by.field_70462_a;
                    size = playerInventory.length;
                    for (k = 0; k < size; ++k) {
                        st = em.field_71071_by.func_70301_a(k);
                        if (st == null || !(st.func_77973_b() instanceof ItemRFIDCard) || st.field_77990_d == null || !st.field_77990_d.func_74764_b("data")) continue;
                        localUUID = !OpenSecurity.ignoreUUIDs ? st.field_77990_d.func_74779_i("uuid") : "-1";
                        output.put(index++, this.info(entity, st.field_77990_d.func_74779_i("data"), localUUID, st.field_77990_d.func_74767_n("locked")));
                    }
                } else if (entity instanceof Drone) {
                    found = true;
                    em = (Drone)entity;
                    Inventory droneInventory = em.mainInventory();
                    size = em.inventorySize();
                    for (k = 0; k < size; ++k) {
                        st = droneInventory.func_70301_a(k);
                        if (st == null || !(st.func_77973_b() instanceof ItemRFIDCard) || st.field_77990_d == null || !st.field_77990_d.func_74764_b("data")) continue;
                        localUUID = !OpenSecurity.ignoreUUIDs ? st.field_77990_d.func_74779_i("uuid") : "-1";
                        output.put(index++, this.info(entity, st.field_77990_d.func_74779_i("data"), localUUID, st.field_77990_d.func_74767_n("locked")));
                    }
                }
                if (!(tag = entity.getEntityData().func_74775_l("rfidData")).func_74764_b("data")) continue;
                found = true;
                String localUUID2 = !OpenSecurity.ignoreUUIDs ? tag.func_74779_i("uuid") : "-1";
                output.put(index++, this.info(entity, tag.func_74779_i("data"), localUUID2, tag.func_74767_n("locked")));
            }
        }
        if (found) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 3);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, 3);
        }
        return output;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.node != null && this.node.network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    @Callback
    public Object[] greet(Context context, Arguments args) {
        return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
    }

    @Callback(doc="function(optional:int:range):string; pushes a signal \"rfidData\" for each found rfid on all players in range, optional set range.")
    public Object[] scan(Context context, Arguments args) {
        int range = args.optInteger(0, OpenSecurity.rfidRange);
        if (range > OpenSecurity.rfidRange) {
            range = OpenSecurity.rfidRange;
        }
        if (this.node.changeBuffer((double)(-5 * (range /= 2))) == 0.0) {
            return new Object[]{this.scan(range)};
        }
        return new Object[]{false, "Not enough power in OC Network."};
    }
}

