/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.data;

import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.utility.Config;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.MathHelper;

public class NutrientManager {
    private final Map<Nutrient, Float> nutrition = new HashMap<Nutrient, Float>();

    public NutrientManager() {
        this(new HashMap<Nutrient, Float>());
    }

    public NutrientManager(Map<Nutrient, Float> nutrientData) {
        this.update(nutrientData);
    }

    public Map<Nutrient, Float> get() {
        return this.nutrition;
    }

    public Float get(Nutrient nutrient) {
        return this.nutrition.get(nutrient);
    }

    public void set(Nutrient nutrient, Float value) {
        this.nutrition.put(nutrient, value);
    }

    public void set(Map<Nutrient, Float> nutrientData) {
        this.nutrition.putAll(nutrientData);
    }

    public void add(Nutrient nutrient, float amount) {
        float currentAmount = this.nutrition.get(nutrient).floatValue();
        this.nutrition.put(nutrient, Float.valueOf(MathHelper.func_76131_a((float)(currentAmount + amount), (float)0.0f, (float)100.0f)));
    }

    public void add(List<Nutrient> nutrientData, float amount) {
        for (Nutrient nutrient : nutrientData) {
            this.nutrition.put(nutrient, Float.valueOf(MathHelper.func_76131_a((float)(this.nutrition.get(nutrient).floatValue() + amount), (float)0.0f, (float)100.0f)));
        }
    }

    public void subtract(Nutrient nutrient, float amount) {
        float currentAmount = this.nutrition.get(nutrient).floatValue();
        this.nutrition.put(nutrient, Float.valueOf(MathHelper.func_76131_a((float)(currentAmount - amount), (float)0.0f, (float)100.0f)));
    }

    public void subtract(List<Nutrient> nutrientData, float amount) {
        for (Nutrient nutrient : nutrientData) {
            this.nutrition.put(nutrient, Float.valueOf(MathHelper.func_76131_a((float)(this.nutrition.get(nutrient).floatValue() - amount), (float)0.0f, (float)100.0f)));
        }
    }

    public void reset(Nutrient nutrient) {
        this.set(nutrient, Float.valueOf(Config.startingNutrition));
    }

    public void reset() {
        for (Nutrient nutrient : this.nutrition.keySet()) {
            this.reset(nutrient);
        }
    }

    public void update() {
        this.update(this.nutrition);
    }

    public void update(Map<Nutrient, Float> data) {
        HashMap<Nutrient, Float> nutritionOld = new HashMap<Nutrient, Float>(data);
        this.nutrition.clear();
        block0: for (Nutrient nutrient : NutrientList.get()) {
            for (Map.Entry nutrientOld : nutritionOld.entrySet()) {
                if (!nutrient.name.equals(((Nutrient)nutrientOld.getKey()).name)) continue;
                this.nutrition.put(nutrient, (Float)nutrientOld.getValue());
                continue block0;
            }
            this.nutrition.put(nutrient, Float.valueOf(Config.startingNutrition));
        }
    }
}

