/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.events;

import ca.wescook.nutrition.data.PlayerDataHandler;
import ca.wescook.nutrition.effects.EffectsManager;
import ca.wescook.nutrition.gui.ModGuiHandler;
import ca.wescook.nutrition.network.Sync;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.nutrients.NutrientUtils;
import ca.wescook.nutrition.proxy.ClientProxy;
import ca.wescook.nutrition.utility.Config;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class EventWorldTick {
    private final Map<Pair<EntityPlayer, Boolean>, Integer> playerFoodLevels = new HashMap<Pair<EntityPlayer, Boolean>, Integer>();
    private int potionCounter = 0;

    @SubscribeEvent
    public void serverTickEvent(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Config.enableDecay) {
            for (EntityPlayer player : event.world.field_73010_i) {
                this.nutritionDecay(player);
            }
        }
        this.potionTicking(event.world);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        int hungerModified = ClientProxy.getUnappliedHungerValues();
        if (hungerModified > 0) {
            float amountToChange = NutrientUtils.getNutrientValue(hungerModified, NutrientList.get().size());
            Sync.normalizeOnServer(amountToChange);
        }
    }

    private void nutritionDecay(EntityPlayer player) {
        ImmutablePair playerSidedID = new ImmutablePair((Object)player, (Object)player.func_130014_f_().field_72995_K);
        int foodLevelNew = player.func_71024_bL().func_75116_a();
        Integer foodLevelOld = this.playerFoodLevels.get(playerSidedID);
        if (foodLevelOld != null && foodLevelNew < foodLevelOld) {
            int difference = foodLevelOld - foodLevelNew;
            if (!player.func_130014_f_().field_72995_K) {
                Map<Nutrient, Float> playerNutrition = PlayerDataHandler.getForPlayer(player).get();
                this.calculateDecay(playerNutrition, difference);
            } else {
                Map<Nutrient, Float> playerNutrition = ClientProxy.localNutrition.get();
                this.calculateDecay(playerNutrition, difference);
                GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
                if (currentScreen != null && currentScreen.equals((Object)ModGuiHandler.nutritionGui)) {
                    ModGuiHandler.nutritionGui.redrawLabels();
                }
            }
        }
        this.playerFoodLevels.put((Pair<EntityPlayer, Boolean>)playerSidedID, foodLevelNew);
    }

    private void calculateDecay(Map<Nutrient, Float> playerNutrition, int difference) {
        for (Map.Entry<Nutrient, Float> entry : playerNutrition.entrySet()) {
            float decay = (float)((double)difference * 0.075 * (double)entry.getKey().decay);
            entry.setValue(Float.valueOf(MathHelper.func_76131_a((float)(entry.getValue().floatValue() - decay), (float)0.0f, (float)100.0f)));
        }
    }

    private void potionTicking(World world) {
        if (this.potionCounter > 110) {
            for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
                EffectsManager.reapplyEffects(player);
            }
            this.potionCounter = 0;
        }
        if (world.field_73011_w.field_76574_g == 0) {
            ++this.potionCounter;
        }
    }
}

